/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.profiling;

import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EAmbiguous;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EBinary;
import org.simantics.scl.compiler.elaboration.expressions.EBind;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.ECHRRuleset;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ECoveringBranchPoint;
import org.simantics.scl.compiler.elaboration.expressions.EEnforce;
import org.simantics.scl.compiler.elaboration.expressions.EEntityTypeAnnotation;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.EGetConstraint;
import org.simantics.scl.compiler.elaboration.expressions.EIf;
import org.simantics.scl.compiler.elaboration.expressions.EIntegerLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ELambdaType;
import org.simantics.scl.compiler.elaboration.expressions.ELet;
import org.simantics.scl.compiler.elaboration.expressions.EListComprehension;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.EPlaceholder;
import org.simantics.scl.compiler.elaboration.expressions.EPreLet;
import org.simantics.scl.compiler.elaboration.expressions.EPreRuleset;
import org.simantics.scl.compiler.elaboration.expressions.ERange;
import org.simantics.scl.compiler.elaboration.expressions.ERealLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ERecord;
import org.simantics.scl.compiler.elaboration.expressions.ERuleset;
import org.simantics.scl.compiler.elaboration.expressions.ESelect;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EStringLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ETransformation;
import org.simantics.scl.compiler.elaboration.expressions.ETypeAnnotation;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.EWhen;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpressionGroup;
import org.simantics.scl.compiler.elaboration.expressions.StandardExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.block.BindStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.RuleStatement;
import org.simantics.scl.compiler.elaboration.expressions.list.ListAssignment;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGenerator;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGuard;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListSeq;
import org.simantics.scl.compiler.elaboration.expressions.list.ListThen;
import org.simantics.scl.compiler.elaboration.query.QAlternative;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.QDisjunction;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.QIf;
import org.simantics.scl.compiler.elaboration.query.QMapping;
import org.simantics.scl.compiler.elaboration.query.QNegation;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.pre.QPreBinds;
import org.simantics.scl.compiler.elaboration.query.pre.QPreEquals;
import org.simantics.scl.compiler.elaboration.query.pre.QPreExists;
import org.simantics.scl.compiler.elaboration.query.pre.QPreGuard;
import org.simantics.scl.runtime.profiling.BranchPoint;

public class BranchPointInjector
extends StandardExpressionTransformer {
    public ArrayList<BranchPoint> currentBranchPoints = new ArrayList();
    int codeCounter = 0;

    public Expression injectBranchPoint(Expression expression) {
        ArrayList<BranchPoint> oldBranchPoints = this.currentBranchPoints;
        this.currentBranchPoints = new ArrayList();
        int beginCodeCounter = this.codeCounter;
        expression = expression.accept(this);
        BranchPoint branchPoint = new BranchPoint(expression.location, this.codeCounter - beginCodeCounter, this.currentBranchPoints.isEmpty() ? BranchPoint.EMPTY_ARRAY : this.currentBranchPoints.toArray(new BranchPoint[this.currentBranchPoints.size()]));
        oldBranchPoints.add(branchPoint);
        this.currentBranchPoints = oldBranchPoints;
        return new ECoveringBranchPoint(expression, branchPoint);
    }

    @Override
    public Expression transform(ESimpleLambda expression) {
        ++this.codeCounter;
        expression.value = this.injectBranchPoint(expression.value);
        return expression;
    }

    @Override
    public Expression transform(ELambda expression) {
        ++this.codeCounter;
        Case[] caseArray = expression.cases;
        int n = expression.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.value = this.injectBranchPoint(case_.value);
            ++n2;
        }
        return expression;
    }

    @Override
    public Expression transform(EMatch expression) {
        ++this.codeCounter;
        int i = 0;
        while (i < expression.scrutinee.length) {
            expression.scrutinee[i] = expression.scrutinee[i].accept(this);
            ++i;
        }
        Case[] caseArray = expression.cases;
        int n = expression.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.value = this.injectBranchPoint(case_.value);
            ++n2;
        }
        return expression;
    }

    @Override
    public Expression transform(EIf expression) {
        ++this.codeCounter;
        expression.condition = expression.condition.accept(this);
        expression.then_ = this.injectBranchPoint(expression.then_);
        if (expression.else_ != null) {
            expression.else_ = this.injectBranchPoint(expression.else_);
        }
        return expression;
    }

    @Override
    public Expression transform(EBind expression) {
        ++this.codeCounter;
        expression.pattern = expression.pattern.accept(this);
        expression.value = expression.value.accept(this);
        expression.in = this.injectBranchPoint(expression.in);
        return expression;
    }

    @Override
    public Expression transform(EListComprehension expression) {
        ++this.codeCounter;
        expression.head = this.injectBranchPoint(expression.head);
        expression.qualifier = expression.qualifier.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EWhen expression) {
        ++this.codeCounter;
        expression.query = expression.query.accept(this);
        expression.action = this.injectBranchPoint(expression.action);
        return expression;
    }

    @Override
    public Expression transform(GuardedExpressionGroup expression) {
        ++this.codeCounter;
        GuardedExpression[] guardedExpressionArray = expression.expressions;
        int n = expression.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            GuardedExpression ge = guardedExpressionArray[n2];
            int i = 0;
            while (i < ge.guards.length) {
                ge.guards[i] = ge.guards[i].accept(this);
                ++i;
            }
            ge.value = this.injectBranchPoint(ge.value);
            ++n2;
        }
        return expression;
    }

    @Override
    public Expression transform(EAmbiguous expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EApply expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EApplyType expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EAsPattern expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EBinary expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EBlock expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ECHRRuleset expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EConstant expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ECoveringBranchPoint expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EEnforce expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EEntityTypeAnnotation expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EError expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EExternalConstant expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EFieldAccess expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EGetConstraint expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EIntegerLiteral expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ELambdaType expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ELet expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EListLiteral expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ELiteral expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EPlaceholder expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EPreLet expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EPreRuleset expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ERange expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ERealLiteral expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ERecord expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ERuleset expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ESelect expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ESimpleLet expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EStringLiteral expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ETransformation expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(ETypeAnnotation expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EVar expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public Expression transform(EVariable expression) {
        ++this.codeCounter;
        return super.transform(expression);
    }

    @Override
    public ListQualifier transform(ListAssignment qualifier) {
        ++this.codeCounter;
        return super.transform(qualifier);
    }

    @Override
    public ListQualifier transform(ListGenerator qualifier) {
        ++this.codeCounter;
        return super.transform(qualifier);
    }

    @Override
    public ListQualifier transform(ListGuard qualifier) {
        ++this.codeCounter;
        return super.transform(qualifier);
    }

    @Override
    public ListQualifier transform(ListSeq qualifier) {
        ++this.codeCounter;
        return super.transform(qualifier);
    }

    @Override
    public ListQualifier transform(ListThen qualifier) {
        ++this.codeCounter;
        return super.transform(qualifier);
    }

    @Override
    public Query transform(QAlternative query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QAtom query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QConjunction query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QDisjunction query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QExists query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QIf query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QMapping query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QNegation query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QPreBinds query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QPreEquals query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QPreExists query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    @Override
    public Query transform(QPreGuard query) {
        ++this.codeCounter;
        return super.transform(query);
    }

    public BranchPoint[] getAndClearBranchPoints() {
        BranchPoint[] result = this.currentBranchPoints.toArray(new BranchPoint[this.currentBranchPoints.size()]);
        this.currentBranchPoints.clear();
        return result;
    }

    @Override
    public void visit(BindStatement statement) {
        ++this.codeCounter;
        super.visit(statement);
    }

    @Override
    public void visit(GuardStatement statement) {
        ++this.codeCounter;
        super.visit(statement);
    }

    @Override
    public void visit(LetStatement statement) {
        ++this.codeCounter;
        if (statement.pattern.isFunctionDefinitionLhs()) {
            statement.value = this.injectBranchPoint(statement.value);
        } else {
            super.visit(statement);
        }
    }

    @Override
    public void visit(RuleStatement statement) {
        ++this.codeCounter;
        super.visit(statement);
    }
}

