/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa;

import java.util.ArrayList;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAClosure;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.ClosureBinder;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.codegen.writer.ModuleWriter;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

public class SSAObject
extends SSAClosure
implements ClosureBinder {
    Type type;
    SSAClosure firstClosure;

    public SSAObject(Type type) {
        this.type = type;
    }

    @Override
    public void toString(PrintingContext context) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            context.indentation();
            context.append(closure.getTarget());
            context.append("(" + closure.getTarget().occurrenceCount() + ")");
            context.append(" :: ");
            context.append(closure.getTarget().getType());
            context.append(" = \n");
            context.indent();
            closure.toString(context);
            context.dedent();
            closure = closure.getNext();
        }
    }

    @Override
    public SSAClosure getFirstClosure() {
        return this.firstClosure;
    }

    @Override
    public void setFirstClosure(SSAClosure function) {
        this.firstClosure = function;
        if (function == null) {
            this.detach();
        }
    }

    @Override
    public void destroy() {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.destroy();
            closure = closure.getNext();
        }
    }

    @Override
    public SSAClosure copy(CopyContext context) {
        SSAObject result = new SSAObject(context.copyType(this.type));
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            SSAClosure newFunction = closure.copy(context);
            newFunction.setTarget(context.copy(closure.getTarget()));
            result.addClosure(newFunction);
            closure = closure.getNext();
        }
        return result;
    }

    public void addClosure(SSAClosure closure) {
        closure.setParent(this);
        closure.setNext(this.firstClosure);
        if (this.firstClosure != null) {
            this.firstClosure.setPrev(closure);
        }
        this.firstClosure = closure;
    }

    @Override
    public void markGenerateOnFly() {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.markGenerateOnFly();
            closure = closure.getNext();
        }
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.replace(vars, replacements);
            closure = closure.getNext();
        }
    }

    @Override
    public void collectFreeVariables(ArrayList<ValRef> freeVars) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.collectFreeVariables(freeVars);
            closure = closure.getNext();
        }
    }

    @Override
    public void simplify(SSASimplificationContext context) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.simplify(context);
            closure = closure.getNext();
        }
    }

    @Override
    public void validate(SSAValidationContext context) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.validate(context);
            closure = closure.getNext();
        }
    }

    @Override
    public void lambdaLift(SSALambdaLiftingContext context) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.lambdaLift(context);
            closure = closure.getNext();
        }
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public void parametrize(BoundVar[] parameters) {
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public CodeWriter createMethod(ModuleWriter moduleWriter, TVar[] typeParameters, Type effect, Type returnType, Type[] parameterTypes) {
        SSAFunction function = new SSAFunction(typeParameters, effect, returnType);
        SSABlock block = new SSABlock(parameterTypes);
        function.addBlock(block);
        BoundVar target = new BoundVar(function.getType());
        function.setTarget(target);
        this.addClosure(function);
        return new CodeWriter(moduleWriter, block);
    }

    @Override
    public void forValRefs(ValRefVisitor visitor) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.forValRefs(visitor);
            closure = closure.getNext();
        }
    }
}

