/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.compilation.EnforcingContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class ConcreteRelation
extends Symbol
implements SCLRelation {
    public final String name;
    public Variable[] parameters;
    private int requiredVariablesMask = -1;
    private ArrayList<QuerySection> sections = new ArrayList(4);
    public Query enforceSection;
    public Type writingEffect;
    Type[] parameterTypes;
    public TVar[] typeVariables = TVar.EMPTY_ARRAY;
    public int phase;

    public ConcreteRelation(String name) {
        this.name = name;
    }

    public void addSection(int pattern, double selectivity, Variable[] existentials, Query query) {
        this.sections.add(new QuerySection(pattern, selectivity, existentials, query));
        this.requiredVariablesMask &= pattern;
    }

    public QuerySection getSection(int pattern) {
        for (QuerySection section : this.sections) {
            if ((section.pattern | pattern) != pattern) continue;
            return section;
        }
        return null;
    }

    public ArrayList<QuerySection> getSections() {
        return this.sections;
    }

    @Override
    public TVar[] getTypeVariables() {
        return this.typeVariables;
    }

    @Override
    public Type[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = new Type[this.parameters.length];
            int i = 0;
            while (i < this.parameters.length) {
                this.parameterTypes[i] = Types.canonical(this.parameters[i].getType());
                ++i;
            }
        }
        return this.parameterTypes;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public double getSelectivity(int boundVariables) {
        QuerySection section = this.getSection(boundVariables);
        if (section == null) {
            return Double.POSITIVE_INFINITY;
        }
        return section.selectivity;
    }

    @Override
    public int getRequiredVariablesMask() {
        return this.requiredVariablesMask;
    }

    @Override
    public void generate(long location, QueryCompilationContext context, Type[] typeParameters, Variable[] parameters, int boundVariables) {
        QuerySection section = this.getSection(boundVariables);
        ReplaceContext replaceContext = new ReplaceContext(context.getTypingContext());
        ArrayList<Variable> freeVariables = new ArrayList<Variable>(parameters.length);
        int i = 0;
        while (i < parameters.length) {
            replaceContext.varMap.put((Object)this.parameters[i], (Object)new EVariable(parameters[i]));
            if ((boundVariables >> i & 1) == 0) {
                freeVariables.add(parameters[i]);
            }
            ++i;
        }
        Variable[] variableArray = section.existentials;
        int n = section.existentials.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            Variable newVariable = new Variable(variable.getName(), variable.getType());
            replaceContext.varMap.put((Object)variable, (Object)new EVariable(newVariable));
            freeVariables.add(newVariable);
            ++n2;
        }
        try {
            new QExists(freeVariables, section.query.replace(replaceContext)).generate(context);
        }
        catch (UnsolvableQueryException e) {
            throw new InternalCompilerError(e);
        }
    }

    @Override
    public Expression generateEnforce(long location, EnforcingContext context, Type[] typeParameters, Variable[] parameters) {
        if (this.typeVariables.length != typeParameters.length) {
            throw new InternalCompilerError(location, "Invalid number of type parameters given.");
        }
        if (this.parameters.length != parameters.length) {
            throw new InternalCompilerError(location, "Invalid number of parameters given.");
        }
        ReplaceContext replaceContext = new ReplaceContext(context.getTypingContext());
        int i = 0;
        while (i < this.parameters.length) {
            replaceContext.varMap.put((Object)this.parameters[i], (Object)new EVariable(parameters[i]));
            ++i;
        }
        i = 0;
        while (i < this.typeVariables.length) {
            replaceContext.tvarMap.put((Object)this.typeVariables[i], (Object)typeParameters[i]);
            ++i;
        }
        Query enforceSectionCopy = this.enforceSection.replace(replaceContext);
        return enforceSectionCopy.generateEnforce(context);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void generateEnforce(PlanContext context, CodeWriter w, long location, Expression[] parameters, Expression[] typeConstraintEvidenceParameters) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support enforce.");
    }

    @Override
    public void generateIterate(PlanContext context, CodeWriter w, long location, int boundMask, Variable[] variables, Expression[] expressions, Expression[] typeConstraintEvidenceParameters) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support iterate.");
    }

    public static class QuerySection {
        public final int pattern;
        public final double selectivity;
        public final Variable[] existentials;
        public final Query query;
        public Type effect;

        public QuerySection(int pattern, double selectivity, Variable[] existentials, Query query) {
            this.pattern = pattern;
            this.selectivity = selectivity;
            this.existentials = existentials;
            this.query = query;
        }
    }
}

