/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.simantics.scl.compiler.constants.DoubleConstant;
import org.simantics.scl.compiler.constants.FloatConstant;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.JavaComparisonOperation;
import org.simantics.scl.compiler.constants.JavaComparisonToZeroOperation;
import org.simantics.scl.compiler.constants.JavaConversionOperation;
import org.simantics.scl.compiler.constants.JavaMathOperation;
import org.simantics.scl.compiler.constants.JavaMethod;
import org.simantics.scl.compiler.constants.LongConstant;
import org.simantics.scl.compiler.constants.ShortConstant;
import org.simantics.scl.compiler.constants.singletons.UnsafeCoerce;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class JavaModule
extends ConcreteModule {
    public static final JavaModule INSTANCE = new JavaModule();
    public static final String MODULE_NAME = "JavaBuiltin";

    private JavaModule() {
        super(MODULE_NAME);
        FunctionValue operation;
        this.addValue("dconst_0", new DoubleConstant(0.0));
        this.addValue("dconst_1", new DoubleConstant(1.0));
        this.addValue("fconst_0", new FloatConstant(0.0f));
        this.addValue("fconst_1", new FloatConstant(1.0f));
        this.addValue("iconst_0", IntegerConstant.ZERO);
        this.addValue("iconst_1", IntegerConstant.ONE);
        this.addValue("sconst_0", ShortConstant.ZERO);
        this.addValue("sconst_1", ShortConstant.ONE);
        this.addValue("lconst_0", new LongConstant(0L));
        this.addValue("lconst_1", new LongConstant(1L));
        FunctionValue[] functionValueArray = JavaMathOperation.OPCODES;
        int n = JavaMathOperation.OPCODES.length;
        int n2 = 0;
        while (n2 < n) {
            operation = functionValueArray[n2];
            this.addValue(((JavaMathOperation)operation).getMnemonic(), operation);
            ++n2;
        }
        this.addValue("cadd", JavaMathOperation.CADD);
        this.addValue("csub", JavaMathOperation.CSUB);
        this.addValue("sadd", JavaMathOperation.SADD);
        this.addValue("ssub", JavaMathOperation.SSUB);
        this.addValue("smul", JavaMathOperation.SMUL);
        this.addValue("sdiv", JavaMathOperation.SDIV);
        this.addValue("srem", JavaMathOperation.SREM);
        this.addValue("sneg", JavaMathOperation.SNEG);
        this.addValue("sand", JavaMathOperation.SAND);
        this.addValue("sor", JavaMathOperation.SOR);
        this.addValue("sxor", JavaMathOperation.SXOR);
        this.addValue("badd", JavaMathOperation.BADD);
        this.addValue("bsub", JavaMathOperation.BSUB);
        this.addValue("bmul", JavaMathOperation.BMUL);
        this.addValue("bdiv", JavaMathOperation.BDIV);
        this.addValue("brem", JavaMathOperation.BREM);
        this.addValue("bneg", JavaMathOperation.BNEG);
        this.addValue("band", JavaMathOperation.BAND);
        this.addValue("bor", JavaMathOperation.BOR);
        this.addValue("bxor", JavaMathOperation.BXOR);
        functionValueArray = JavaConversionOperation.OPCODES;
        n = JavaConversionOperation.OPCODES.length;
        n2 = 0;
        while (n2 < n) {
            operation = functionValueArray[n2];
            this.addValue(((JavaConversionOperation)operation).getMnemonic(), operation);
            ++n2;
        }
        this.addValue("icmpeq", new JavaComparisonOperation("==", Types.INTEGER));
        this.addValue("icmpne", new JavaComparisonOperation("!=", Types.INTEGER));
        this.addValue("icmplt", new JavaComparisonOperation("<", Types.INTEGER));
        this.addValue("icmple", new JavaComparisonOperation("<=", Types.INTEGER));
        this.addValue("icmpgt", new JavaComparisonOperation(">", Types.INTEGER));
        this.addValue("icmpge", new JavaComparisonOperation(">=", Types.INTEGER));
        this.addValue("lcmpeq", new JavaComparisonOperation("==", Types.LONG));
        this.addValue("lcmpne", new JavaComparisonOperation("!=", Types.LONG));
        this.addValue("lcmplt", new JavaComparisonOperation("<", Types.LONG));
        this.addValue("lcmple", new JavaComparisonOperation("<=", Types.LONG));
        this.addValue("lcmpgt", new JavaComparisonOperation(">", Types.LONG));
        this.addValue("lcmpge", new JavaComparisonOperation(">=", Types.LONG));
        this.addValue("bcmpeq", new JavaComparisonOperation("==", Types.BYTE));
        this.addValue("bcmpne", new JavaComparisonOperation("!=", Types.BYTE));
        this.addValue("bcmplt", new JavaComparisonOperation("<", Types.BYTE));
        this.addValue("bcmple", new JavaComparisonOperation("<=", Types.BYTE));
        this.addValue("bcmpgt", new JavaComparisonOperation(">", Types.BYTE));
        this.addValue("bcmpge", new JavaComparisonOperation(">=", Types.BYTE));
        this.addValue("scmpeq", new JavaComparisonOperation("==", Types.SHORT));
        this.addValue("scmpne", new JavaComparisonOperation("!=", Types.SHORT));
        this.addValue("scmplt", new JavaComparisonOperation("<", Types.SHORT));
        this.addValue("scmple", new JavaComparisonOperation("<=", Types.SHORT));
        this.addValue("scmpgt", new JavaComparisonOperation(">", Types.SHORT));
        this.addValue("scmpge", new JavaComparisonOperation(">=", Types.SHORT));
        this.addValue("fcmpeq", new JavaComparisonOperation("==", Types.FLOAT));
        this.addValue("fcmpne", new JavaComparisonOperation("!=", Types.FLOAT));
        this.addValue("fcmplt", new JavaComparisonOperation("<", Types.FLOAT));
        this.addValue("fcmple", new JavaComparisonOperation("<=", Types.FLOAT));
        this.addValue("fcmpgt", new JavaComparisonOperation(">", Types.FLOAT));
        this.addValue("fcmpge", new JavaComparisonOperation(">=", Types.FLOAT));
        this.addValue("dcmpeq", new JavaComparisonOperation("==", Types.DOUBLE));
        this.addValue("dcmpne", new JavaComparisonOperation("!=", Types.DOUBLE));
        this.addValue("dcmplt", new JavaComparisonOperation("<", Types.DOUBLE));
        this.addValue("dcmple", new JavaComparisonOperation("<=", Types.DOUBLE));
        this.addValue("dcmpgt", new JavaComparisonOperation(">", Types.DOUBLE));
        this.addValue("dcmpge", new JavaComparisonOperation(">=", Types.DOUBLE));
        this.addValue("ccmpeq", new JavaComparisonOperation("==", Types.CHARACTER));
        this.addValue("ccmpne", new JavaComparisonOperation("!=", Types.CHARACTER));
        this.addValue("ccmplt", new JavaComparisonOperation("<", Types.CHARACTER));
        this.addValue("ccmple", new JavaComparisonOperation("<=", Types.CHARACTER));
        this.addValue("ccmpgt", new JavaComparisonOperation(">", Types.CHARACTER));
        this.addValue("ccmpge", new JavaComparisonOperation(">=", Types.CHARACTER));
        this.addValue("ifeq", new JavaComparisonToZeroOperation("=="));
        this.addValue("ifne", new JavaComparisonToZeroOperation("!="));
        this.addValue("iflt", new JavaComparisonToZeroOperation("<"));
        this.addValue("ifle", new JavaComparisonToZeroOperation("<="));
        this.addValue("ifgt", new JavaComparisonToZeroOperation(">"));
        this.addValue("ifge", new JavaComparisonToZeroOperation(">="));
        TVar A = Types.var(Kinds.STAR);
        this.addValue("unsafeCoerce", UnsafeCoerce.INSTANCE);
        this.addValue("equals", new JavaMethod(true, "java/lang/Object", "equals", (Type)Types.NO_EFFECTS, (Type)Types.BOOLEAN, A, A));
        this.addValue("hashCode", new JavaMethod(true, "java/lang/Object", "hashCode", (Type)Types.NO_EFFECTS, (Type)Types.INTEGER, A));
        this.addValue("toString", new JavaMethod(true, "java/lang/Object", "toString", (Type)Types.NO_EFFECTS, (Type)Types.STRING, A));
        this.setParentClassLoader(this.getClass().getClassLoader());
    }

    static Expression createLiteral(FunctionValue value) {
        Expression result = new ELiteral(value);
        TVar[] tVarArray = value.getTypeParameters();
        int n = tVarArray.length;
        int n2 = 0;
        while (n2 < n) {
            TVar var = tVarArray[n2];
            result = new EApplyType(result, var);
            ++n2;
        }
        return result;
    }
}

