/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.list;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.expressions.list.CompiledQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierTransformer;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierVisitor;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;

public class ListAssignment
extends ListQualifier {
    public Expression pattern;
    public Expression value;

    public ListAssignment(Expression pattern, Expression value) {
        this.pattern = pattern;
        this.value = value;
    }

    @Override
    public void checkType(TypingContext context) {
        this.value = this.value.inferType(context);
        this.pattern.checkTypeAsPattern(context, this.value.getType());
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.value.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.value.collectVars(allVars, vars);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.value.collectFreeVariables(vars);
        this.pattern.collectFreeVariables(vars);
    }

    @Override
    public CompiledQualifier compile(SimplificationContext context) {
        if (this.pattern instanceof EVariable) {
            return new CompiledQualifier(context.singletonList(this.value), this.pattern);
        }
        THashSet<Variable> variables = this.pattern.getFreeVariables();
        Variable[] variableArray = (Variable[])variables.toArray((Object[])new Variable[variables.size()]);
        Expression[] variableExps = new Expression[variableArray.length];
        int i = 0;
        while (i < variableArray.length) {
            variableExps[i] = new EVariable(variableArray[i]);
            ++i;
        }
        Expression newPattern = context.tuple(variableExps);
        EVariable blank = context.blank();
        blank.getVariable().setType(this.pattern.getType());
        return new CompiledQualifier(context.match(this.value, new Case(this.pattern, context.singletonList(newPattern.copy())), new Case(blank, context.emptyList(newPattern.getType()))), newPattern);
    }

    @Override
    public void resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        this.pattern = this.pattern.resolveAsPattern(context);
    }

    @Override
    public void decorate(ExpressionDecorator decorator) {
        this.value = this.value.decorate(decorator);
        this.pattern = this.pattern.decorate(decorator);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.pattern.collectEffects(effects);
        this.value.collectEffects(effects);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ListQualifierVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        this.value.forVariables(procedure);
    }

    @Override
    public ListQualifier accept(ListQualifierTransformer transformer) {
        return transformer.transform(this);
    }
}

