/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.constants.SCLConstructor;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.internal.parsing.Token;

public class ERecord
extends ASTExpression {
    Token constructor;
    FieldAssignment[] fields;

    public ERecord(Token constructor, FieldAssignment[] fields) {
        this.constructor = constructor;
        this.fields = fields;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this.resolve(context, false);
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this.resolve(context, true);
    }

    public Expression resolve(TranslationContext context, boolean asPattern) {
        SCLValue constructorValue;
        try {
            constructorValue = context.getEnvironment().getLocalNamespace().getValue(this.constructor.text);
        }
        catch (AmbiguousNameException e) {
            context.getErrorLog().log(this.constructor.location, e.getMessage());
            return new EError(this.constructor.location);
        }
        if (constructorValue == null) {
            context.getErrorLog().log(this.constructor.location, "Couldn't resolve the record constructor " + this.constructor.text + ".");
            return new EError(this.constructor.location);
        }
        if (!(constructorValue.getValue() instanceof SCLConstructor)) {
            context.getErrorLog().log(this.constructor.location, "Value " + this.constructor.text + " is not a record constructor.");
            return new EError(this.constructor.location);
        }
        String[] fieldNames = ((SCLConstructor)constructorValue.getValue()).recordFieldNames;
        if (fieldNames == null) {
            context.getErrorLog().log(this.constructor.location, "Value " + this.constructor.text + " is not a record constructor.");
            return new EError(this.constructor.location);
        }
        THashMap recordMap = new THashMap(this.fields.length);
        FieldAssignment[] fieldAssignmentArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAssignment field = fieldAssignmentArray[n2];
            if (field.value == null) {
                String bestMatch = null;
                int bestMatchLength = 0;
                int i = 0;
                while (i < fieldNames.length) {
                    String fieldName = fieldNames[i];
                    if (field.name.startsWith(fieldName) && fieldName.length() > bestMatchLength) {
                        bestMatch = fieldName;
                        bestMatchLength = fieldName.length();
                    }
                    ++i;
                }
                if (bestMatch == null) {
                    context.getErrorLog().log(field.location, "Invalid shorthand field " + field.name + " is defined twice.");
                    return new EError(this.location);
                }
                field.value = new EVar(field.location, field.name);
                field.name = bestMatch;
            }
            if (recordMap.put((Object)field.name, (Object)field) != null) {
                context.getErrorLog().log(field.location, "Field " + field.name + " is defined more than once.");
                return new EError(this.location);
            }
            ++n2;
        }
        Expression[] parameters = new Expression[fieldNames.length];
        boolean error = false;
        int i = 0;
        while (i < fieldNames.length) {
            FieldAssignment assignment = (FieldAssignment)recordMap.remove((Object)fieldNames[i]);
            if (assignment == null) {
                if (asPattern) {
                    parameters[i] = Expressions.blank(null);
                } else {
                    context.getErrorLog().log(this.location, "Field " + fieldNames[i] + " not defined.");
                    error = true;
                }
            } else {
                parameters[i] = asPattern ? assignment.value.resolveAsPattern(context) : assignment.value.resolve(context);
            }
            ++i;
        }
        if (!recordMap.isEmpty()) {
            for (FieldAssignment field : recordMap.values()) {
                context.getErrorLog().log(field.location, "Field " + field.name + " is not defined in the constructor.");
            }
            error = true;
        }
        if (error) {
            return new EError(this.location);
        }
        EApply result = new EApply((Expression)new EConstant(constructorValue), parameters);
        result.setLocationDeep(this.location);
        return result;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            FieldAssignment[] fieldAssignmentArray = this.fields;
            int n = this.fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldAssignment field = fieldAssignmentArray[n2];
                if (field.value != null) {
                    field.value.setLocationDeep(loc);
                }
                ++n2;
            }
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

