/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.DoubleConstant;
import org.simantics.scl.compiler.constants.FloatConstant;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ERealLiteral
extends SimplifiableExpression {
    public String value;
    EVariable constraint;

    public ERealLiteral(String value) {
        this.value = value;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
    }

    private Expression tryToConvertToPrimitive(ErrorLog errorLog, Type requiredType) {
        if (requiredType.equals(Types.DOUBLE)) {
            return new ELiteral(new DoubleConstant(Double.parseDouble(this.value)));
        }
        if (requiredType.equals(Types.FLOAT)) {
            return new ELiteral(new FloatConstant(Float.parseFloat(this.value)));
        }
        if (requiredType.equals(Types.INTEGER)) {
            errorLog.log(this.location, "Cannot convert real literal to Integer.");
            return new EError();
        }
        if (requiredType.equals(Types.LONG)) {
            errorLog.log(this.location, "Cannot convert real literal to Long.");
            return new EError();
        }
        return null;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        requiredType = Types.canonical(requiredType);
        Expression primitive = this.tryToConvertToPrimitive(context.getErrorLog(), requiredType);
        if (primitive != null) {
            return primitive;
        }
        this.setType(requiredType);
        this.constraint = new EVariable(this.location, null);
        this.constraint.setType(Types.pred(Types.REAL, requiredType));
        context.addConstraintDemand(this.constraint);
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        throw new InternalCompilerError("TODO");
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        Expression primitive = this.tryToConvertToPrimitive(context.getErrorLog(), this.getType());
        if (primitive != null) {
            return primitive;
        }
        return context.apply(context.getConstant(Names.Prelude_fromDouble, this.getType()), this.constraint.simplify(context), context.literal(new DoubleConstant(Double.parseDouble(this.value))));
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return new ELiteral(new DoubleConstant(Double.parseDouble(this.value)));
    }

    @Override
    public Expression replace(ReplaceContext context) {
        ERealLiteral copy = new ERealLiteral(this.value);
        copy.setType(this.getType().replace(context.tvarMap));
        return copy;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            if (this.constraint != null) {
                this.constraint.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        if (this.constraint != null) {
            this.constraint.forVariables(procedure);
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

