/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.expressions.accessor.FieldAccessor;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EFieldAccess
extends SimplifiableExpression {
    private static final Type VARIABLE = Types.con("Simantics/Variables", "Variable");
    Expression parent;
    FieldAccessor[] accessors;

    public EFieldAccess(Expression parent, FieldAccessor[] accessors) {
        if (parent instanceof EFieldAccess) {
            EFieldAccess parentAccess = (EFieldAccess)parent;
            parent = parentAccess.parent;
            accessors = EFieldAccess.concat(parentAccess.accessors, accessors);
        }
        this.parent = parent;
        this.accessors = accessors;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.parent.collectRefs(allRefs, refs);
        FieldAccessor[] fieldAccessorArray = this.accessors;
        int n = this.accessors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAccessor accessor = fieldAccessorArray[n2];
            accessor.collectRefs(allRefs, refs);
            ++n2;
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.parent.collectVars(allVars, vars);
        FieldAccessor[] fieldAccessorArray = this.accessors;
        int n = this.accessors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAccessor accessor = fieldAccessorArray[n2];
            accessor.collectVars(allVars, vars);
            ++n2;
        }
    }

    private boolean returnsValue() {
        FieldAccessor lastAccessor = this.accessors[this.accessors.length - 1];
        return lastAccessor.accessSeparator == '#' && !lastAccessor.isVariableId();
    }

    @Override
    protected void updateType() throws MatchException {
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        if (this.returnsValue()) {
            this.setType(requiredType);
        } else {
            this.setType(VARIABLE);
            context.subsume(this, requiredType);
        }
        this.parent = this.parent.checkType(context, VARIABLE);
        FieldAccessor[] fieldAccessorArray = this.accessors;
        int n = this.accessors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAccessor accessor = fieldAccessorArray[n2];
            accessor.checkType(context);
            ++n2;
        }
        context.declareEffect(this.getLocation(), Types.READ_GRAPH);
        return this;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.parent.collectFreeVariables(vars);
        FieldAccessor[] fieldAccessorArray = this.accessors;
        int n = this.accessors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAccessor accessor = fieldAccessorArray[n2];
            accessor.collectFreeVariables(vars);
            ++n2;
        }
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.parent = this.parent.simplify(context);
        FieldAccessor[] fieldAccessorArray = this.accessors;
        int n = this.accessors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAccessor accessor = fieldAccessorArray[n2];
            accessor.simplify(context);
            ++n2;
        }
        Expression result = this.parent;
        int i = 0;
        while (i < this.accessors.length) {
            FieldAccessor accessor = this.accessors[i];
            if (accessor.accessSeparator == '.') {
                result = new EApply(this.getLocation(), Types.READ_GRAPH, context.getConstant(Names.Simantics_Variables_child_, new Type[0]), result, accessor.asExpression());
            } else if (i < this.accessors.length - 1) {
                result = new EApply(this.getLocation(), Types.READ_GRAPH, context.getConstant(Names.Simantics_Variables_property, new Type[0]), result, accessor.asExpression());
            } else if (!accessor.isVariableId()) {
                result = new EApply(this.getLocation(), Types.READ_GRAPH, context.getConstant(Names.Simantics_Variables_untypedPropertyValue, this.getType()), result, accessor.asExpression());
            }
            ++i;
        }
        return result;
    }

    private static FieldAccessor[] concat(FieldAccessor[] accessors1, FieldAccessor[] accessors2) {
        FieldAccessor[] result = new FieldAccessor[accessors1.length + accessors2.length];
        System.arraycopy(accessors1, 0, result, 0, accessors1.length);
        System.arraycopy(accessors2, 0, result, accessors1.length, accessors2.length);
        return result;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.parent = this.parent.resolve(context);
        FieldAccessor[] fieldAccessorArray = this.accessors;
        int n = this.accessors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAccessor accessor = fieldAccessorArray[n2];
            accessor.resolve(context);
            ++n2;
        }
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        effects.add((Object)Types.READ_GRAPH);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.parent.setLocationDeep(loc);
            FieldAccessor[] fieldAccessorArray = this.accessors;
            int n = this.accessors.length;
            int n2 = 0;
            while (n2 < n) {
                FieldAccessor accessor = fieldAccessorArray[n2];
                accessor.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        this.parent.forVariables(procedure);
        FieldAccessor[] fieldAccessorArray = this.accessors;
        int n = this.accessors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldAccessor accessor = fieldAccessorArray[n2];
            accessor.forVariables(procedure);
            ++n2;
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

