/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EAsPattern
extends Expression {
    Variable var;
    EVar eVar;
    Expression pattern;

    public EAsPattern(EVar eVar, Expression pattern) {
        this.eVar = eVar;
        this.pattern = pattern;
    }

    public EAsPattern(Variable var, Expression pattern) {
        this.var = var;
        this.pattern = pattern;
    }

    public Variable getVariable() {
        return this.var;
    }

    public Expression getPattern() {
        return this.pattern;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.pattern.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        int id = allVars.get((Object)this.var);
        if (id >= 0) {
            vars.add(id);
        }
        this.pattern.collectVars(allVars, vars);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        throw new InternalCompilerError(this.location, "Cannot collect free variables for a pattern.");
    }

    @Override
    public void removeFreeVariables(THashSet<Variable> vars) {
        vars.remove((Object)this.var);
        this.pattern.removeFreeVariables(vars);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.pattern = this.pattern.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.getErrorLog().log(this.location, "As binding (@) can be used only in patterns.");
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        this.var = context.newVariable(this.eVar.name);
        this.pattern = this.pattern.resolveAsPattern(context);
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.pattern.getType());
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        throw new InternalCompilerError("EAsPattern allowed only in patterns.");
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.pattern = this.pattern.inferType(context);
        this.var.setType(this.pattern.getType());
        return this;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.pattern = this.pattern.checkBasicType(context, requiredType);
        this.var.setType(this.pattern.getType());
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        this.pattern = this.pattern.decorate(decorator);
        return decorator.decorate(this);
    }

    @Override
    public Expression replace(ReplaceContext context) {
        if (!context.inPattern) {
            throw new IllegalStateException();
        }
        Variable newVariable = new Variable(this.var.name);
        newVariable.setType(this.var.getType().replace(context.tvarMap));
        context.varMap.put((Object)this.var, (Object)new EVariable(newVariable));
        EAsPattern result = new EAsPattern(this.eVar, this.pattern.replace(context));
        result.var = newVariable;
        return result;
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.pattern.collectEffects(effects);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            if (this.eVar != null) {
                this.eVar.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        procedure.execute(this.eVar.location, this.var);
        this.pattern.forVariables(procedure);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

