/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.Type;

public class Case
extends Symbol {
    public Expression[] patterns;
    public Expression value;
    long lhs;

    public Case(Expression[] patterns, Expression value) {
        this.patterns = patterns;
        this.value = value;
    }

    public Case(Expression pattern, Expression value) {
        this(new Expression[]{pattern}, value);
    }

    public void setLhs(long lhs) {
        this.lhs = lhs;
    }

    public long getLhs() {
        return this.lhs;
    }

    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.value.collectRefs(allRefs, refs);
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.value.collectVars(allVars, vars);
    }

    public void collectFreeVariables(THashSet<Variable> vars) {
        this.value.collectFreeVariables(vars);
        int i = this.patterns.length - 1;
        while (i >= 0) {
            this.patterns[i].removeFreeVariables(vars);
            --i;
        }
    }

    public void resolve(TranslationContext context) {
        context.pushFrame();
        int i = 0;
        while (i < this.patterns.length) {
            this.patterns[i] = this.patterns[i].resolveAsPattern(context);
            ++i;
        }
        this.value = this.value.resolve(context);
        context.popFrame();
    }

    public void simplify(SimplificationContext context) {
        int i = 0;
        while (i < this.patterns.length) {
            this.patterns[i] = this.patterns[i].simplify(context);
            ++i;
        }
        this.value = this.value.simplify(context);
    }

    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                Expression pattern = expressionArray[n2];
                pattern.setLocationDeep(loc);
                ++n2;
            }
            this.value.setLocationDeep(loc);
        }
    }

    public Case replace(ReplaceContext context) {
        Expression[] newPatterns = new Expression[this.patterns.length];
        int i = 0;
        while (i < this.patterns.length) {
            newPatterns[i] = this.patterns[i].replaceInPattern(context);
            ++i;
        }
        Expression newValue = this.value.replace(context);
        Case result = new Case(newPatterns, newValue);
        result.setLhs(this.lhs);
        return result;
    }

    public Expression[] getPatterns() {
        return this.patterns;
    }

    public void checkType(TypingContext context, Type[] parameterTypes, Type requiredType) {
        if (this.patterns.length != parameterTypes.length) {
            context.getErrorLog().log(this.location, "This case has different arity (" + this.patterns.length + ") than than the first case (+" + parameterTypes.length + "+).");
            return;
        }
        int i = 0;
        while (i < this.patterns.length) {
            this.patterns[i] = this.patterns[i].checkTypeAsPattern(context, parameterTypes[i]);
            ++i;
        }
        this.value = this.value.checkType(context, requiredType);
    }

    public void checkIgnoredType(TypingContext context, Type[] parameterTypes) {
        if (this.patterns.length != parameterTypes.length) {
            context.getErrorLog().log(this.location, "This case has different arity (" + this.patterns.length + ") than than the first case (+" + parameterTypes.length + "+).");
            return;
        }
        int i = 0;
        while (i < this.patterns.length) {
            this.patterns[i] = this.patterns[i].checkTypeAsPattern(context, parameterTypes[i]);
            ++i;
        }
        this.value = this.value.checkIgnoredType(context);
    }

    public void decorate(ExpressionDecorator decorator) {
        int i = 0;
        while (i < this.patterns.length) {
            this.patterns[i] = this.patterns[i].decorate(decorator);
            ++i;
        }
        this.value = this.value.decorate(decorator);
    }

    public void forVariables(VariableProcedure procedure) {
        this.value.forVariables(procedure);
    }
}

