/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.contexts;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TypeTranslationContext {
    CompilationContext compilationContext;
    Environment environment;
    ErrorLog errorLog;
    THashMap<String, TVar> typeVariables = new THashMap();

    public TypeTranslationContext(CompilationContext compilationContext) {
        this.compilationContext = compilationContext;
        this.errorLog = compilationContext.errorLog;
        this.environment = compilationContext.environment;
    }

    public Type toType(TypeAst typeAst) {
        return this.toType(typeAst, Kinds.STAR);
    }

    public Type toType(TypeAst typeAst, Kind kind) {
        Type type;
        try {
            type = typeAst.toType(this, kind);
        }
        catch (SCLSyntaxErrorException e) {
            this.errorLog.log(e.location, e.getMessage());
            return Types.metaVar(kind);
        }
        return type;
    }

    public TVar resolveTypeVariable(long loc, String name, Kind expectedKind) {
        TVar var = (TVar)this.typeVariables.get((Object)name);
        if (var == null) {
            var = Types.var(expectedKind);
            this.typeVariables.put((Object)name, (Object)var);
        } else {
            this.unify(loc, var.getKind(), expectedKind);
        }
        return var;
    }

    public TVar pushTypeVar(String name) {
        return (TVar)this.typeVariables.put((Object)name, (Object)Types.var(Kinds.metaVar()));
    }

    public TVar addTypeVar(String name) {
        TVar var = Types.var(Kinds.metaVar());
        this.typeVariables.put((Object)name, (Object)var);
        return var;
    }

    public TVar popTypeVar(String name, TVar var) {
        if (var == null) {
            return (TVar)this.typeVariables.remove((Object)name);
        }
        return (TVar)this.typeVariables.put((Object)name, (Object)var);
    }

    public TPred toTFuncApply(TypeAst typeAst) {
        return typeAst.toTFuncApply(this);
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Kind getKind(TCon con) {
        return this.environment.getTypeDescriptor(con).getKind();
    }

    public void unify(long loc, Kind provided, Kind expectedKind) {
        try {
            Kinds.unify(provided, expectedKind);
        }
        catch (KindUnificationException kindUnificationException) {
            this.errorLog.log(loc, "Expected a type with kind " + expectedKind + " but got " + provided + ".");
        }
    }
}

