/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.analysis;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;

public class UsageAnalysis {
    public static void analyzeUsage(CHRRuleset ruleset) {
        THashMap<CHRConstraint, ArrayList<CHRRule>> headConstraintMap = UsageAnalysis.createHeadConstraintMap(ruleset);
        UsageAnalysis.calculateFirstPriorities(ruleset, headConstraintMap);
        UsageAnalysis.calculateLastPriorities(ruleset, headConstraintMap);
        for (CHRRule rule : ruleset.rules) {
            UsageAnalysis.determinePassiveLiterals(rule);
        }
    }

    private static void calculateFirstPriorities(CHRRuleset ruleset, THashMap<CHRConstraint, ArrayList<CHRRule>> headConstraintMap) {
        for (CHRRule rule : ruleset.rules) {
            rule.firstPriorityExecuted = Integer.MAX_VALUE;
        }
        for (CHRConstraint constraint : ruleset.constraints) {
            constraint.firstPriorityAdded = Integer.MAX_VALUE;
            constraint.firstPriorityRemoved = Integer.MAX_VALUE;
        }
        for (CHRRule rule : ruleset.rules) {
            UsageAnalysis.calculateFirstPriority(headConstraintMap, rule);
        }
    }

    private static void calculateFirstPriority(THashMap<CHRConstraint, ArrayList<CHRRule>> headConstraintMap, CHRRule rule) {
        CHRConstraint constraint;
        CHRLiteral literal;
        int result = rule.priority;
        CHRLiteral[] cHRLiteralArray = rule.head.literals;
        int n = rule.head.literals.length;
        int n2 = 0;
        while (n2 < n) {
            literal = cHRLiteralArray[n2];
            if (literal.relation instanceof CHRConstraint) {
                constraint = (CHRConstraint)literal.relation;
                int constraintPriority = constraint.firstPriorityAdded;
                if (constraintPriority == Integer.MAX_VALUE) {
                    return;
                }
                result = Math.max(result, constraint.firstPriorityAdded);
            }
            ++n2;
        }
        rule.firstPriorityExecuted = result;
        cHRLiteralArray = rule.head.literals;
        n = rule.head.literals.length;
        n2 = 0;
        while (n2 < n) {
            literal = cHRLiteralArray[n2];
            if (literal.killAfterMatch && literal.relation instanceof CHRConstraint) {
                constraint = (CHRConstraint)literal.relation;
                if (constraint.firstPriorityRemoved == Integer.MAX_VALUE) {
                    constraint.firstPriorityRemoved = result;
                }
            }
            ++n2;
        }
        cHRLiteralArray = rule.body.literals;
        n = rule.body.literals.length;
        n2 = 0;
        while (n2 < n) {
            literal = cHRLiteralArray[n2];
            if (literal.relation instanceof CHRConstraint) {
                constraint = (CHRConstraint)literal.relation;
                if (constraint.firstPriorityAdded == Integer.MAX_VALUE) {
                    constraint.firstPriorityAdded = result;
                    ArrayList list = (ArrayList)headConstraintMap.get((Object)constraint);
                    if (list != null) {
                        for (CHRRule lowerPriorityRule : list) {
                            if (lowerPriorityRule.priority >= rule.priority) continue;
                            UsageAnalysis.calculateFirstPriority(headConstraintMap, lowerPriorityRule);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static void calculateLastPriorities(CHRRuleset ruleset, THashMap<CHRConstraint, ArrayList<CHRRule>> headConstraintMap) {
        for (CHRRule rule : ruleset.rules) {
            rule.lastPriorityExecuted = Integer.MIN_VALUE;
        }
        for (CHRConstraint constraint : ruleset.constraints) {
            constraint.lastPriorityAdded = Integer.MIN_VALUE;
            constraint.lastPriorityRemoved = Integer.MIN_VALUE;
        }
        int i = ruleset.rules.size() - 1;
        while (i >= 0) {
            CHRRule rule = ruleset.rules.get(i);
            if (rule.lastPriorityExecuted == Integer.MIN_VALUE) {
                UsageAnalysis.calculateLastPriority(headConstraintMap, rule, rule.priority);
            }
            --i;
        }
    }

    private static void calculateLastPriority(THashMap<CHRConstraint, ArrayList<CHRRule>> headConstraintMap, CHRRule rule, int priority) {
        CHRConstraint constraint;
        CHRLiteral literal;
        rule.lastPriorityExecuted = priority;
        CHRLiteral[] cHRLiteralArray = rule.head.literals;
        int n = rule.head.literals.length;
        int n2 = 0;
        while (n2 < n) {
            literal = cHRLiteralArray[n2];
            if (literal.killAfterMatch && literal.relation instanceof CHRConstraint) {
                constraint = (CHRConstraint)literal.relation;
                if (constraint.lastPriorityRemoved == Integer.MIN_VALUE) {
                    constraint.lastPriorityRemoved = priority;
                }
            }
            ++n2;
        }
        cHRLiteralArray = rule.body.literals;
        n = rule.body.literals.length;
        n2 = 0;
        while (n2 < n) {
            literal = cHRLiteralArray[n2];
            if (literal.relation instanceof CHRConstraint) {
                constraint = (CHRConstraint)literal.relation;
                if (constraint.lastPriorityAdded == Integer.MIN_VALUE) {
                    constraint.lastPriorityAdded = priority;
                    ArrayList list = (ArrayList)headConstraintMap.get((Object)constraint);
                    if (list != null) {
                        for (CHRRule lowerPriorityRule : list) {
                            if (lowerPriorityRule.lastPriorityExecuted != Integer.MIN_VALUE) continue;
                            UsageAnalysis.calculateLastPriority(headConstraintMap, lowerPriorityRule, priority);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static THashMap<CHRConstraint, ArrayList<CHRRule>> createHeadConstraintMap(CHRRuleset ruleset) {
        THashMap map = new THashMap();
        for (CHRRule rule : ruleset.rules) {
            CHRLiteral[] cHRLiteralArray = rule.head.literals;
            int n = rule.head.literals.length;
            int n2 = 0;
            while (n2 < n) {
                CHRLiteral literal = cHRLiteralArray[n2];
                if (literal.relation instanceof CHRConstraint) {
                    ArrayList<CHRRule> list = (ArrayList<CHRRule>)map.get((Object)literal.relation);
                    if (list == null) {
                        list = new ArrayList<CHRRule>();
                        map.put((Object)((CHRConstraint)literal.relation), list);
                        list.add(rule);
                    } else if (list.get(list.size() - 1) != rule) {
                        list.add(rule);
                    }
                }
                ++n2;
            }
        }
        return map;
    }

    private static void printPriorities(CHRRuleset ruleset) {
        System.out.println("-------------------------------");
        for (CHRConstraint constraint : ruleset.constraints) {
            System.out.print(" [" + constraint.firstPriorityAdded + ".." + constraint.lastPriorityAdded + "]");
            if (constraint.firstPriorityRemoved != Integer.MAX_VALUE) {
                System.out.print("R[" + constraint.firstPriorityRemoved + ".." + constraint.lastPriorityRemoved + "]");
            }
            System.out.print(" ");
            System.out.println(constraint);
        }
        for (CHRRule rule : ruleset.rules) {
            System.out.print(rule.priority);
            System.out.print(" [" + rule.firstPriorityExecuted + ".." + rule.lastPriorityExecuted + "] ");
            System.out.println(rule);
        }
    }

    private static void determinePassiveLiterals(CHRRule rule) {
        CHRLiteral[] cHRLiteralArray = rule.head.literals;
        int n = rule.head.literals.length;
        int n2 = 0;
        while (n2 < n) {
            CHRLiteral literal = cHRLiteralArray[n2];
            if (!literal.passive) {
                CHRConstraint constraint = (CHRConstraint)literal.relation;
                if (constraint.lastPriorityAdded < rule.priority) {
                    literal.passive = true;
                }
            }
            ++n2;
        }
    }
}

