/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.BooleanConstant;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.JavaMethod;
import org.simantics.scl.compiler.constants.generic.CallJava;
import org.simantics.scl.compiler.constants.generic.MethodRef;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.chr.CHRRulesetObject;
import org.simantics.scl.compiler.elaboration.chr.analysis.UsageAnalysis;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanRealizer;
import org.simantics.scl.compiler.elaboration.chr.plan.PrioritizedPlan;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.internal.codegen.chr.CHRCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class CHRRuleset
extends Symbol {
    public static final String INIT_CONSTRAINT = "__INIT__";
    public ArrayList<CHRConstraint> constraints = new ArrayList();
    public ArrayList<CHRRule> rules = new ArrayList();
    public CHRConstraint initConstraint = new CHRConstraint(9223372034707292160L, "__INIT__", Type.EMPTY_ARRAY);
    public int priorityCount;
    public String storeClassName;
    public TCon storeType;
    public BoundVar storeVariable;
    public TypeDesc storeTypeDesc;
    public Constant activateProcedure;
    public Constant readCurrentId;
    public Constant writeCurrentId;
    private CompilationContext cachedContext;
    public BoundVar this_;
    public BoundVar[] parameters;
    public TypeDesc[] parameterTypeDescs;

    public CHRRuleset() {
        this.constraints.add(this.initConstraint);
    }

    public void resolve(TranslationContext context) {
        for (CHRConstraint constraint : this.constraints) {
            context.newCHRConstraint(constraint.name, constraint);
        }
        this.priorityCount = 0;
        for (CHRRule rule : this.rules) {
            rule.resolve(context);
            ++this.priorityCount;
            rule.priority = rule.priority;
        }
    }

    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        for (CHRRule rule : this.rules) {
            rule.collectRefs(allRefs, refs);
        }
    }

    public void checkType(TypingContext context) {
        for (CHRRule rule : this.rules) {
            rule.checkType(context);
        }
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        for (CHRRule rule : this.rules) {
            rule.collectVars(allVars, vars);
        }
    }

    public void forVariables(VariableProcedure procedure) {
        for (CHRRule rule : this.rules) {
            rule.forVariables(procedure);
        }
    }

    public void collectFreeVariables(THashSet<Variable> vars) {
        for (CHRRule rule : this.rules) {
            rule.collectFreeVariables(vars);
        }
    }

    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            for (CHRRule rule : this.rules) {
                rule.setLocationDeep(loc);
            }
        }
    }

    public void compile(SimplificationContext context) {
        this.initializeCodeGeneration(context.getCompilationContext());
        UsageAnalysis.analyzeUsage(this);
        for (CHRRule rule : this.rules) {
            rule.compile(context.getCompilationContext(), this.initConstraint);
        }
        if (this.initConstraint.plans.isEmpty()) {
            this.constraints.remove(0);
            this.initConstraint = null;
        }
        for (CHRConstraint constraint : this.constraints) {
            constraint.plans.sort((a, b) -> Integer.compare(a.priority, b.priority));
        }
    }

    public void simplify(SimplificationContext context) {
        for (CHRRule rule : this.rules) {
            rule.simplify(context);
        }
    }

    public void initializeCodeGeneration(CompilationContext context) {
        this.cachedContext = context;
        String suffix = context.namingPolicy.getFreshClosureClassNameSuffix();
        this.storeType = Types.con(context.namingPolicy.getModuleName(), "CHR" + suffix);
        this.storeClassName = String.valueOf(context.namingPolicy.getModuleClassName()) + suffix;
        this.storeTypeDesc = TypeDesc.forClass(this.storeClassName);
        this.storeVariable = new BoundVar(this.storeType);
        for (CHRConstraint constraint : this.constraints) {
            constraint.initializeCodeGeneration(context, this);
        }
        this.activateProcedure = new JavaMethod(true, this.storeClassName, "activate", (Type)Types.PROC, (Type)Types.UNIT, this.storeType, Types.INTEGER);
        this.readCurrentId = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, (Type)Types.INTEGER, new Type[]{this.storeType}, null, new MethodRef.FieldRef(this.storeClassName, "currentId", CHRCodeGenerator.FACT_ID_TYPE), null);
        this.writeCurrentId = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, (Type)Types.UNIT, new Type[]{this.storeType, Types.INTEGER}, null, new MethodRef.SetFieldRef(this.storeClassName, "currentId", CHRCodeGenerator.FACT_ID_TYPE), null);
        if (context.module != null) {
            context.module.addTypeDescriptor(this.storeType.name, new StandardTypeConstructor(this.storeType, TVar.EMPTY_ARRAY, this.storeTypeDesc));
        }
    }

    public void generateCode(CodeWriter w) {
        CHRRulesetObject object = new CHRRulesetObject(this.storeVariable, this);
        w.defineObject(object);
        for (CHRConstraint constraint : this.constraints) {
            for (PrioritizedPlan plan : constraint.plans) {
                PlanRealizer realizer = new PlanRealizer(this.cachedContext, this, this.storeVariable, plan.ops);
                CodeWriter methodWriter = object.createMethod(w.getModuleWriter(), TVar.EMPTY_ARRAY, Types.PROC, Types.BOOLEAN, new Type[]{constraint.factType});
                plan.implementation = methodWriter.getFunction();
                plan.activeFact.setVal(methodWriter.getParameters()[0]);
                realizer.nextOp(methodWriter);
                if (!methodWriter.isUnfinished()) continue;
                methodWriter.return_(BooleanConstant.TRUE);
            }
        }
        if (this.initConstraint != null) {
            IVal initFact = w.apply(this.location, this.initConstraint.constructor, IntegerConstant.ZERO);
            w.apply(this.location, this.initConstraint.addProcedure, this.storeVariable, initFact);
            w.apply(this.location, this.activateProcedure, this.storeVariable, new IntegerConstant(Integer.MAX_VALUE));
        }
    }

    public void collectEffects(THashSet<Type> effects) {
        for (CHRRule rule : this.rules) {
            CHRLiteral literal;
            CHRLiteral[] cHRLiteralArray = rule.head.literals;
            int n = rule.head.literals.length;
            int n2 = 0;
            while (n2 < n) {
                literal = cHRLiteralArray[n2];
                literal.collectQueryEffects(effects);
                ++n2;
            }
            cHRLiteralArray = rule.head.literals;
            n = rule.head.literals.length;
            n2 = 0;
            while (n2 < n) {
                literal = cHRLiteralArray[n2];
                literal.collectEnforceEffects(effects);
                ++n2;
            }
        }
    }
}

