/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRQuery;
import org.simantics.scl.compiler.elaboration.chr.plan.PrioritizedPlan;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class CHRRule
extends Symbol {
    public int priority;
    public CHRQuery head;
    public CHRQuery body;
    public Variable[] existentialVariables;
    public int firstPriorityExecuted;
    public int lastPriorityExecuted;

    public CHRRule(long location, CHRQuery head, CHRQuery body, Variable[] existentialVariables) {
        this.location = location;
        this.head = head;
        this.body = body;
        this.existentialVariables = existentialVariables;
    }

    public void resolve(TranslationContext context) {
        context.pushExistentialFrame();
        this.head.resolve(context);
        this.body.resolve(context);
        this.existentialVariables = context.popExistentialFrame();
    }

    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.head.collectRefs(allRefs, refs);
        this.body.collectRefs(allRefs, refs);
    }

    public void checkType(TypingContext context) {
        Variable[] variableArray = this.existentialVariables;
        int n = this.existentialVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variable.setType(Types.metaVar(Kinds.STAR));
            ++n2;
        }
        this.head.checkType(context);
        this.body.checkType(context);
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.head.collectVars(allVars, vars);
        this.body.collectVars(allVars, vars);
    }

    public void forVariables(VariableProcedure procedure) {
        this.head.forVariables(procedure);
        this.body.forVariables(procedure);
    }

    public void collectFreeVariables(THashSet<Variable> vars) {
        this.head.collectFreeVariables(vars);
        this.body.collectFreeVariables(vars);
    }

    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.head.setLocationDeep(loc);
            this.body.setLocationDeep(loc);
        }
    }

    public void simplify(SimplificationContext context) {
        this.head.simplify(context);
        this.body.simplify(context);
    }

    public void compile(CompilationContext compilationContext, CHRConstraint initConstraint) {
        boolean hasActiveLiteral = false;
        int i = 0;
        while (i < this.head.literals.length) {
            CHRLiteral literal = this.head.literals[i];
            if (!literal.passive) {
                CHRConstraint constraint = (CHRConstraint)literal.relation;
                QueryPlanningContext context = new QueryPlanningContext(compilationContext, this.existentialVariables);
                Variable activeFact = new Variable("activeFact", constraint.factType);
                if (!this.head.createQueryPlan(context, new EVariable(activeFact), i)) {
                    return;
                }
                this.body.createEnforcePlan(context, this.priority);
                constraint.plans.add(new PrioritizedPlan(this.priority, activeFact, context.getPlanOps()));
                hasActiveLiteral = true;
            }
            ++i;
        }
        if (!hasActiveLiteral) {
            Variable activeFact = new Variable("activeFact", initConstraint.factType);
            QueryPlanningContext context = new QueryPlanningContext(compilationContext, this.existentialVariables);
            if (!this.head.createQueryPlan(context, null, -1)) {
                return;
            }
            this.body.createEnforcePlan(context, this.priority);
            initConstraint.plans.add(new PrioritizedPlan(this.priority, activeFact, context.getPlanOps()));
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        visitor.visit(this);
        return b.toString();
    }
}

