/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants.singletons;

import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.ComparisonFunction;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class NullCheck
extends FunctionValue
implements ComparisonFunction {
    private static final TVar A = Types.var(Kinds.STAR);
    public static final NullCheck INSTANCE = new NullCheck();

    private NullCheck() {
        super(new TVar[]{A}, Types.NO_EFFECTS, Types.BOOLEAN, A);
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        parameters[0].push(mb);
        Label join = mb.createLabel();
        Label isNull = mb.createLabel();
        mb.ifNullBranch(isNull, true);
        mb.loadConstant(false);
        mb.branch(join);
        mb.setLocation(isNull);
        mb.loadConstant(true);
        mb.setLocation(join);
        return this.getReturnType();
    }

    @Override
    public void generateCondition(MethodBuilder mb, Val[] parameters, Cont then_, Cont else_) {
        parameters[0].push(mb);
        mb.ifNullBranch(mb.getLabel(then_), true);
        mb.jump(else_);
        mb.ensureExists(then_);
    }

    public String toString() {
        return "nullCheck";
    }
}

