/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Write;
import org.simantics.issues.common.IssueUtils;

public class NewUserIssue
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Session session = Simantics.getSession();
            VirtualGraph vg = null;
            session.syncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    Resource issue = IssueUtils.newUserIssueForModel((WriteGraph)graph);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created new User Issue " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)issue) + " " + issue.toString()));
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }
}

