/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.Activator;
import org.simantics.document.DocumentDialect;
import org.simantics.document.DocumentSettings;
import org.simantics.document.PhantomJSDriver;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.wiki.ui.editor.IExportable;

public class Exportable
implements IExportable {
    private final String html;
    private final DocumentSettings settings;
    private static final String DEFAULT_CSS = Exportable.getBundleFileContents("simantics-wiki-documents.css", "");
    public static final String DEFAULT_MODEL_CSS = Exportable.getBundleFileContents("simantics-wiki-documents-default-model.css", "");

    private static String getBundleFileContents(String path, String defaultValue) {
        URL url = BundleUtils.find((Bundle)Activator.getContext().getBundle(), (String)path);
        if (url == null) {
            return defaultValue;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = url.openStream();){
                return FileUtils.getContents((InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
            return defaultValue;
        }
    }

    public Exportable(ReadGraph graph, Resource res, String wiki, String css, DocumentSettings settings, boolean print) {
        try {
            wiki = DocumentDialect.INSTANCE.apply(graph, res, wiki);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        this.settings = settings;
        MarkupParser markupParser = new MarkupParser();
        markupParser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        String html = markupParser.parseToHtml(wiki);
        String width = "width:" + (210 - settings.marginLeft - settings.marginRight) + "mm;";
        if (print) {
            html = html.replace("<body>", "<body style=\"background-color:#fff\"><div style=\"background-color:#FFF;" + width + "\">");
            html = html.replace("</body>", "</div></body>");
        } else {
            String div1 = "margin-left:3mm;margin-top:3mm;background-color:#FFF;width:210mm;";
            String div2 = "background-color:#FFF;width:210mm;padding-top:" + settings.marginTop + "mm;";
            String div3 = "overflow-x:hidden;margin-left:" + settings.marginLeft + "mm;background-color:#FFF;" + width;
            html = html.replace("<body>", "<body><div style=\"" + div1 + "\"><div style=\"" + div2 + "\"><div style=\"" + div3 + "\">");
            html = html.replace("</body>", "</div></div></div></body>");
        }
        html = html.replace("<td>", "<td><div>");
        html = html.replace("<th>", "<th><div>");
        html = html.replace("</td>", "</div></td>");
        html = html.replace("</th>", "</div></th>");
        this.html = html = html.replace("</head>", "<style type=\"text/css\">\n" + DEFAULT_CSS + css + "\n</style>\n</head>\n");
    }

    public String getHTML() {
        return this.html;
    }

    public int export(Document document, PdfWriter writer) throws DocumentException {
        File temp = Simantics.getTempfile((String)"wikiPdfExport", (String)"pdf");
        try {
            temp.getParentFile().mkdirs();
            PhantomJSDriver.print(this.html, this.settings, temp);
            int result = 0;
            PdfContentByte cb = writer.getDirectContent();
            PdfReader reader = new PdfReader((InputStream)new BufferedInputStream(new FileInputStream(temp)));
            int i = 1;
            while (i <= reader.getNumberOfPages()) {
                document.setPageSize(PageSize.A4);
                document.newPage();
                PdfImportedPage page = writer.getImportedPage(reader, i);
                float pts = Utilities.millimetersToPoints((float)10.0f);
                cb.addTemplate((PdfTemplate)page, pts, pts);
                ++result;
                ++i;
            }
            return result;
        }
        catch (IOException e) {
            throw new DocumentException((Exception)e);
        }
    }
}

