/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.swt.widgets.WidgetImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.language.MediaWikiLanguage;

public class WikiBrowser
extends WidgetImpl {
    private ReadFactory<?, String> textFactory;
    private ReadFactory<?, Variable> variableFactory;
    private String text;
    private Variable variable;
    private final Display display;
    private final Browser browser;
    private Tuple lastAppliedParametrization;

    public WikiBrowser(Composite parent, WidgetSupport support, int style) {
        super(support);
        this.display = parent.getDisplay();
        this.browser = new Browser(parent, style);
        support.register(this);
    }

    public void setTextFactory(ReadFactory<?, String> textFactory) {
        this.textFactory = textFactory;
    }

    public void setVariableFactory(ReadFactory<?, Variable> variableFactory) {
        this.variableFactory = variableFactory;
    }

    public Browser getWidget() {
        return this.browser;
    }

    @Override
    public Control getControl() {
        return this.browser;
    }

    private void update() {
        String text = this.text;
        Variable variable = this.variable;
        System.out.println("update(" + text + ", " + variable + ")");
        if (text == null || variable == null || this.browser.isDisposed()) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                final String text = WikiBrowser.this.text;
                final Variable variable = WikiBrowser.this.variable;
                if (text == null || variable == null || WikiBrowser.this.browser.isDisposed()) {
                    return;
                }
                Tuple checkParam = new Tuple(new Object[]{text, variable});
                if (checkParam.equals((Object)WikiBrowser.this.lastAppliedParametrization)) {
                    return;
                }
                WikiBrowser.this.lastAppliedParametrization = checkParam;
                try {
                    String markup = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            return SimanticsDialect.INSTANCE.apply(graph, variable, text);
                        }
                    });
                    MarkupParser markupParser = new MarkupParser();
                    MediaWikiLanguage language = new MediaWikiLanguage();
                    markupParser.setMarkupLanguage((MarkupLanguage)language);
                    String htmlContent = markupParser.parseToHtml(markup);
                    if (htmlContent == null) {
                        return;
                    }
                    WikiBrowser.this.browser.setText(htmlContent);
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        });
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        if (this.textFactory != null) {
            this.textFactory.listen(context, input, new Listener<String>(){

                public void exception(Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }

                public void execute(String text) {
                    WikiBrowser.this.text = text;
                    WikiBrowser.this.update();
                }

                public boolean isDisposed() {
                    return WikiBrowser.this.browser.isDisposed();
                }
            });
        }
        if (this.variableFactory != null) {
            this.variableFactory.listen(context, input, new Listener<Variable>(){

                public void exception(Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }

                public void execute(Variable variable) {
                    WikiBrowser.this.variable = variable;
                    WikiBrowser.this.update();
                }

                public boolean isDisposed() {
                    return WikiBrowser.this.browser.isDisposed();
                }
            });
        }
    }

    public boolean isDisposed() {
        return this.browser.isDisposed();
    }
}

