/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.part.PageSwitcher;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;
import org.simantics.browsing.ui.swt.TabbedPageSelectionProvider;
import org.simantics.browsing.ui.swt.TabbedPropertyPageViewSite;

public abstract class TabbedPropertyPage
extends ViewPart {
    protected static final int PAGE_CONTAINER_SITE = 65535;
    private static final String TRACING_COMPONENT = "MPE";
    private INestable activeServiceLocator;
    private CTabFolder container;
    private Composite pageContainer;
    private final ArrayList nestedEditors = new ArrayList(3);
    private final List pageSites = new ArrayList(3);
    private IServiceLocator pageContainerSite;
    IWorkbenchPart part;

    public int addPage(Control control) {
        int index = this.getPageCount();
        this.addPage(index, control);
        return index;
    }

    public int addPage(Control control, String text, Image image) {
        int result = this.addPage(control);
        this.setPageText(result, text);
        this.setPageImage(result, image);
        return result;
    }

    public void addPage(int index, Control control) {
        this.createItem(index, control);
    }

    private CTabFolder createContainer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        final CTabFolder newContainer = new CTabFolder(parent, this.getContainerStyle());
        newContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = newContainer.indexOf((CTabItem)e.item);
                TabbedPropertyPage.this.pageChange(newPageIndex);
            }
        });
        return newContainer;
    }

    protected int getContainerStyle() {
        return 0x800400;
    }

    private CTabItem createItem(int index, Control control) {
        CTabItem item = new CTabItem(this.getTabFolder(), 0, index);
        item.setControl(control);
        return item;
    }

    protected abstract void createPages();

    public final void createPartControl(Composite parent) {
        this.pageContainer = this.createPageContainer(parent);
        this.container = this.createContainer(this.pageContainer);
        this.createPages();
        if (this.getActivePage() == -1) {
            IViewSite serviceLocator;
            this.setActivePage(0);
            IViewSite site = this.getViewSite();
            if (site != null && (serviceLocator = site) instanceof INestable) {
                this.activeServiceLocator = (INestable)serviceLocator;
                this.activeServiceLocator.activate();
            }
        }
        this.initializePageSwitching();
    }

    protected void initializePageSwitching() {
        new PageSwitcher(this.getSite().getPart()){

            public Object[] getPages() {
                int pageCount = TabbedPropertyPage.this.getPageCount();
                Object[] result = new Object[pageCount];
                int i = 0;
                while (i < pageCount) {
                    result[i] = new Integer(i);
                    ++i;
                }
                return result;
            }

            public String getName(Object page) {
                return TabbedPropertyPage.this.getPageText((Integer)page);
            }

            public ImageDescriptor getImageDescriptor(Object page) {
                Image image = TabbedPropertyPage.this.getPageImage((Integer)page);
                if (image == null) {
                    return null;
                }
                return ImageDescriptor.createFromImage((Image)image);
            }

            public void activatePage(Object page) {
                TabbedPropertyPage.this.setActivePage((Integer)page);
            }

            public int getCurrentPageIndex() {
                return TabbedPropertyPage.this.getActivePage();
            }
        };
    }

    protected Composite createPageContainer(Composite parent) {
        return parent;
    }

    public Composite getPageContainer() {
        return this.pageContainer;
    }

    protected IViewSite createSite(IViewPart editor) {
        return new TabbedPropertyPageViewSite(this, editor);
    }

    public void dispose() {
        int i = 0;
        while (i < this.nestedEditors.size()) {
            IEditorPart editor = (IEditorPart)this.nestedEditors.get(i);
            this.disposePart((IWorkbenchPart)editor);
            ++i;
        }
        this.nestedEditors.clear();
        if (this.pageContainerSite instanceof IDisposable) {
            ((IDisposable)this.pageContainerSite).dispose();
            this.pageContainerSite = null;
        }
        i = 0;
        while (i < this.pageSites.size()) {
            IServiceLocator sl = (IServiceLocator)this.pageSites.get(i);
            if (sl instanceof IDisposable) {
                ((IDisposable)sl).dispose();
            }
            ++i;
        }
        this.pageSites.clear();
    }

    protected IEditorPart getActiveEditor() {
        int index = this.getActivePage();
        if (index != -1) {
            return this.getEditor(index);
        }
        return null;
    }

    protected int getActivePage() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null && !tabFolder.isDisposed()) {
            return tabFolder.getSelectionIndex();
        }
        return -1;
    }

    protected Composite getContainer() {
        return this.container;
    }

    protected Control getControl(int pageIndex) {
        return this.getItem(pageIndex).getControl();
    }

    protected IEditorPart getEditor(int pageIndex) {
        Object data;
        CTabItem item = this.getItem(pageIndex);
        if (item != null && (data = item.getData()) instanceof IEditorPart) {
            return (IEditorPart)data;
        }
        return null;
    }

    protected final IServiceLocator getPageSite(int pageIndex) {
        if (pageIndex == 65535) {
            return this.getPageContainerSite();
        }
        CTabItem item = this.getItem(pageIndex);
        if (item != null) {
            Object data = item.getData();
            if (data instanceof IEditorPart) {
                return ((IEditorPart)data).getSite();
            }
            if (data instanceof IServiceLocator) {
                return (IServiceLocator)data;
            }
            if (data == null) {
                IServiceLocatorCreator slc = (IServiceLocatorCreator)this.getSite().getService(IServiceLocatorCreator.class);
                IServiceLocator sl = slc.createServiceLocator((IServiceLocator)this.getSite(), null, new IDisposable(){

                    public void dispose() {
                    }
                });
                item.setData((Object)sl);
                this.pageSites.add(sl);
                return sl;
            }
        }
        return null;
    }

    private IServiceLocator getPageContainerSite() {
        if (this.pageContainerSite == null) {
            IServiceLocatorCreator slc = (IServiceLocatorCreator)this.getSite().getService(IServiceLocatorCreator.class);
            this.pageContainerSite = slc.createServiceLocator((IServiceLocator)this.getSite(), null, new IDisposable(){

                public void dispose() {
                }
            });
        }
        return this.pageContainerSite;
    }

    private CTabItem getItem(int pageIndex) {
        return this.getTabFolder().getItem(pageIndex);
    }

    protected int getPageCount() {
        CTabFolder folder = this.getTabFolder();
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    protected Image getPageImage(int pageIndex) {
        return this.getItem(pageIndex).getImage();
    }

    protected String getPageText(int pageIndex) {
        return this.getItem(pageIndex).getText();
    }

    protected CTabFolder getTabFolder() {
        return this.container;
    }

    protected void handlePropertyChange(int propertyId) {
        this.firePropertyChange(propertyId);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        site.setSelectionProvider((ISelectionProvider)new TabbedPageSelectionProvider(this));
    }

    protected void pageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor;
        this.deactivateSite(false, false);
        IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
        if (partService != null && partService.getActivePart() == this) {
            this.setFocus(newPageIndex);
        }
        if ((activeEditor = this.getEditor(newPageIndex)) != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            ISelectionProvider outerProvider = this.getSite().getSelectionProvider();
            if (outerProvider instanceof MultiPageSelectionProvider) {
                SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
                MultiPageSelectionProvider provider = (MultiPageSelectionProvider)outerProvider;
                provider.fireSelectionChanged(event);
                provider.firePostSelectionChanged(event);
            } else if (Policy.DEBUG_MPE) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("MultiPageEditorPart " + this.getTitle() + " did not propogate selection for " + activeEditor.getTitle()));
            }
        }
        this.activateSite();
    }

    protected final void deactivateSite(boolean immediate, boolean containerSiteActive) {
        IServiceLocator containerSite;
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        int pageIndex = this.getActivePage();
        IKeyBindingService service = this.getSite().getKeyBindingService();
        if (pageIndex < 0 || pageIndex >= this.getPageCount() || immediate) {
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService(null);
            } else {
                WorkbenchPlugin.log((String)("MultiPageEditorPart.setFocus()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead."));
            }
        }
        if (containerSiteActive && (containerSite = this.getPageContainerSite()) instanceof INestable) {
            this.activeServiceLocator = (INestable)containerSite;
            this.activeServiceLocator.activate();
        }
    }

    protected final void activateSite() {
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        IKeyBindingService service = this.getSite().getKeyBindingService();
        int pageIndex = this.getActivePage();
        IEditorPart editor = this.getEditor(pageIndex);
        if (editor != null) {
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService((IWorkbenchSite)editor.getEditorSite());
            } else {
                WorkbenchPlugin.log((String)("MultiPageEditorPart.setFocus()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead."));
            }
            IEditorSite serviceLocator = editor.getEditorSite();
            if (serviceLocator instanceof INestable) {
                this.activeServiceLocator = (INestable)serviceLocator;
                this.activeServiceLocator.activate();
            }
        } else {
            CTabItem item = this.getItem(pageIndex);
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService(null);
            } else {
                WorkbenchPlugin.log((String)("MultiPageEditorPart.setFocus()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead."));
            }
            if (item.getData() instanceof INestable) {
                this.activeServiceLocator = (INestable)item.getData();
                this.activeServiceLocator.activate();
            }
        }
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                IWorkbenchPartSite partSite = part.getSite();
                part.dispose();
                if (partSite instanceof MultiPageEditorSite) {
                    ((MultiPageEditorSite)partSite).dispose();
                }
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void removePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        IEditorPart editor = this.getEditor(pageIndex);
        CTabItem item = this.getItem(pageIndex);
        IServiceLocator pageLocator = null;
        if (item.getData() instanceof IServiceLocator) {
            pageLocator = (IServiceLocator)item.getData();
        }
        Control pageControl = item.getControl();
        item.dispose();
        if (pageControl != null) {
            pageControl.dispose();
        }
        if (editor != null) {
            this.nestedEditors.remove(editor);
            this.disposePart((IWorkbenchPart)editor);
        }
        if (pageLocator != null) {
            this.pageSites.remove(pageLocator);
            if (pageLocator instanceof IDisposable) {
                ((IDisposable)pageLocator).dispose();
            }
        }
    }

    protected void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getTabFolder().setSelection(pageIndex);
        this.pageChange(pageIndex);
    }

    protected void setControl(int pageIndex, Control control) {
        this.getItem(pageIndex).setControl(control);
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(int pageIndex) {
        IEditorPart editor = this.getEditor(pageIndex);
        if (editor != null) {
            editor.setFocus();
        } else {
            Control control = this.getControl(pageIndex);
            if (control != null) {
                control.setFocus();
            }
        }
    }

    protected void setPageImage(int pageIndex, Image image) {
        this.getItem(pageIndex).setImage(image);
    }

    protected void setPageText(int pageIndex, String text) {
        this.getItem(pageIndex).setText(text);
    }

    public Object getAdapter(Class adapter) {
        IEditorPart innerEditor;
        Object result = super.getAdapter(adapter);
        if (result == null && Display.getCurrent() != null && (innerEditor = this.getActiveEditor()) != null && innerEditor != this) {
            result = Util.getAdapter((Object)innerEditor, (Class)adapter);
        }
        return result;
    }

    public IViewSite getViewSite() {
        if (this.part instanceof IViewPart) {
            return ((IViewPart)this.part).getViewSite();
        }
        return null;
    }

    public IWorkbenchPartSite getSite() {
        return this.part.getSite();
    }

    public TabbedPropertyPage(IWorkbenchPart part) {
        this.part = part;
    }
}

