/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledControl;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;

public class ModelledComposite
implements ModelledControl {
    private final Resource configuration;

    public ModelledComposite(Resource configuration) {
        this.configuration = configuration;
    }

    public Composite create(Composite parent, IWorkbenchSite site, ISessionContext context, WidgetSupport support) throws DatabaseException {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Layout layout = (Layout)Simantics.getSession().syncRequest((Read)new Read<Layout>(){

            public Layout perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Integer columns = (Integer)graph.getPossibleRelatedValue(ModelledComposite.this.configuration, br.Composite_ColumnCount, (Binding)Bindings.INTEGER);
                GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(0, 0).spacing(0, 0).create();
                if (columns != null) {
                    layout.numColumns = columns;
                }
                return layout;
            }
        });
        composite.setLayout(layout);
        List children = (List)Simantics.getSession().syncRequest((Read)new Read<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource tabList = graph.getPossibleObject(ModelledComposite.this.configuration, br.Composite_Children);
                if (tabList == null) {
                    return Collections.emptyList();
                }
                return OrderedSetUtils.toList((ReadGraph)graph, (Resource)tabList);
            }
        });
        for (Resource child : children) {
            ModelledControl control = (ModelledControl)Simantics.getSession().syncRequest((AsyncRead)new PossibleAdapter(child, ModelledControl.class));
            control.create(composite, site, context, support);
        }
        return composite;
    }
}

