/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.editors.win32;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.editors.win32.IEditorDefinitionExtension;
import org.simantics.editors.win32.ole.EditorDefinition;
import org.simantics.utils.ui.ErrorLogger;

public class EditorDefinitionManager
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.editors.win32";
    private static final String EP_NAME = "editorDefinition";
    private ExtensionTracker tracker;
    private List<IEditorDefinitionExtension> extensions = new ArrayList<IEditorDefinitionExtension>();
    private static EditorDefinitionManager INSTANCE;

    public static synchronized EditorDefinitionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EditorDefinitionManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    private EditorDefinitionManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new ArrayList<IEditorDefinitionExtension>();
    }

    public synchronized List<IEditorDefinitionExtension> getExtensions(String perspectiveId) {
        if (this.extensions == null) {
            return Arrays.asList(new IEditorDefinitionExtension[0]);
        }
        return Collections.unmodifiableList(this.extensions);
    }

    private synchronized void loadExtensions(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                EditorDefinition fac = (EditorDefinition)el.createExecutableExtension("factory");
                IEditorDefinitionExtension.Stub ext = new IEditorDefinitionExtension.Stub(fac);
                this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                this.extensions.add(ext);
            }
            catch (Exception e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public synchronized void removeExtension(IExtension extension, Object[] objects) {
        ArrayList<IEditorDefinitionExtension> newExtensions = new ArrayList<IEditorDefinitionExtension>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            IEditorDefinitionExtension ext = (IEditorDefinitionExtension)o;
            this.tracker.unregisterObject(extension, (Object)ext);
            this.extensions.remove(ext);
            ++n2;
        }
        this.extensions = newExtensions;
    }

    public EditorDefinition getFactoryForSuffix(String suffix) {
        for (IEditorDefinitionExtension e : this.extensions) {
            if (!e.getFactory().supportSuffix(suffix)) continue;
            return e.getFactory();
        }
        return null;
    }
}

