/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.adapter;

import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.spreadsheet.graph.SpreadsheetSessionManager;

public class SpreadsheetBookRemover
extends EntityRemover {
    public SpreadsheetBookRemover(Resource resource) {
        super(resource);
    }

    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        return super.canRemove(graph, aux);
    }

    public void remove(WriteGraph graph) throws DatabaseException {
        String bookURI = graph.getPossibleURI(this.resource);
        if (bookURI != null) {
            for (String realmId : SpreadsheetSessionManager.getInstance().getRealms()) {
                if (!realmId.startsWith(bookURI)) continue;
                SpreadsheetSessionManager.getInstance().removeRealm(realmId);
            }
        }
        super.remove(graph);
    }
}

