/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.swt.GraphExplorerDialog2;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.IsLinkedTo;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Pair;

public class SaveSpreadsheetStateDialog
extends GraphExplorerDialog2 {
    private static final String SELECT_CUSTOM = "Select custom..";
    private Combo parentSelector;
    private Pair<String, Resource>[] pairs;
    private String[] parents;
    private Text stateName;
    private String currentItem;
    private String currentStateName;
    private List<Resource> result;

    public SaveSpreadsheetStateDialog(IWorkbenchSite site, String title, Pair<String, Resource>[] pairs) {
        super(site, title);
        this.pairs = pairs;
        final Resource book = (Resource)pairs[0].second;
        final Resource context = (Resource)pairs[1].second;
        try {
            this.result = (List)Simantics.getSession().syncRequest((Read)new UniqueRead<List<Resource>>(){

                public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                    Resource bookINdex = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(book));
                    Resource contextIndex = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(context));
                    ArrayList<Resource> result = new ArrayList<Resource>();
                    Set indexRoots = Layer0Utils.listIndexRoots((ReadGraph)graph);
                    for (Resource indexRoot : indexRoots) {
                        if (!((Boolean)graph.syncRequest((Read)new IsLinkedTo(indexRoot, bookINdex))).booleanValue() || !((Boolean)graph.syncRequest((Read)new IsLinkedTo(indexRoot, contextIndex))).booleanValue()) continue;
                        result.add(indexRoot);
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        String[] newParents = new String[pairs.length + 1];
        int i = 0;
        while (i < pairs.length) {
            newParents[i] = (String)pairs[i].first;
            ++i;
        }
        newParents[pairs.length] = SELECT_CUSTOM;
        this.parents = newParents;
    }

    public Set<String> getBrowseContexts() {
        return Collections.singleton("http://www.simantics.org/Project-1.2/ProjectBrowseContext");
    }

    protected SessionContextInputSource getInputSource() {
        return super.getInputSource();
    }

    protected void createControls(Composite body, ISessionContext context, WidgetSupport support) {
        Composite upperComposite = new Composite(body, 0);
        GridLayout layout = new GridLayout(2, false);
        upperComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)upperComposite);
        Composite explorerComposite = new Composite(body, 0);
        explorerComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)explorerComposite);
        Label parentLabel = new Label(upperComposite, 0);
        parentLabel.setText("Select parent: ");
        this.parentSelector = new Combo(upperComposite, 8);
        this.parentSelector.setItems(this.parents);
        this.parentSelector.select(0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parentSelector);
        this.parentSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveSpreadsheetStateDialog.this.hideOrShowGE();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label stateNameLabel = new Label(upperComposite, 0);
        stateNameLabel.setText("Name of the state: ");
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)stateNameLabel);
        this.stateName = new Text(upperComposite, 0);
        this.stateName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveSpreadsheetStateDialog.this.currentStateName = SaveSpreadsheetStateDialog.this.stateName.getText();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.stateName);
        super.createControls(explorerComposite, context, support);
        this.hideOrShowGE();
    }

    private void hideOrShowGE() {
        int selection = this.parentSelector.getSelectionIndex();
        this.currentItem = this.parentSelector.getItem(selection);
        GraphExplorerComposite composite = this.getGraphExplorerComposite();
        GridData data = (GridData)composite.getLayoutData();
        data.exclude = !this.currentItem.equals(SELECT_CUSTOM);
        composite.setLayoutData((Object)data);
        composite.setVisible(!data.exclude);
        composite.getParent().pack();
        composite.getParent().layout();
        composite.getParent().getParent().pack();
        composite.getParent().getParent().layout();
        composite.getParent().getParent().getParent().getParent().getParent();
        composite.getShell().pack();
        composite.getShell().layout();
    }

    public Object[] getSelection() {
        if (this.currentItem.equals(SELECT_CUSTOM)) {
            Object[] selection = super.getSelection();
            NodeContext context = (NodeContext)selection[0];
            Object obj = context.getConstant(BuiltinKeys.INPUT);
            return new Object[]{Pair.make((Object)obj, (Object)this.currentStateName)};
        }
        int i = 0;
        while (i < this.pairs.length) {
            Pair<String, Resource> p = this.pairs[i];
            if (((String)p.first).equals(this.currentItem)) {
                return new Object[]{Pair.make((Object)((Resource)p.second), (Object)this.currentStateName)};
            }
            ++i;
        }
        return null;
    }
}

