/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.refactoring;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.representation.TransferableGraph1;

public class FixExportedOntology {
    static void convertExportedSharedOntologyIntoBundleOntology(Path input, Path output) throws Exception {
        System.out.format("Converting exported shared ontology%n\t" + input.toString() + "%nto bundle-compatible ontology%n\t" + output.toString(), new Object[0]);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(input, new OpenOption[0]), 131072);){
            DataInputStream dis = new DataInputStream(is);
            DataContainer container = DataContainers.readFile((DataInput)dis);
            Binding binding = TransferableGraph1.BINDING;
            TransferableGraph1 graph = (TransferableGraph1)container.content.getValue(binding);
            GraphRefactoringUtils.fixOntologyExport(graph);
            DataContainers.writeFile((File)output.toFile(), (DataContainer)new DataContainer(container.format, container.version, container.metadata, new Variant(TransferableGraph1.BINDING, (Object)graph)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Required arguments: <input .sharedOntology file> [<output .tg file>]");
        } else if (args.length < 2) {
            Path input = Paths.get(args[0], new String[0]);
            Path output = input.getParent().resolve(input.getName(input.getNameCount() - 1) + ".fixed");
            FixExportedOntology.convertExportedSharedOntologyIntoBundleOntology(input, output);
        } else {
            FixExportedOntology.convertExportedSharedOntologyIntoBundleOntology(Paths.get(args[0], new String[0]), Paths.get(args[1], new String[0]));
        }
    }
}

