/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;

public class NotInstruction
implements IInstruction {
    IInstruction instruction;

    public NotInstruction(IInstruction instruction) {
        this.instruction = instruction;
    }

    @Override
    public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
        return this.instruction.deny(g, bindings);
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.instruction.collectVariables(reads, writes);
    }

    @Override
    public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
        return this.instruction.claim(g, bindings);
    }

    @Override
    public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
        this.instruction.doDeny(g, bindings);
    }

    @Override
    public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
        this.instruction.doClaim(g, bindings);
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.instruction.mapVariables(map);
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation) {
        return IInstruction.FAILURE;
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        if (this.instruction.query(g, bindings) == IInstruction.FAILURE) {
            return null;
        }
        return IInstruction.FAILURE;
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("not ");
        this.instruction.toString(b, indent);
    }
}

