/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.issues;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.simantics.scl.compiler.errors.ErrorSeverity;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.editor2.OpenSCLDefinition;
import org.simantics.scl.ui.issues.SCLIssuesContentProvider;
import org.simantics.scl.ui.issues.SCLIssuesTableEntry;

public class SCLIssuesView
extends ViewPart {
    private static final int COLUMN1_DEFAULT_WIDTH = 300;
    private static final int COLUMN2_MIN_WIDTH = 100;
    Composite parent;
    TableViewer tableViewer;
    TableViewerColumn column1;
    TableViewerColumn column2;
    ImageRegistry imageRegistry;
    SCLIssuesContentProvider issuesContentProvider = new SCLIssuesContentProvider();

    public SCLIssuesView() {
        this.imageRegistry = Activator.getInstance().getImageRegistry();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        Action action = new Action("Refresh"){

            public void run() {
                SCLOsgi.MODULE_REPOSITORY.getSourceRepository().checkUpdates();
            }
        };
        action.setImageDescriptor(this.imageRegistry.getDescriptor("arrow_refresh"));
        site.getActionBars().getToolBarManager().add((IAction)action);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer(parent, 66308);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)this.issuesContentProvider);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.column1 = new TableViewerColumn(this.tableViewer, 0);
        this.column1.getColumn().setText("Module");
        this.column1.getColumn().setWidth(300);
        this.column1.getColumn().setResizable(true);
        this.column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SCLIssuesTableEntry entry = (SCLIssuesTableEntry)element;
                return entry.moduleName;
            }

            public Image getImage(Object element) {
                SCLIssuesTableEntry entry = (SCLIssuesTableEntry)element;
                return entry.error.severity == ErrorSeverity.ERROR ? SCLIssuesView.this.imageRegistry.get("error") : SCLIssuesView.this.imageRegistry.get("warning");
            }
        });
        this.column2 = new TableViewerColumn(this.tableViewer, 0);
        this.column2.getColumn().setText("Description");
        this.column2.getColumn().setResizable(false);
        this.column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SCLIssuesTableEntry entry = (SCLIssuesTableEntry)element;
                String description = entry.error.description;
                int p = description.indexOf(10);
                if (p == -1) {
                    return description;
                }
                return description.substring(0, p);
            }

            public String getToolTipText(Object element) {
                SCLIssuesTableEntry entry = (SCLIssuesTableEntry)element;
                return entry.error.description;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 15000;
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 500;
            }

            public Point getToolTipShift(Object object) {
                return new Point(0, 0);
            }
        });
        ControlAdapter resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SCLIssuesView.this.resizeColumns();
            }
        };
        parent.addControlListener((ControlListener)resizeListener);
        this.column1.getColumn().addControlListener((ControlListener)resizeListener);
        this.tableViewer.setInput((Object)SCLOsgi.MODULE_REPOSITORY);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SCLIssuesTableEntry entry = (SCLIssuesTableEntry)selection.getFirstElement();
                OpenSCLDefinition.openDefinition(entry.moduleName, entry.error.location);
            }
        });
    }

    private void resizeColumns() {
        Table table = this.tableViewer.getTable();
        Rectangle area = this.parent.getClientArea();
        Point size = table.computeSize(-1, -1);
        ScrollBar vBar = table.getVerticalBar();
        int width = area.width;
        if (size.y > area.height + table.getHeaderHeight()) {
            Point vBarSize = vBar.getSize();
            width -= vBarSize.x;
        }
        Point oldSize = table.getSize();
        if (oldSize.x > area.width) {
            this.column2.getColumn().setWidth(Math.max(100, width - this.column1.getColumn().getWidth()));
            table.setSize(area.width, area.height);
        } else {
            table.setSize(area.width, area.height);
            this.column2.getColumn().setWidth(Math.max(100, width - this.column1.getColumn().getWidth()));
        }
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.issuesContentProvider.dispose();
    }
}

