/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.DoesNotExist;
import org.simantics.scl.compiler.errors.ErrorSeverity;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.ui.editor2.SCLModuleEditorInput;

public class SCLAnnotationModel
extends AnnotationModel {
    private final SCLModuleEditorInput input;
    private final ModuleRepository repository;
    private volatile boolean connected = false;
    UpdateListener updateListener = new UpdateListener(){

        public void notifyAboutUpdate() {
            if (SCLAnnotationModel.this.connected) {
                SCLAnnotationModel.this.updateAnnotations();
            }
        }
    };

    public SCLAnnotationModel(SCLModuleEditorInput input, ModuleRepository repository) {
        this.input = input;
        this.repository = repository;
    }

    private void updateAnnotations() {
        Failable result = this.repository.getModule(this.input.getModuleName(), this.updateListener);
        if (result instanceof Failure) {
            Failure failure = (Failure)result;
            this.setAnnotations(Arrays.asList(failure.errors));
        } else if (result == DoesNotExist.INSTANCE) {
            this.setAnnotations(Collections.emptyList());
        } else {
            this.setAnnotations(Arrays.asList(((Module)result.getResult()).getWarnings()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(List<CompilationError> errors) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.removeAllAnnotations();
            for (CompilationError error : errors) {
                Annotation annotation = new Annotation(error.severity == ErrorSeverity.ERROR ? "org.eclipse.ui.workbench.texteditor.error" : "org.eclipse.ui.workbench.texteditor.warning", true, error.description);
                int begin = Locations.beginOf((long)error.location);
                int end = Locations.endOf((long)error.location);
                Position position = new Position(begin, end - begin);
                this.addAnnotation(annotation, position);
            }
        }
    }

    public void connect(IDocument document) {
        super.connect(document);
        this.connected = true;
        this.updateAnnotations();
    }

    public void disconnect(IDocument document) {
        this.connected = false;
        this.updateListener.stopListening();
        super.disconnect(document);
    }
}

