/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.console;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.compiler.commands.SCLConsoleListener;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.osgi.internal.TestUtils;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.console.SCLConsole;
import org.simantics.scl.ui.imports.internal.ManageImportsDialog;
import org.simantics.scl.ui.tests.SCLTestsDialog;

public class SCLConsoleView
extends ViewPart {
    public static final String PLUGIN_ID = "org.simantics.scl.ui";
    public static final String IMPORTS = "imports";
    public static final String SEPARATOR = ";";
    public static final String DISABLED_TAG = "[DISABLED]";
    SCLConsole console;

    private ArrayList<CommandSessionImportEntry> readImportPreferences() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        String importsString = store.getString(IMPORTS);
        String[] splitted = importsString.split(SEPARATOR);
        ArrayList<CommandSessionImportEntry> result = new ArrayList<CommandSessionImportEntry>(splitted.length);
        String[] stringArray = splitted;
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String entryString = stringArray[n2];
            if (!entryString.isEmpty()) {
                String[] parts;
                boolean disabled = false;
                if (entryString.startsWith(DISABLED_TAG)) {
                    disabled = true;
                    entryString = entryString.substring(DISABLED_TAG.length());
                }
                CommandSessionImportEntry entry = (parts = entryString.split("=")).length == 1 ? new CommandSessionImportEntry(parts[0], "", true) : new CommandSessionImportEntry(parts[1], parts[0], true);
                entry.disabled = disabled;
                result.add(entry);
            }
            ++n2;
        }
        return result;
    }

    private void writeImportPreferences(ArrayList<CommandSessionImportEntry> entries) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (CommandSessionImportEntry entry : entries) {
            if (!entry.persistent) continue;
            if (first) {
                first = false;
            } else {
                b.append(SEPARATOR);
            }
            if (entry.disabled) {
                b.append(DISABLED_TAG);
            }
            if (!entry.localName.isEmpty()) {
                b.append(entry.localName);
                b.append("=");
            }
            b.append(entry.moduleName);
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        store.putValue(IMPORTS, b.toString());
    }

    private ArrayList<CommandSessionImportEntry> getCurrentImports() {
        return this.console.getSession().getImportEntries();
    }

    private void setCurrentImports(ArrayList<CommandSessionImportEntry> entries) {
        this.console.getSession().setImportEntries(entries);
    }

    private void manageImports() {
        ManageImportsDialog dialog = new ManageImportsDialog(this.getSite().getShell(), this.getCurrentImports());
        if (dialog.open() == 0) {
            this.writeImportPreferences(dialog.getImports());
            this.setCurrentImports(dialog.getImports());
        }
    }

    private void sclTestDialog() {
        List tests = TestUtils.getTests();
        SCLTestsDialog dialog = new SCLTestsDialog(this.getSite().getShell(), tests, true);
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                TestRunnable test = (TestRunnable)result;
                try {
                    this.console.execute("import \"Commands/Tests\"");
                    this.console.execute("runByName \"" + test.getName() + "\"");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.console = new SCLConsole(parent, 0);
        this.setCurrentImports(this.readImportPreferences());
        this.addScriptDropSupport(this.console);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        final Action interruptAction = new Action("Interrupt current command", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/stop.png")){

            public void run() {
                SCLConsoleView.this.console.interruptCurrentCommands();
            }
        };
        interruptAction.setDisabledImageDescriptor(Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/stop_disabled.png"));
        interruptAction.setEnabled(false);
        toolBarManager.add((IAction)interruptAction);
        final Action clearAction = new Action("Clear console", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/clear_console.png")){

            public void run() {
                this.setEnabled(false);
                SCLConsoleView.this.console.clear();
            }
        };
        clearAction.setDisabledImageDescriptor(Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/clear_console_disabled.png"));
        clearAction.setEnabled(false);
        toolBarManager.add((IAction)clearAction);
        this.console.addListener(new SCLConsoleListener(){

            public void startedExecution() {
                interruptAction.setEnabled(true);
            }

            public void finishedExecution() {
                interruptAction.setEnabled(false);
            }

            public void consoleIsNotEmptyAnymore() {
                clearAction.setEnabled(true);
            }
        });
        toolBarManager.add((IAction)new Action("Refresh modules", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/arrow_refresh.png")){

            public void run() {
                SCLConsoleView.this.console.getSession().getModuleRepository().getSourceRepository().checkUpdates();
                SCLConsoleView.this.console.getSession().updateRuntimeEnvironment(true);
                SCLConsoleView.this.console.appendOutput("refresh completed\n", SCLConsoleView.this.console.greenColor, null);
            }
        });
        toolBarManager.add((IAction)new Action("Manage imports", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/configure_imports.png")){

            public void run() {
                SCLConsoleView.this.manageImports();
            }
        });
        if (Platform.inDevelopmentMode()) {
            toolBarManager.add((IAction)new Action("Run tests", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/run_tests.png")){

                public void run() {
                    SCLConsoleView.this.sclTestDialog();
                }
            });
        }
        toolBarManager.update(true);
    }

    private void addScriptDropSupport(SCLConsole console) {
        DropTarget target = new DropTarget((Control)console.getOutputWidget(), 23);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new ScriptRunningDropTarget());
    }

    public void setFocus() {
        this.console.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.console.dispose();
    }

    private class ScriptRunningDropTarget
    extends DropTargetAdapter {
        private ScriptRunningDropTarget() {
        }

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 4;
            }
        }

        public void dragOperationChanged(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 4;
            }
        }

        public void drop(DropTargetEvent event) {
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Object[] files = (String[])((String[])event.data).clone();
                Arrays.sort(files);
                Object[] objectArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = objectArray[n2];
                    Path p = Paths.get((String)file, new String[0]).toAbsolutePath();
                    if (this.isScriptFile(p)) {
                        SCLConsoleView.this.console.execute("runFromFile \"" + p.toString().replace('\\', '/') + "\"");
                    }
                    ++n2;
                }
            }
        }

        private boolean isScriptFile(Path p) {
            return Files.isRegularFile(p, new LinkOption[0]);
        }
    }
}

