/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.tooltips;

import java.util.Map;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.tooltips.TooltipRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;

public class DescriptionTooltipRule
implements TooltipRule {
    public static final DescriptionTooltipRule INSTANCE = new DescriptionTooltipRule();

    @Override
    public Object createTooltip(Object event, Object parentComponent, NodeContext context, Map<Object, Object> auxiliary) {
        Composite parent = (Composite)parentComponent;
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getDisplay().getSystemColor(29));
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Text text = new Text(composite, 72);
        text.setBackground(parent.getDisplay().getSystemColor(29));
        String toolTipContent = (String)auxiliary.get("content");
        text.setText(toolTipContent);
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int width = toolTipContent.length() * fm.getAverageCharWidth();
        gc.dispose();
        GridData gridData = new GridData();
        gridData.widthHint = width < 500 ? width : 500;
        text.setLayoutData((Object)gridData);
        return composite;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType == Resource.class || contentType == Variable.class;
    }

    private static String getToolTipContent(ReadGraph graph, NodeContext nodeContext) throws DatabaseException {
        Object input = nodeContext.getConstant(BuiltinKeys.INPUT);
        String content = null;
        if (input instanceof Variable) {
            Variable var = (Variable)input;
            Resource res = var.getPredicateResource(graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            String description = (String)graph.getPossibleRelatedValue2(res, L0.HasDescription);
            return description;
        }
        if (input instanceof Resource) {
            Resource res = (Resource)input;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            String description = (String)graph.getPossibleRelatedValue2(res, L0.HasDescription);
            return description;
        }
        return content;
    }

    @Override
    public boolean shouldCreateToolTip(ReadGraph graph, NodeContext context, Map<Object, Object> auxiliary) throws DatabaseException {
        String content = DescriptionTooltipRule.getToolTipContent(graph, context);
        if (content == null || content.isEmpty()) {
            return false;
        }
        auxiliary.put("content", content);
        return true;
    }
}

