/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jfree.chart.LegendItem;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.G2DUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.trend.ConfidenceBound;
import org.simantics.sysdyn.ui.trend.SensitivityDatasetProperties;
import org.simantics.sysdyn.ui.trend.XYDataset;
import org.simantics.sysdyn.ui.trend.XYDatasetRequest;
import org.simantics.sysdyn.ui.trend.XYDatasetTempSeries;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Pair;

public class SensitivityDataset
extends XYDataset {
    DeviationRenderer renderer;

    public SensitivityDataset(ReadGraph graph, Resource resource) throws DatabaseException {
        super(graph, resource);
    }

    @Override
    public Dataset getDataset() {
        if (this.dataset == null) {
            this.dataset = new YIntervalSeriesCollection();
        }
        if (this.datasetListener == null || this.datasetListener.isDisposed()) {
            this.datasetListener = new SensitivityDatasetListener();
            SimanticsUI.getSession().asyncRequest((Read)new SensitivityDatasetRequest(this.resource), (Listener)this.datasetListener);
        }
        if (this.timeListener == null || this.timeListener.isDisposed()) {
            SimanticsUI.getSession().asyncRequest(this.getTimeRequest(), this.getTimeListener());
        }
        return this.dataset;
    }

    @Override
    public AbstractRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new DeviationRenderer(true, false){
                private static final long serialVersionUID = 633310754812851862L;

                public LegendItem getLegendItem(int datasetIndex, int series) {
                    LegendItem item = super.getLegendItem(datasetIndex, series);
                    return new LegendItem(item.getLabel(), item.getDescription(), item.getToolTipText(), item.getURLText(), item.getLine(), (Stroke)new BasicStroke(5.0f), item.getLinePaint());
                }
            };
        }
        return this.renderer;
    }

    private class SensitivityDatasetListener
    extends DisposableListener<Pair<ArrayList<XYDatasetTempSeries>, SensitivityDatasetProperties>> {
        private SensitivityDatasetListener() {
        }

        public void execute(Pair<ArrayList<XYDatasetTempSeries>, SensitivityDatasetProperties> result) {
            final ArrayList series = (ArrayList)result.first;
            final SensitivityDatasetProperties properties = (SensitivityDatasetProperties)result.second;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((SensitivityDatasetListener)SensitivityDatasetListener.this).SensitivityDataset.this.dataset == null || !(((SensitivityDatasetListener)SensitivityDatasetListener.this).SensitivityDataset.this.dataset instanceof YIntervalSeriesCollection)) {
                        return;
                    }
                    YIntervalSeriesCollection ds = (YIntervalSeriesCollection)((SensitivityDatasetListener)SensitivityDatasetListener.this).SensitivityDataset.this.dataset;
                    DeviationRenderer dr = (DeviationRenderer)SensitivityDataset.this.getRenderer();
                    ArrayList<ConfidenceBound> confidenceBounds = properties.getConfidenceBounds();
                    int i = 1;
                    while (i <= confidenceBounds.size()) {
                        dr.setSeriesStroke(i, (Stroke)new BasicStroke(0.0f));
                        dr.setSeriesPaint(i, (Paint)confidenceBounds.get(i - 1).getColor());
                        dr.setSeriesFillPaint(i, (Paint)confidenceBounds.get(i - 1).getColor());
                        ++i;
                    }
                    Color medianColor = Color.RED;
                    dr.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
                    dr.setSeriesPaint(0, (Paint)medianColor);
                    dr.setSeriesFillPaint(0, (Paint)medianColor);
                    dr.setSeriesVisibleInLegend(0, Boolean.valueOf(true));
                    if (!properties.displayMedian()) {
                        dr.setSeriesVisibleInLegend(0, Boolean.valueOf(false));
                        dr.setSeriesPaint(0, dr.getSeriesPaint(1));
                    }
                    dr.setAlpha(1.0f);
                    int i2 = ds.getSeriesCount() - 1;
                    while (i2 >= 0) {
                        ds.removeSeries(ds.getSeries(i2));
                        --i2;
                    }
                    int n = series.size();
                    if (n < 1) {
                        return;
                    }
                    int length = ((XYDatasetTempSeries)series.get((int)0)).values[0].length;
                    YIntervalSeries median = new YIntervalSeries((Comparable)((Object)"Median"));
                    YIntervalSeries[] yIntervalSeries = new YIntervalSeries[confidenceBounds.size()];
                    int i3 = 0;
                    while (i3 < confidenceBounds.size()) {
                        yIntervalSeries[i3] = new YIntervalSeries((Comparable)((Object)(String.valueOf(confidenceBounds.get(i3).getPercent()) + "%")));
                        ++i3;
                    }
                    ArrayList<Double> sorter = new ArrayList<Double>();
                    int i4 = 0;
                    while (i4 < length) {
                        sorter.clear();
                        int j = 0;
                        while (j < n) {
                            if (((XYDatasetTempSeries)series.get((int)j)).values[1].length != 0) {
                                sorter.add(((XYDatasetTempSeries)series.get((int)j)).values[1][i4]);
                            }
                            ++j;
                        }
                        Collections.sort(sorter);
                        int sorterSize = sorter.size();
                        int intervals = sorterSize - 1;
                        double medianX = ((XYDatasetTempSeries)series.get((int)0)).values[0][i4];
                        double medianY = (Double)sorter.get(sorterSize / 2);
                        median.add(medianX, medianY, medianY, medianY);
                        int j2 = 0;
                        while (j2 < yIntervalSeries.length) {
                            YIntervalSeries yis = yIntervalSeries[j2];
                            double percent = properties.getConfidenceBounds().get(j2).getPercent() / 100.0;
                            if ((double)n >= 1.0 / percent * 2.0) {
                                double indexLow = (1.0 - percent) * (double)intervals / 2.0;
                                int indexLowLow = (int)Math.floor(indexLow);
                                int indexLowHigh = (int)Math.ceil(indexLow);
                                double valueLowLow = (Double)sorter.get(indexLowLow);
                                double valueLowHigh = (Double)sorter.get(indexLowHigh);
                                double decimalLow = indexLow - (double)indexLowLow;
                                double estimateLow = (valueLowHigh - valueLowLow) * decimalLow + valueLowLow;
                                double indexHigh = (1.0 + percent) * (double)intervals / 2.0;
                                int indexHighLow = (int)Math.floor(indexHigh);
                                int indexHighHigh = (int)Math.ceil(indexHigh);
                                double valueHighLow = (Double)sorter.get(indexHighLow);
                                double valueHighHigh = (Double)sorter.get(indexHighHigh);
                                double decimalHigh = 1.0 - decimalLow;
                                double estimateHigh = (valueHighHigh - valueHighLow) * decimalHigh + valueHighLow;
                                yis.add(medianX, medianY, estimateLow, estimateHigh);
                            }
                            ++j2;
                        }
                        ++i4;
                    }
                    ds.addSeries(median);
                    int j = 0;
                    while (j < yIntervalSeries.length) {
                        YIntervalSeries yis = yIntervalSeries[j];
                        double percent = properties.getConfidenceBounds().get(j).getPercent();
                        if ((double)n >= 1.0 / percent * 2.0) {
                            ds.addSeries(yis);
                        }
                        ++j;
                    }
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }
    }

    private class SensitivityDatasetRequest
    implements Read<Pair<ArrayList<XYDatasetTempSeries>, SensitivityDatasetProperties>> {
        private Resource dataset;

        public SensitivityDatasetRequest(Resource dataset) {
            this.dataset = dataset;
        }

        public Pair<ArrayList<XYDatasetTempSeries>, SensitivityDatasetProperties> perform(ReadGraph graph) throws DatabaseException {
            Pair XYDatasetRequestResult = (Pair)graph.syncRequest((Read)new XYDatasetRequest(this.dataset));
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            Boolean median = (Boolean)graph.getPossibleRelatedValue(this.dataset, SR.Charts_SensitivityDataset_median);
            if (median == null) {
                median = false;
            }
            Resource confidenceBoundsList = graph.getPossibleObject(this.dataset, SR.Charts_SensitivityDataset_confidenceBounds);
            ArrayList<ConfidenceBound> confidenceBounds = new ArrayList<ConfidenceBound>();
            if (confidenceBoundsList != null) {
                List confidenceBoundResources = ListUtils.toList((ReadGraph)graph, (Resource)confidenceBoundsList);
                for (Resource cb : confidenceBoundResources) {
                    Color color;
                    Double percent = (Double)graph.getPossibleRelatedValue(cb, SR.Charts_SensitivityDataset_ConfidenceBound_percent);
                    Resource c = graph.getPossibleObject(cb, SR.Charts_SensitivityDataset_ConfidenceBound_color);
                    Color color2 = color = c == null ? null : G2DUtils.getColor((ReadGraph)graph, (Resource)c);
                    if (percent == null || color == null) continue;
                    confidenceBounds.add(new ConfidenceBound(percent, color));
                }
            }
            SensitivityDatasetProperties properties = new SensitivityDatasetProperties(median, confidenceBounds);
            return new Pair((Object)((ArrayList)XYDatasetRequestResult.first), (Object)properties);
        }
    }
}

