/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.participant;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.handler.CopyPasteUtil;
import org.simantics.diagram.handler.DefaultCopyPasteStrategy;
import org.simantics.diagram.handler.ElementObjectAssortment;
import org.simantics.diagram.handler.PasteOperation;
import org.simantics.diagram.handler.Paster;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.utils.VariableNameValidator;
import org.simantics.utils.ui.ErrorLogger;

public class SysdynCopyPasteStrategy
extends DefaultCopyPasteStrategy {
    public void paste(PasteOperation op) {
        try {
            Session session = Simantics.getSession();
            if (op.sameDiagram()) {
                if (op.cut) {
                    CopyPasteUtil.localCutPaste((PasteOperation)op);
                    return;
                }
            } else {
                if (CopyPasteUtil.onlyFlagsWithoutCorrespondence((RequestProcessor)session, (ElementObjectAssortment)op.ea) && CopyPasteUtil.checkFlagExternality((RequestProcessor)session, (Iterable)op.ea.flags, (boolean)false)) {
                    CopyPasteUtil.continueFlags((PasteOperation)op);
                    return;
                }
                if (SysdynCopyPasteStrategy.copyingShadowWithoutOriginal(session, op.ea)) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openError((Shell)activeShell, (String)"Error in pasting variables", (String)"Cannot paste a shadow variable to another diagram without the original variable. Shadow variables referring to a variable in another diagram are not supported in the current version.");
                        }
                    });
                    return;
                }
                if (op.cut && SysdynCopyPasteStrategy.cuttingOriginalWithoutAllShadows(session, op.ea)) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openError((Shell)activeShell, (String)"Error in pasting variables", (String)"Cannot cut and paste a variable to another diagram without all of its shadows.");
                        }
                    });
                    return;
                }
            }
            Paster paster = new Paster(session, op);
            paster.perform();
            this.replaceCopiedShadowOriginalsWithCreatedOnes(session, paster.getNodeMap());
            this.renameVariablesInEquations(session, paster.getNodeMap());
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    private static boolean cuttingOriginalWithoutAllShadows(Session session, final ElementObjectAssortment ea) throws DatabaseException {
        return (Boolean)session.syncRequest((Read)new Read<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                for (Resource r : ea.nodeList) {
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    if (!graph.isInstanceOf(r, SR.StockSymbol) && !graph.isInstanceOf(r, SR.AuxiliarySymbol) && !graph.isInstanceOf(r, SR.ValveSymbol) && !graph.isInstanceOf(r, SR.InputSymbol)) continue;
                    Resource component = graph.getPossibleObject(r, MOD.ElementToComponent);
                    Collection shadows = graph.getObjects(component, SR.Shadow_original_Inverse);
                    for (Resource shadow : shadows) {
                        Resource shadowElement = graph.getPossibleObject(shadow, MOD.ComponentToElement);
                        if (ea.nodes.contains(shadowElement)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private static boolean copyingShadowWithoutOriginal(Session session, final ElementObjectAssortment ea) throws DatabaseException {
        return (Boolean)session.syncRequest((Read)new Read<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                for (Resource r : ea.nodeList) {
                    Resource component;
                    Resource original;
                    Resource originalElement;
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    if (!graph.isInstanceOf(r, SR.ShadowSymbol) || ea.nodes.contains(originalElement = graph.getPossibleObject(original = graph.getPossibleObject(component = graph.getPossibleObject(r, MOD.ElementToComponent), SR.Shadow_original), MOD.ComponentToElement))) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private void replaceCopiedShadowOriginalsWithCreatedOnes(Session session, final Paster.NodeMap nodeMap) {
        session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                if (nodeMap == null) {
                    return;
                }
                Set allResources = nodeMap.allResources();
                for (Resource r : allResources) {
                    Resource shadowComponent;
                    Resource original;
                    Resource originalElement;
                    Resource copiedOriginal;
                    if (!graph.isInstanceOf(r, SR.ShadowSymbol) || (copiedOriginal = nodeMap.getResource(originalElement = graph.getPossibleObject(original = graph.getPossibleObject(shadowComponent = graph.getPossibleObject(r, MOD.ElementToComponent), SR.Shadow_original), MOD.ComponentToElement))) == null) continue;
                    Resource copiedShadow = nodeMap.getResource(r);
                    Resource copiedShadowComponent = graph.getPossibleObject(copiedShadow, MOD.ElementToComponent);
                    graph.deny(copiedShadowComponent, SR.Shadow_original);
                    Resource copiedOriginalComponent = graph.getPossibleObject(copiedOriginal, MOD.ElementToComponent);
                    graph.claim(copiedShadowComponent, SR.Shadow_original, copiedOriginalComponent);
                }
            }
        });
    }

    private void renameVariablesInEquations(Session session, final Paster.NodeMap nodeMap) {
        session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                HashSet<Resource> copies = new HashSet<Resource>();
                HashMap<String, String> names = new HashMap<String, String>();
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                if (nodeMap == null) {
                    return;
                }
                for (Resource var : nodeMap.allResources()) {
                    Resource comp = graph.getPossibleObject(var, MOD.ElementToComponent);
                    Resource r = nodeMap.getResource(var);
                    Resource copy = graph.getPossibleObject(r, MOD.ElementToComponent);
                    if (comp == null || copy == null) continue;
                    names.put(NameUtils.getSafeName((ReadGraph)graph, (Resource)comp), NameUtils.getSafeName((ReadGraph)graph, (Resource)copy));
                    copies.add(copy);
                }
                for (Resource copy : copies) {
                    for (String originalName : names.keySet()) {
                        String newName = (String)names.get(originalName);
                        new VariableNameValidator().renameInEquations(graph, copy, originalName, newName);
                    }
                }
            }
        });
    }
}

