/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Connection;
import org.simantics.db.server.internal.ConnectionException;
import org.simantics.db.server.internal.NotConnectedException;
import org.simantics.db.server.internal.Util;

public class ConnectionManager {
    private static final boolean DEBUG = false;
    private static final ConnectionManager connectionManager = new ConnectionManager();
    private final Manager manager = new Manager();
    private final Thread thread = new Thread((Runnable)this.manager, "Connection Manager");
    private boolean stop = false;
    protected List<Connection> connections = Collections.synchronizedList(new LinkedList());

    public static ConnectionManager getInstance() {
        return connectionManager.instance();
    }

    private ConnectionManager() {
        Util.trace("ConnectionManager.new");
    }

    private ConnectionManager instance() {
        if (!this.thread.isAlive()) {
            this.start();
        }
        return this;
    }

    private void processRead(SelectionKey key) {
        block5: {
            Connection c = (Connection)key.attachment();
            SocketChannel sc = (SocketChannel)key.channel();
            try {
                int ops = key.interestOps();
                key.interestOps(ops |= 1);
                c.onRead();
            }
            catch (IOException iOException) {
                if (key.isValid()) {
                    key.attach(null);
                    key.cancel();
                }
                if (!sc.isOpen()) break block5;
                try {
                    sc.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    void connect(Connection connection) throws ProCoreException {
        block4: {
            try {
                if (this.connections.contains(connection)) {
                    throw new ProCoreException("Connection already registered. connection=" + connection);
                }
                connection.prepare4Connection(SocketChannel.open());
                this.connections.add(connection);
                this.manager.selector.wakeup();
                connection.wait4Connection();
            }
            catch (IOException e) {
                throw new ConnectionException("Failed to connect to " + connection + ".", e);
            }
            catch (InterruptedException interruptedException) {
                if (connection.isConnected()) break block4;
                throw new NotConnectedException("Connection interrupted to " + connection + ".");
            }
        }
    }

    private void start() {
        this.thread.start();
        boolean once = true;
        while (this.manager.selectorOpen.getCount() > 0L) {
            try {
                this.manager.selectorOpen.await();
            }
            catch (InterruptedException e) {
                if (!once) continue;
                once = false;
                Util.logError("Wait for selector open interrupted. Continuing wait.", e);
            }
        }
    }

    public void stop() {
        this.stop = true;
        this.manager.selector.wakeup();
    }

    protected class Manager
    implements Runnable {
        private Selector selector;
        private CountDownLatch selectorOpen = new CountDownLatch(1);

        Manager() {
        }

        @Override
        public void run() {
            try {
                this.selector = Selector.open();
                this.selectorOpen.countDown();
                while (true) {
                    int n = this.selector.select();
                    try {
                        if (n > 0) {
                            this.processSelected();
                        }
                        this.processConnectors();
                        if (!ConnectionManager.this.stop) continue;
                        this.selector.close();
                        return;
                    }
                    catch (CancelledKeyException e) {
                        Logger.defaultLogError((String)"Cancelled key in select loop.", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable x) {
                Logger.defaultLogError((String)"Select loop failed.", (Throwable)x);
                return;
            }
        }

        void processConnectors() throws ClosedChannelException {
            while (ConnectionManager.this.connections.size() > 0) {
                Connection c = ConnectionManager.this.connections.remove(0);
                c.register(this.selector);
            }
        }

        void processSelected() {
            Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
            while (i.hasNext()) {
                SelectionKey sk = i.next();
                i.remove();
                try {
                    if (!sk.isValid()) {
                        this.processDisconnect(sk);
                        continue;
                    }
                    if (sk.isConnectable()) {
                        this.processConnect(sk);
                        continue;
                    }
                    if (!sk.isReadable()) continue;
                    ConnectionManager.this.processRead(sk);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    this.processDisconnect(sk);
                }
            }
        }

        private void processDisconnect(SelectionKey key) {
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.onDisconnect();
            key.attach(null);
            key.cancel();
        }

        private void processConnect(SelectionKey key) {
            Connection connection = (Connection)key.attachment();
            SocketChannel sc = (SocketChannel)key.channel();
            try {
                if (sc.finishConnect()) {
                    int ops = key.interestOps() & 0xFFFFFFF7;
                    key.interestOps(ops |= 1);
                    Connection c = connection.onConnectSucceeded(key);
                    if (c == null) {
                        key.attach(null);
                        key.cancel();
                        sc.close();
                    } else {
                        key.attach(c);
                    }
                }
            }
            catch (Throwable x) {
                try {
                    if (key.isValid()) {
                        key.attach(null);
                    }
                    key.cancel();
                    try {
                        sc.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                finally {
                    connection.onConnectFailed(new NotConnectedException("Failed to establish connection.", x));
                }
            }
        }
    }
}

