/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.ConnectionThread;
import org.simantics.db.server.internal.Method;
import org.simantics.db.server.internal.ProCoreClient;
import org.simantics.db.server.internal.ProCoreServer;

class Client {
    private final ProCoreServer proCoreServer;
    private final ProCoreClient proCoreClient;
    private final ConnectionThread connectionThread;
    private boolean closed = false;

    Client(ProCoreServer proCoreServer, ProCoreClient proCoreClient, ConnectionThread connectionThread) {
        this.proCoreServer = proCoreServer;
        this.proCoreClient = proCoreClient;
        this.connectionThread = connectionThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws ProCoreException, InterruptedException {
        ProCoreClient proCoreClient = this.proCoreClient;
        synchronized (proCoreClient) {
            if (!this.connectionThread.isConnected()) {
                this.connectionThread.connect(this.proCoreServer.getPort());
            }
        }
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOpen() {
        ProCoreClient proCoreClient = this.proCoreClient;
        synchronized (proCoreClient) {
            return this.connectionThread.isConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        ProCoreClient proCoreClient = this.proCoreClient;
        synchronized (proCoreClient) {
            return this.closed || !this.connectionThread.isConnected();
        }
    }

    void close() {
        this.proCoreClient.deleteClient(this);
        this.closed = true;
    }

    String execute(String command) throws ProCoreException {
        return this.proCoreClient.execute(command);
    }

    void call(Method m) throws ProCoreException {
        this.proCoreClient.call(m);
    }
}

