/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DPDFRenderingHints;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.utils.QualityHints;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;

public class PDFBuilder {
    private final PdfWriter writer;
    private final FontMapper mapper;
    private final Rectangle pageSize;
    private final PageDesc pageDesc;
    private final boolean fitDiagramContentsToPageMargins;

    public PDFBuilder(PdfWriter writer, FontMapper mapper, Rectangle pageSize, PageDesc pageDesc, boolean fitDiagramContentsToPageMargins) {
        assert (writer != null);
        assert (mapper != null);
        assert (pageSize != null);
        assert (pageDesc != null);
        this.writer = writer;
        this.mapper = mapper;
        this.pageSize = pageSize;
        this.pageDesc = pageDesc;
        this.fitDiagramContentsToPageMargins = fitDiagramContentsToPageMargins;
    }

    public void paint(ICanvasContext canvasContext, boolean writeResults) {
        float pw = this.pageSize.getWidth();
        float ph = this.pageSize.getHeight();
        PdfContentByte cb = this.writer.getDirectContent();
        PdfTemplate tp = cb.createTemplate(pw, ph);
        Graphics2D g2 = tp.createGraphics(pw, ph, this.mapper);
        g2.setRenderingHint(G2DPDFRenderingHints.KEY_PDF_WRITER, tp.getPdfWriter());
        g2.setRenderingHint(G2DPDFRenderingHints.KEY_PDF_BYTECONTENT, tp);
        g2.setRenderingHint(G2DPDFRenderingHints.KEY_PDF_FONTMAPPER, this.mapper);
        double w = this.pageDesc.getOrientedWidth();
        double h = this.pageDesc.getOrientedHeight();
        try {
            IDiagram diagram;
            Rectangle2D diagramRect;
            QualityHints.HIGH_QUALITY_HINTS.setQuality(g2);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            AffineTransform tr = new AffineTransform();
            MarginUtils.Margins m = this.pageDesc.getMargins();
            double mw = this.pageDesc.getOrientedWidth() - m.left.diagramAbsolute - m.right.diagramAbsolute;
            double mh = this.pageDesc.getOrientedHeight() - m.top.diagramAbsolute - m.bottom.diagramAbsolute;
            Rectangle2D.Double controlArea = new Rectangle2D.Double(m.left.diagramAbsolute, m.top.diagramAbsolute, mw, mh);
            if (this.fitDiagramContentsToPageMargins && (diagramRect = DiagramUtils.getContentRect((IDiagram)(diagram = (IDiagram)canvasContext.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM)))) != null) {
                ((TransformUtil)canvasContext.getSingleItem(TransformUtil.class)).fitArea((Rectangle2D)controlArea, diagramRect, MarginUtils.NO_MARGINS);
            }
            tr.scale((double)pw / w, (double)ph / h);
            g2.setTransform(tr);
            g2.setRenderingHint(G2DRenderingHints.KEY_CONTROL_BOUNDS, new Rectangle2D.Double(0.0, 0.0, w, h));
            if (canvasContext.isLocked()) {
                throw new IllegalStateException("cannot render PDF, canvas context is locked: " + canvasContext);
            }
            canvasContext.getSceneGraph().render(g2);
        }
        finally {
            g2.dispose();
            if (writeResults) {
                float x = (float)this.pageDesc.getLeftEdgePos();
                float y = (float)this.pageDesc.getTopEdgePos();
                cb.addTemplate(tp, x, y);
            }
        }
    }
}

