/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.ui.AdaptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualHelp
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextualHelp.class);

    private static String getPossibleId(ExecutionEvent event) {
        Variable variable;
        Resource resource;
        ISelection sel;
        block3: {
            try {
                sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                resource = WorkbenchSelectionUtils.getPossibleResource((Object)sel);
                variable = WorkbenchSelectionUtils.getPossibleVariable((Object)sel);
                if (!sel.isEmpty() || resource != null || variable != null) break block3;
                return null;
            }
            catch (DatabaseException e) {
                LOGGER.error("", (Throwable)e);
                return null;
            }
        }
        return (String)Simantics.getSession().syncRequest((Read)new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                String id;
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                if (resource != null) {
                    String id2;
                    Resource component = graph.getPossibleObject(resource, MOD.ElementToComponent);
                    String string = id2 = component != null ? (String)graph.getPossibleRelatedValue2(component, MOD.contextualHelpId, (Binding)Bindings.STRING) : null;
                    if (id2 != null) {
                        return id2;
                    }
                    id2 = (String)graph.getPossibleRelatedValue2(resource, MOD.contextualHelpId, (Binding)Bindings.STRING);
                    if (id2 != null) {
                        return id2;
                    }
                }
                if (variable != null && (id = (String)variable.getPossiblePropertyValue(graph, MOD.contextualHelpId, (Binding)Bindings.STRING)) != null) {
                    return id;
                }
                if (sel != null) {
                    String id3;
                    PropertyVariables vars = (PropertyVariables)AdaptionUtils.adaptToSingle((Object)sel, PropertyVariables.class);
                    Variable var = vars != null ? vars.getConfiguration() : null;
                    String string = id3 = var != null ? (String)var.getPossiblePropertyValue(graph, MOD.contextualHelpId, (Binding)Bindings.STRING) : null;
                    if (id3 != null) {
                        return id3;
                    }
                }
                return null;
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String id = ContextualHelp.getPossibleId(event);
        if (id != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(id);
        }
        return null;
    }
}

