/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.Activator;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSheetAdapter
extends AbstractResourceEditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSheetAdapter.class);
    private static final String EDITOR_ID = "org.simantics.spreadsheet.ui.editor2";

    public OpenSheetAdapter() {
        super("Spreadsheet Editor", Activator.COMPOSITE_ICON);
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        return g.isInstanceOf(r, SpreadsheetResource.getInstance((ReadGraph)g).Book);
    }

    public void openEditor(final Resource r) throws Exception {
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                Variable variable = Variables.getVariable((ReadGraph)g, (Resource)r);
                final Resource model = (Resource)g.syncRequest((Read)new PossibleIndexRoot(r));
                final RVI rvi = variable.getPossibleRVI(g);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String editorId = OpenSheetAdapter.this.getEditorId();
                            WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput2(editorId, r, model, rvi));
                        }
                        catch (PartInitException e) {
                            LOGGER.error("Failed to open the spreadsheet editor.", (Throwable)e);
                        }
                    }
                });
            }
        });
    }
}

