/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.simantics.PlatformException;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.Transaction;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.compiler.CompilationResult;
import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.GraphCompiler;
import org.simantics.graph.compiler.GraphCompilerPreferences;
import org.simantics.graph.compiler.ValidationMode;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;
import org.simantics.ltk.ISource;
import org.simantics.ltk.Problem;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;

public class CompilePGraphs
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource r = (Resource)target;
        return new Runnable(){

            private void uncheckedClose(Closeable closeable) {
                try {
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (IOException iOException) {}
            }

            private File copyResource(URL url, File targetFile) throws IOException, FileNotFoundException {
                FileOutputStream os = null;
                InputStream is = null;
                try {
                    int read;
                    if (targetFile.exists()) {
                        targetFile.delete();
                    }
                    is = url.openStream();
                    byte[] buffer = new byte[16384];
                    os = new FileOutputStream(targetFile);
                    while ((read = is.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                    }
                    os.close();
                    is.close();
                    File file = targetFile;
                    this.uncheckedClose(os);
                    this.uncheckedClose(is);
                    return file;
                }
                catch (Throwable throwable) {
                    this.uncheckedClose(os);
                    this.uncheckedClose(is);
                    throw throwable;
                }
            }

            private File extractLib(URL libURL, String libName) throws FileNotFoundException, IOException {
                String tmpDirStr = System.getProperty("java.io.tmpdir");
                if (tmpDirStr == null) {
                    throw new NullPointerException("java.io.tmpdir property is null");
                }
                File tmpDir = new File(tmpDirStr);
                File libFile = new File(tmpDir, libName);
                return this.copyResource(libURL, libFile);
            }

            private File url2file(URL url, String fileName) {
                if ("file".equals(url.getProtocol())) {
                    try {
                        File path = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
                        return path;
                    }
                    catch (UnsupportedEncodingException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                } else if ("jar".equals(url.getProtocol())) {
                    try {
                        File libFile = this.extractLib(url, fileName);
                        return libFile;
                    }
                    catch (FileNotFoundException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                    catch (IOException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                } else {
                    System.err.println("Unsupported URL protocol '" + url + "' for FastLZ native library file '" + fileName);
                }
                return null;
            }

            @Override
            public void run() {
                block13: {
                    try {
                        final ArrayList sources = new ArrayList();
                        final ArrayList<TransferableGraph1> dependencies = new ArrayList<TransferableGraph1>();
                        Bundle[] bundleArray = Activator.getContext().getBundles();
                        int n = bundleArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Bundle b = bundleArray[n2];
                            URL tg = b.getEntry("/graph.tg");
                            if (tg != null) {
                                Iterator f = this.url2file(FileLocator.resolve((URL)tg), b.getSymbolicName());
                                dependencies.add(GraphCompiler.read((File)((Object)f)));
                            }
                            ++n2;
                        }
                        TransferableGraph1 thisOntology = (TransferableGraph1)Simantics.sync((ReadInterface)new UniqueRead<TransferableGraph1>(){

                            public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
                                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                final Resource parent = graph.getSingleObject(r, L0.PartOf);
                                DefaultCopyHandler ch = new DefaultCopyHandler(r){

                                    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
                                        HashMap<Resource, SubgraphExtent.ExtentStatus> preStatus = new HashMap<Resource, SubgraphExtent.ExtentStatus>();
                                        preStatus.put(r, SubgraphExtent.ExtentStatus.EXTERNAL);
                                        if (!parent.equals(graph.getRootLibrary())) {
                                            preStatus.put(parent, SubgraphExtent.ExtentStatus.EXTERNAL);
                                        }
                                        return new TransferableGraphConfiguration2(null, Collections.emptyList(), preStatus, true, true);
                                    }

                                    protected TransferableGraphSource computeSource(ReadGraph graph, TransferableGraphConfiguration2 conf) throws DatabaseException {
                                        return (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf){

                                            protected ModelTransferableGraphSource getSource(ReadGraph graph, TransferableGraphConfiguration2 configuration, DomainProcessorState state, File otherStatementsFile, File valueFile) throws DatabaseException {
                                                return new ModelTransferableGraphSource(graph, configuration, state, new File[]{otherStatementsFile, valueFile}){

                                                    protected Identity getRootIdentity(DomainProcessorState state, SerialisationSupport support, Resource rootLibrary) throws DatabaseException {
                                                        return new Identity(state.ids.get(support.getTransientId(rootLibrary)), (IdentityDefinition)new Root("", ""));
                                                    }
                                                };
                                            }
                                        });
                                    }
                                };
                                SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
                                ch.copyToClipboard(graph, (SimanticsClipboardBuilder)clipboard);
                                for (Set object : clipboard.getContents()) {
                                    TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, (Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                                    if (tg == null) continue;
                                    return tg;
                                }
                                return null;
                            }
                        });
                        dependencies.add(thisOntology);
                        Simantics.sync((ReadInterface)new ReadRequest(){

                            public void run(ReadGraph graph) throws DatabaseException {
                                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                for (Resource file : (Collection)graph.syncRequest((Read)new ObjectsWithType(r, L0.ConsistsOf, L0.PGraph))) {
                                    final String src = (String)graph.getRelatedValue(file, L0.PGraph_definition, (Binding)Bindings.STRING);
                                    final ByteArrayInputStream baos = new ByteArrayInputStream(src.getBytes());
                                    sources.add(new ISource(){

                                        public int startPos() {
                                            return 0;
                                        }

                                        public int startLine() {
                                            return 0;
                                        }

                                        public InputStream open() throws IOException {
                                            return baos;
                                        }

                                        public int length() throws IOException {
                                            return src.length();
                                        }

                                        public String getName() {
                                            return "Source";
                                        }
                                    });
                                }
                            }
                        });
                        StringBuilder errorStringBuilder = new StringBuilder();
                        final GraphCompilerPreferences prefs = new GraphCompilerPreferences();
                        prefs.validate = true;
                        prefs.validateRelationRestrictions = ValidationMode.ERROR;
                        prefs.validateResourceHasType = ValidationMode.IGNORE;
                        final CompilationResult result = (CompilationResult)Simantics.sync((ReadInterface)new UniqueRead<CompilationResult>(){

                            public CompilationResult perform(final ReadGraph graph) throws DatabaseException {
                                Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(r));
                                final String baseURI = graph.getURI(root);
                                ExternalFileLoader fileLoader = new ExternalFileLoader(){

                                    public byte[] load(String fileName) throws IOException {
                                        try {
                                            GraphFileResource GF = GraphFileResource.getInstance((ReadGraph)graph);
                                            Resource file = graph.getResource(String.valueOf(baseURI) + "/" + fileName);
                                            return (byte[])graph.getRelatedValue(file, GF.HasFiledata, (Binding)Bindings.BYTE_ARRAY);
                                        }
                                        catch (DatabaseException e) {
                                            throw new IOException(e);
                                        }
                                    }
                                };
                                return GraphCompiler.compile((String)"1.1", (Collection)sources, (Collection)dependencies, (ExternalFileLoader)fileLoader, (GraphCompilerPreferences)prefs);
                            }
                        });
                        for (Problem problem : result.getErrors()) {
                            errorStringBuilder.append(problem.getLocation() + ": " + problem.getDescription() + "\n");
                        }
                        for (Problem problem : result.getWarnings()) {
                            errorStringBuilder.append(problem.getLocation() + ": " + problem.getDescription() + "\n");
                        }
                        if (!result.getErrors().isEmpty() || !result.getWarnings().isEmpty()) {
                            class ErrorMessageDialog
                            extends MessageDialog {
                                private final /* synthetic */ CompilationResult val$result;

                                public ErrorMessageDialog(Shell shell, CompilationResult compilationResult) {
                                    this.val$result = compilationResult;
                                    super(shell, "Unsatisfied dependencies", null, "The following dependencies were missing. Please import the dependencies and try again.", 1, new String[]{"Continue"}, 0);
                                }

                                protected Control createCustomArea(Composite composite) {
                                    GridLayoutFactory.fillDefaults().applyTo(composite);
                                    List list = new List(composite, 2056);
                                    GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)list);
                                    for (Problem problem : this.val$result.getErrors()) {
                                        list.add(problem.getLocation() + ": " + problem.getDescription() + "\n");
                                    }
                                    for (Problem problem : this.val$result.getWarnings()) {
                                        list.add(problem.getLocation() + ": " + problem.getDescription() + "\n");
                                    }
                                    return composite;
                                }
                            }
                            ErrorMessageDialog md = new ErrorMessageDialog(Display.getCurrent().getActiveShell(), result);
                            md.open();
                            return;
                        }
                        final Pair existing = (Pair)Simantics.sync((ReadInterface)new UniqueRead<Pair<TransferableGraph1, long[]>>(){

                            public Pair<TransferableGraph1, long[]> perform(ReadGraph graph) throws DatabaseException {
                                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                TransferableGraph1 tg = (TransferableGraph1)graph.getPossibleRelatedValue(r, L0.SharedOntology_tg, Bindings.getBindingUnchecked(TransferableGraph1.class));
                                if (tg == null) {
                                    return null;
                                }
                                long[] tgResources = (long[])graph.getPossibleRelatedValue(r, L0.SharedOntology_tgResources, (Binding)Bindings.LONG_ARRAY);
                                if (tgResources == null) {
                                    return null;
                                }
                                return Pair.make((Object)tg, (Object)tgResources);
                            }
                        });
                        if (existing != null) {
                            try {
                                try {
                                    Simantics.sync((WriteInterface)new WriteRequest(){

                                        public void perform(WriteGraph graph) throws DatabaseException {
                                            TransferableGraphDelta1 delta = new Diff((TransferableGraph1)existing.first, result.getGraph()).diff();
                                            long[] resourceArray = TransferableGraphs.applyDelta((WriteGraph)graph, (long[])((long[])existing.second), (TransferableGraphDelta1)delta);
                                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                            graph.claimLiteral(r, L0.SharedOntology_tg, (Object)result.getGraph(), Bindings.getBindingUnchecked(TransferableGraph1.class));
                                            graph.claimLiteral(r, L0.SharedOntology_tgResources, L0.ResourceIdArray, (Object)resourceArray, (Binding)Bindings.LONG_ARRAY);
                                            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Compiled ontology " + graph.getURI(r)));
                                        }
                                    });
                                    break block13;
                                }
                                catch (Throwable t) {
                                    throw new PlatformException(t);
                                }
                            }
                            finally {
                                Transaction.endTransaction();
                            }
                        }
                        final DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(r);
                        DefaultPasteHandler.defaultExecute((TransferableGraph1)result.getGraph(), (Resource)r, (IImportAdvisor)advisor);
                        Simantics.sync((WriteInterface)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                graph.claimLiteral(r, L0.SharedOntology_tg, (Object)result.getGraph(), Bindings.getBindingUnchecked(TransferableGraph1.class));
                                graph.claimLiteral(r, L0.SharedOntology_tgResources, L0.ResourceIdArray, (Object)advisor.getResourceIds(), (Binding)Bindings.LONG_ARRAY);
                                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Compiled ontology " + graph.getURI(r)));
                            }
                        });
                    }
                    catch (Exception e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            }
        };
    }
}

