/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.sysdyn.manager.GameResult;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.utils.logging.TimeLogger;

class SimulateDurationJob
extends Job {
    private boolean canceled = false;
    private double duration;
    private final SysdynGameExperimentBase base;
    private final ISolver solver;
    private final boolean asJob;

    public SimulateDurationJob(SysdynGameExperimentBase base, String name, double duration, boolean asJob) {
        super(name);
        this.base = base;
        this.solver = base.getSolver();
        this.duration = duration;
        this.asJob = asJob;
    }

    protected void canceling() {
        this.canceled = true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.base == null || this.base.getState() != ExperimentState.STOPPED) {
            return Status.OK_STATUS;
        }
        TimeLogger.resetTime();
        if (this.asJob) {
            this.base.changeState(ExperimentState.RUNNING);
        }
        int nSteps = (int)(this.duration / this.base.stepLength);
        int work = 1 + nSteps * 3 + 2;
        monitor.beginTask("Simulating " + this.duration + " time steps", work);
        monitor.subTask("Initialize step simulation");
        if (this.base.subscription == null || this.base.results == null) {
            return Status.OK_STATUS;
        }
        if (this.duration <= 0.0 && this.duration > -1.0) {
            this.duration = this.base.stepDuration;
        }
        try {
            this.solver.prepareToStep();
            double time = this.solver.getTime();
            double eTime = time + this.duration;
            monitor.worked(1);
            this.base.setSubscribedResults(monitor, time);
            int stepNumber = 1;
            while (eTime - time > this.base.stepLength * 1.0E-6 && !this.canceled) {
                if (eTime - time < this.base.stepLength) {
                    this.solver.setStepLength(eTime - time);
                }
                monitor.subTask("Simulate step (time = " + time + ")");
                this.solver.simulateStep();
                monitor.worked(1);
                time = this.solver.getTime();
                if (stepNumber % this.base.savePer == 0) {
                    this.base.setSubscribedResults(monitor, time);
                } else {
                    monitor.worked(1);
                }
                ++stepNumber;
                monitor.worked(1);
            }
            this.solver.setStepLength(this.base.stepLength);
            monitor.subTask("Display results");
            ((MemoryResult)this.base.getCurrentResult()).setResult(new GameResult(this.base, this.base.results, this.base.subscription));
            monitor.worked(1);
            this.base.resultsChanged(true);
            monitor.worked(1);
            if (this.asJob) {
                this.base.changeState(ExperimentState.STOPPED);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("SysdynGameExperiment simulateDuration failed: \n\t" + e.getMessage());
        }
        TimeLogger.log((String)"SimulateDuration");
        return Status.OK_STATUS;
    }
}

