/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.concurrent.Semaphore;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.NamespaceIndex;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.StringQuery;
import org.simantics.db.procedure.ListenerBase;

public class URIToResource
extends StringQuery<InternalProcedure<Integer>> {
    private URIToResource(String id) {
        super(id);
    }

    static final URIToResource entry(QueryProcessor provider, String id) {
        return (URIToResource)provider.uriToResourceMap.get((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, String id, CacheEntry parent, ListenerBase listener, InternalProcedure<Integer> procedure) {
        QueryProcessor processor = graph.processor;
        URIToResource entry = (URIToResource)processor.uriToResourceMap.get((Object)id);
        if (entry == null) {
            entry = new URIToResource(id);
            entry.setPending();
            entry.clearResult(processor.querySupport);
            entry.putEntry(processor);
            processor.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (entry.isPending()) {
                URIToResource uRIToResource = entry;
                synchronized (uRIToResource) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            processor.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, String id, CacheEntry parent, ListenerBase listener, InternalProcedure<Integer> procedure) {
        assert (id != null);
        if (graph.parent == null && listener == null) {
            URIToResource.computeForEach(graph, id, null, procedure);
        } else {
            URIToResource.runner(graph, id, parent, listener, procedure);
        }
    }

    public URIToResource getEntry(QueryProcessor provider) {
        return (URIToResource)provider.uriToResourceMap.get((Object)this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.uriToResourceMap.put((Object)this.id, (Object)this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.uriToResourceMap.remove((Object)this.id);
    }

    private void lookup(ReadGraphImpl graph, final QueryProcessor processor, final InternalProcedure<Integer> procedure, String namespace, final String name) {
        NamespaceIndex.queryEach(graph, namespace, processor, this, null, new InternalProcedure<TObjectIntHashMap<String>>(){

            @Override
            public void execute(ReadGraphImpl graph, TObjectIntHashMap<String> index) {
                int result;
                if (index != null && (result = index.get((Object)name)) != 0) {
                    URIToResource.this.addOrSet(graph, processor, result);
                    procedure.execute(graph, result);
                    return;
                }
                URIToResource.this.addOrSet(graph, processor, new Integer(0));
                procedure.execute(graph, new Integer(0));
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                URIToResource.this.except(t);
                procedure.exception(graph, t);
            }
        });
    }

    private static void lookup(ReadGraphImpl graph, final URIToResource entry, final InternalProcedure<Integer> procedure, String namespace, final String name) {
        NamespaceIndex.queryEach(graph, namespace, graph.processor, entry, null, new InternalProcedure<TObjectIntHashMap<String>>(){

            @Override
            public void execute(ReadGraphImpl graph, TObjectIntHashMap<String> index) {
                int result;
                if (index != null && (result = index.get((Object)name)) != 0) {
                    if (entry != null) {
                        entry.addOrSet(graph, graph.processor, result);
                    }
                    procedure.execute(graph, result);
                    return;
                }
                if (entry != null) {
                    entry.addOrSet(graph, graph.processor, new Integer(0));
                }
                procedure.execute(graph, new Integer(0));
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                if (entry != null) {
                    entry.except(t);
                }
                procedure.exception(graph, t);
            }
        });
    }

    @Override
    public void computeForEach(ReadGraphImpl graph, QueryProcessor processor, InternalProcedure<Integer> procedure) {
        if ("http://".equals(this.id) || "http:/".equals(this.id)) {
            this.addOrSet(graph, processor, processor.getRootLibrary());
            procedure.execute(graph, processor.getRootLibrary());
        } else {
            String[] parts = URIStringUtils.splitURI((String)this.id);
            if (parts != null) {
                this.lookup(graph, processor, procedure, parts[0], parts[1]);
            } else {
                this.lookup(graph, processor, procedure, "http://", this.id.replaceFirst("http://", ""));
            }
        }
    }

    private static final void computeForEach(ReadGraphImpl graph, String id, URIToResource entry, InternalProcedure<Integer> procedure) {
        if ("http://".equals(id) || "http:/".equals(id)) {
            QueryProcessor processor = graph.processor;
            if (entry != null) {
                entry.addOrSet(graph, processor, processor.getRootLibrary());
            }
            procedure.execute(graph, processor.getRootLibrary());
        } else {
            String[] parts = URIStringUtils.splitURI((String)id);
            if (parts != null) {
                URIToResource.lookup(graph, entry, procedure, parts[0], parts[1]);
            } else {
                URIToResource.lookup(graph, entry, procedure, "http://", id.replaceFirst("http://", ""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrSet(ReadGraphImpl graph, QueryProcessor provider, Integer result) {
        assert (this.isPending());
        URIToResource uRIToResource = this;
        synchronized (uRIToResource) {
            this.setResult(result);
            this.setReady();
        }
    }

    public String toString() {
        return "URIToResource[" + this.id + "]";
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<Integer> procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return;
        }
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.statusOrException);
        } else {
            procedure.execute(graph, (Integer)this.getResult());
        }
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new InternalProcedure<Integer>(){

            @Override
            public void execute(ReadGraphImpl graph, Integer result) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute.", t);
            }
        });
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }
}

