/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.debug.ListenerReport;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoInverseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.MultiIntProcedure;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.ReadGraphSupport;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.procedure.TripleIntProcedureAdapter;
import org.simantics.db.impl.query.AssertedStatements;
import org.simantics.db.impl.query.AsyncMultiReadEntry;
import org.simantics.db.impl.query.AsyncReadEntry;
import org.simantics.db.impl.query.BinaryQuery;
import org.simantics.db.impl.query.BinaryQueryHashMap;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.DirectStatements;
import org.simantics.db.impl.query.DirectSuperRelations;
import org.simantics.db.impl.query.DoubleKeyQueryHashMap;
import org.simantics.db.impl.query.ExternalReadEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.ListenerEntry;
import org.simantics.db.impl.query.MultiReadEntry;
import org.simantics.db.impl.query.NamespaceIndex;
import org.simantics.db.impl.query.ObjectUpdateSet;
import org.simantics.db.impl.query.Objects;
import org.simantics.db.impl.query.OrderedSet;
import org.simantics.db.impl.query.PossibleSuperRelation;
import org.simantics.db.impl.query.Predicates;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryCollectorImpl;
import org.simantics.db.impl.query.QueryCollectorImpl2;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.QueryThread;
import org.simantics.db.impl.query.ReadEntry;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.StableHashMap;
import org.simantics.db.impl.query.Statements;
import org.simantics.db.impl.query.StringQuery;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.impl.query.Types;
import org.simantics.db.impl.query.URIToResource;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.impl.query.UnaryQueryHashMap;
import org.simantics.db.impl.query.ValueQuery;
import org.simantics.db.impl.query.ValueUpdateSet;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procedure.AsyncMultiListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.AsyncSetListener;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.MultiProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.StatementProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteTraits;
import org.simantics.layer0.Layer0;
import org.simantics.utils.DataContainer;
import org.simantics.utils.Development;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;

public final class QueryProcessor
extends AbstractDisposable
implements ReadGraphSupport {
    public final UnaryQueryHashMap<IntProcedure> directPredicatesMap;
    public final UnaryQueryHashMap<IntProcedure> principalTypesMap;
    public final THashMap<String, URIToResource> uriToResourceMap;
    public final THashMap<String, NamespaceIndex> namespaceIndexMap22;
    public final UnaryQueryHashMap<IntProcedure> projectsMap;
    public final UnaryQueryHashMap<InternalProcedure<RelationInfo>> relationInfoMap;
    public final UnaryQueryHashMap<InternalProcedure<IntSet>> superTypesMap;
    public final UnaryQueryHashMap<InternalProcedure<IntSet>> typeHierarchyMap;
    public final UnaryQueryHashMap<InternalProcedure<IntSet>> superRelationsMap;
    public final UnaryQueryHashMap<InternalProcedure<IntSet>> typesMap;
    public final UnaryQueryHashMap<InternalProcedure<byte[]>> valueMap;
    public final DoubleKeyQueryHashMap<IntProcedure> directObjectsMap;
    public final DoubleKeyQueryHashMap<IntProcedure> objectsMap;
    public final UnaryQueryHashMap<IntProcedure> orderedSetMap;
    public final UnaryQueryHashMap<IntProcedure> predicatesMap;
    public final DoubleKeyQueryHashMap<TripleIntProcedure> statementsMap;
    public final UnaryQueryHashMap<IntProcedure> assertedPredicatesMap;
    public final BinaryQueryHashMap<TripleIntProcedure> assertedStatementsMap;
    public final StableHashMap<ExternalRead, ExternalReadEntry> externalReadMap;
    public final StableHashMap<AsyncRead, AsyncReadEntry> asyncReadMap;
    public final StableHashMap<Read, ReadEntry> readMap;
    public final StableHashMap<AsyncMultiRead, AsyncMultiReadEntry> asyncMultiReadMap;
    public final StableHashMap<MultiRead, MultiReadEntry> multiReadMap;
    private final THashMap<CacheEntry, ArrayList<ListenerEntry>> listeners;
    public static int indent = 0;
    public int size = 0;
    public int boundQueries = 0;
    private int hits = 0;
    private int misses = 0;
    private int updates = 0;
    private final int functionalRelation;
    private final int superrelationOf;
    private final int instanceOf;
    private final int inverseOf;
    private final int asserts;
    private final int hasPredicate;
    private final int hasPredicateInverse;
    private final int hasObject;
    private final int inherits;
    private final int subrelationOf;
    private final int rootLibrary;
    private volatile ResourceImpl rootLibraryResource;
    private final int library;
    private final int consistsOf;
    private final int hasName;
    AtomicInteger sleepers = new AtomicInteger(0);
    private boolean updating = false;
    public static boolean collecting = false;
    private boolean firingListeners = false;
    public final QuerySupport querySupport;
    public final Session session;
    public final ResourceSupport resourceSupport;
    private THashSet<ListenerEntry> scheduledListeners = new THashSet();
    QueryThread[] executors;
    public ArrayList<SessionTask>[] queues;
    public ThreadState[] threadStates;
    public ReentrantLock[] threadLocks;
    public Condition[] threadConditions;
    public ArrayList<SessionTask>[] ownTasks;
    public ArrayList<SessionTask>[] ownSyncTasks;
    ArrayList<SessionTask>[] delayQueues;
    public boolean synch = true;
    final Object querySupportLock;
    public Long modificationCounter = 0L;
    final int THREADS;
    public final int THREAD_MASK;
    public static final ThreadGroup QueryThreadGroup = new ThreadGroup("Query Thread Group");
    long waitingTime = 0L;
    static int koss = 0;
    static int koss2 = 0;
    private static final Dummy dummy = new Dummy();
    private QueryCollectorSupport collectorSupport = new QueryCollectorSupportImpl();
    private QueryCollector collector = new QueryCollectorImpl(this, this.collectorSupport);
    public volatile boolean dirty = false;
    private ObjectUpdateSet scheduledObjectUpdates = new ObjectUpdateSet();
    private ValueUpdateSet scheduledValueUpdates = new ValueUpdateSet();
    private ValueUpdateSet scheduledInvalidates = new ValueUpdateSet();
    private Object primitiveUpdateLock = new Object();
    private THashSet scheduledPrimitiveUpdates = new THashSet();
    private int lastInvalidate = 0;
    private HashMap<Resource, Class<?>> builtinValues;
    Exception callerException = null;
    private static final Resource INVALID_RESOURCE = new ResourceImpl(null, Integer.MIN_VALUE);
    private Layer0 L0;

    public void close() {
    }

    public final void scheduleOwn(int caller, SessionTask request) {
        this.ownTasks[caller].add(request);
    }

    public final void scheduleAlways(int caller, SessionTask request) {
        int performer = request.thread;
        if (caller == performer) {
            this.ownTasks[caller].add(request);
        } else {
            this.schedule(caller, request);
        }
    }

    public final void schedule(int caller, SessionTask request) {
        int performer = request.thread;
        assert (performer >= 0);
        assert (request != null);
        if (caller == performer) {
            request.run(caller);
        } else {
            ReentrantLock queueLock = this.threadLocks[performer];
            queueLock.lock();
            this.queues[performer].add(request);
            if (this.queues[performer].size() == 1) {
                if (ThreadState.SLEEP == this.threadStates[performer]) {
                    this.sleepers.decrementAndGet();
                }
                this.threadConditions[performer].signalAll();
            }
            queueLock.unlock();
        }
    }

    public boolean resume(ReadGraphImpl graph) {
        return this.executors[0].runSynchronized();
    }

    public QueryProcessor(int threads, QuerySupport core, Set<Thread> threadSet) throws DatabaseException {
        boolean builtinsInstalled;
        this.THREADS = threads;
        this.THREAD_MASK = threads - 1;
        this.querySupport = core;
        this.session = this.querySupport.getSession();
        this.resourceSupport = this.querySupport.getSupport();
        this.querySupportLock = core.getLock();
        this.executors = new QueryThread[this.THREADS];
        this.queues = new ArrayList[this.THREADS];
        this.threadLocks = new ReentrantLock[this.THREADS];
        this.threadConditions = new Condition[this.THREADS];
        this.threadStates = new ThreadState[this.THREADS];
        this.ownTasks = new ArrayList[this.THREADS];
        this.ownSyncTasks = new ArrayList[this.THREADS];
        this.delayQueues = new ArrayList[this.THREADS * this.THREADS];
        int i = 0;
        while (i < this.THREADS * this.THREADS) {
            this.delayQueues[i] = new ArrayList();
            ++i;
        }
        i = 0;
        while (i < this.THREADS) {
            this.ownTasks[i] = new ArrayList();
            this.ownSyncTasks[i] = new ArrayList();
            this.queues[i] = new ArrayList();
            this.threadLocks[i] = new ReentrantLock();
            this.threadConditions[i] = this.threadLocks[i].newCondition();
            this.threadStates[i] = ThreadState.INIT;
            ++i;
        }
        i = 0;
        while (i < this.THREADS) {
            int index = i;
            this.executors[i] = new QueryThread(this.session, this, index, "Query Thread " + index);
            threadSet.add(this.executors[i]);
            ++i;
        }
        this.directPredicatesMap = new UnaryQueryHashMap();
        this.valueMap = new UnaryQueryHashMap();
        this.principalTypesMap = new UnaryQueryHashMap();
        this.uriToResourceMap = new THashMap();
        this.namespaceIndexMap22 = new THashMap();
        this.projectsMap = new UnaryQueryHashMap();
        this.relationInfoMap = new UnaryQueryHashMap();
        this.typeHierarchyMap = new UnaryQueryHashMap();
        this.superTypesMap = new UnaryQueryHashMap();
        this.superRelationsMap = new UnaryQueryHashMap();
        this.typesMap = new UnaryQueryHashMap();
        this.objectsMap = new DoubleKeyQueryHashMap();
        this.orderedSetMap = new UnaryQueryHashMap();
        this.predicatesMap = new UnaryQueryHashMap();
        this.statementsMap = new DoubleKeyQueryHashMap();
        this.directObjectsMap = new DoubleKeyQueryHashMap();
        this.assertedPredicatesMap = new UnaryQueryHashMap();
        this.assertedStatementsMap = new BinaryQueryHashMap();
        this.asyncReadMap = new StableHashMap();
        this.readMap = new StableHashMap();
        this.asyncMultiReadMap = new StableHashMap();
        this.multiReadMap = new StableHashMap();
        this.externalReadMap = new StableHashMap();
        this.listeners = new THashMap(10, 0.75f);
        i = 0;
        while (i < this.THREADS) {
            this.executors[i].start();
            ++i;
        }
        while (this.sleepers.get() != this.THREADS) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.rootLibrary = core.getBuiltin("http:/");
        boolean bl = builtinsInstalled = this.rootLibrary != 0;
        if (builtinsInstalled) {
            this.functionalRelation = core.getBuiltin("http://www.simantics.org/Layer0-1.1/FunctionalRelation");
            assert (this.functionalRelation != 0);
        } else {
            this.functionalRelation = 0;
        }
        if (builtinsInstalled) {
            this.instanceOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/InstanceOf");
            assert (this.instanceOf != 0);
        } else {
            this.instanceOf = 0;
        }
        if (builtinsInstalled) {
            this.inverseOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/InverseOf");
            assert (this.inverseOf != 0);
        } else {
            this.inverseOf = 0;
        }
        if (builtinsInstalled) {
            this.inherits = core.getBuiltin("http://www.simantics.org/Layer0-1.1/Inherits");
            assert (this.inherits != 0);
        } else {
            this.inherits = 0;
        }
        if (builtinsInstalled) {
            this.asserts = core.getBuiltin("http://www.simantics.org/Layer0-1.1/Asserts");
            assert (this.asserts != 0);
        } else {
            this.asserts = 0;
        }
        if (builtinsInstalled) {
            this.hasPredicate = core.getBuiltin("http://www.simantics.org/Layer0-1.1/HasPredicate");
            assert (this.hasPredicate != 0);
        } else {
            this.hasPredicate = 0;
        }
        if (builtinsInstalled) {
            this.hasPredicateInverse = core.getBuiltin("http://www.simantics.org/Layer0-1.1/HasPredicateInverse");
            assert (this.hasPredicateInverse != 0);
        } else {
            this.hasPredicateInverse = 0;
        }
        if (builtinsInstalled) {
            this.hasObject = core.getBuiltin("http://www.simantics.org/Layer0-1.1/HasObject");
            assert (this.hasObject != 0);
        } else {
            this.hasObject = 0;
        }
        if (builtinsInstalled) {
            this.subrelationOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/SubrelationOf");
            assert (this.subrelationOf != 0);
        } else {
            this.subrelationOf = 0;
        }
        if (builtinsInstalled) {
            this.superrelationOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/SuperrelationOf");
            assert (this.superrelationOf != 0);
        } else {
            this.superrelationOf = 0;
        }
        if (builtinsInstalled) {
            this.library = core.getBuiltin("http://www.simantics.org/Layer0-1.1/Library");
            assert (this.library != 0);
        } else {
            this.library = 0;
        }
        if (builtinsInstalled) {
            this.consistsOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/ConsistsOf");
            assert (this.consistsOf != 0);
        } else {
            this.consistsOf = 0;
        }
        if (builtinsInstalled) {
            this.hasName = core.getBuiltin("http://www.simantics.org/Layer0-1.1/HasName");
            assert (this.hasName != 0);
        } else {
            this.hasName = 0;
        }
    }

    public final void releaseWrite(ReadGraphImpl graph) {
        this.performDirtyUpdates(graph);
        this.modificationCounter = this.modificationCounter + 1L;
    }

    public final int getId(Resource r) {
        return this.querySupport.getId(r);
    }

    public QuerySupport getCore() {
        return this.querySupport;
    }

    public int getFunctionalRelation() {
        return this.functionalRelation;
    }

    public int getInherits() {
        return this.inherits;
    }

    public int getInstanceOf() {
        return this.instanceOf;
    }

    public int getInverseOf() {
        return this.inverseOf;
    }

    public int getSubrelationOf() {
        return this.subrelationOf;
    }

    public int getSuperrelationOf() {
        return this.superrelationOf;
    }

    public int getAsserts() {
        return this.asserts;
    }

    public int getHasPredicate() {
        return this.hasPredicate;
    }

    public int getHasPredicateInverse() {
        return this.hasPredicateInverse;
    }

    public int getHasObject() {
        return this.hasObject;
    }

    public int getRootLibrary() {
        return this.rootLibrary;
    }

    public Resource getRootLibraryResource() {
        if (this.rootLibraryResource == null) {
            int root = this.getRootLibrary();
            if (root == 0) {
                throw new UnsupportedOperationException("database is not initialized, cannot get root library resource");
            }
            this.rootLibraryResource = new ResourceImpl(this.querySupport.getSupport(), root);
        }
        return this.rootLibraryResource;
    }

    public int getLibrary() {
        return this.library;
    }

    public int getConsistsOf() {
        return this.consistsOf;
    }

    public int getHasName() {
        return this.hasName;
    }

    public void forResource(ReadGraphImpl graph, final String id, CacheEntry parent, final InternalProcedure<Integer> procedure) {
        URIToResource.queryEach(graph, id, parent, null, new InternalProcedure<Integer>(){

            @Override
            public void execute(ReadGraphImpl graph, Integer result) {
                if (result != null && result != 0) {
                    procedure.execute(graph, result);
                    return;
                }
                result = QueryProcessor.this.querySupport.getBuiltin(id);
                if (result != 0) {
                    procedure.execute(graph, result);
                    return;
                }
                try {
                    result = QueryProcessor.this.querySupport.getRandomAccessReference(id);
                }
                catch (ResourceNotFoundException e) {
                    procedure.exception(graph, e);
                    return;
                }
                if (result != 0) {
                    procedure.execute(graph, result);
                } else {
                    procedure.exception(graph, new ResourceNotFoundException(id));
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                procedure.exception(graph, t);
            }
        });
    }

    public void forBuiltin(ReadGraphImpl graph, String id, CacheEntry parent, InternalProcedure<Integer> procedure) {
        Integer result = this.querySupport.getBuiltin(id);
        if (result != 0) {
            procedure.execute(graph, result);
        } else {
            procedure.exception(graph, new ResourceNotFoundException(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void runAsyncRead(ReadGraphImpl graph, AsyncRead<T> query, CacheEntry parent, ListenerBase listener, AsyncProcedure<T> procedure) {
        int hash = this.requestHash(query);
        AsyncReadEntry<T> entry = this.asyncReadMap.get(query, hash);
        if (parent == null && listener == null) {
            if (entry != null && (entry.isReady() || entry.isExcepted())) {
                System.out.println("ready " + query);
                entry.performFromCache(graph, this, procedure);
                return;
            }
            query.perform((AsyncReadGraph)graph, procedure);
            return;
        }
        if (entry == null) {
            entry = new AsyncReadEntry<T>(query);
            entry.setPending();
            entry.clearResult(this.querySupport);
            this.asyncReadMap.put(query, entry, hash);
            this.performForEach(graph, query, entry, parent, listener, procedure, false);
        } else {
            if (entry.isPending()) {
                AsyncReadEntry<T> asyncReadEntry = entry;
                synchronized (asyncReadEntry) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            if (entry.isReady()) {
                entry.performFromCache(graph, this, procedure);
                this.registerDependencies(graph, entry, parent, listener, procedure, false);
            } else {
                this.performForEach(graph, query, entry, parent, listener, procedure, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final <T> void runMultiRead(ReadGraphImpl graph, MultiReadEntry cached, MultiRead<T> query, CacheEntry parent, QueryProcessor provider, ListenerBase listener, AsyncMultiProcedure<T> procedure) {
        MultiReadEntry<T> entry;
        MultiReadEntry<T> multiReadEntry = entry = cached != null ? cached : provider.multiReadMap.get(query);
        if (entry == null) {
            entry = new MultiReadEntry<T>(query);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            provider.multiReadMap.put(query, entry);
            provider.performForEach(graph, query, entry, parent, listener, procedure, false);
        } else {
            if (entry.isPending()) {
                MultiReadEntry<T> multiReadEntry2 = entry;
                synchronized (multiReadEntry2) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
                entry.performFromCache(graph, (Object)provider, procedure);
                return;
            }
            provider.performForEach(graph, query, entry, parent, listener, procedure, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void runAsyncMultiRead(ReadGraphImpl graph, AsyncMultiRead<T> query, CacheEntry parent, ListenerBase listener, AsyncMultiProcedure<T> procedure) {
        int hash = this.requestHash(query);
        AsyncMultiReadEntry<T> entry = this.asyncMultiReadMap.get(query, hash);
        if (parent == null && listener == null) {
            if (entry != null && (entry.isReady() || entry.isExcepted())) {
                System.out.println("ready " + query);
                entry.performFromCache(graph, this, procedure);
                return;
            }
            query.perform((AsyncReadGraph)graph, procedure);
            return;
        }
        if (entry == null) {
            entry = new AsyncMultiReadEntry<T>(query);
            entry.setPending();
            entry.clearResult(this.querySupport);
            this.asyncMultiReadMap.put(query, entry, hash);
            this.performForEach(graph, query, entry, parent, listener, procedure, false);
        } else {
            if (entry.isPending()) {
                AsyncMultiReadEntry<T> asyncMultiReadEntry = entry;
                synchronized (asyncMultiReadEntry) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            this.performForEach(graph, query, entry, parent, listener, procedure, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final <T> void runPrimitiveRead(ReadGraphImpl graph, ExternalReadEntry cached, ExternalRead<T> query, CacheEntry parent, QueryProcessor provider, ListenerBase listener, Procedure<T> procedure) {
        ExternalReadEntry entry;
        ExternalReadEntry externalReadEntry = entry = cached != null ? cached : provider.externalReadMap.get(query);
        if (entry == null) {
            provider.performForEach(graph, query, new ExternalReadEntry<T>(query), parent, listener, procedure, false);
        } else {
            if (entry.isPending()) {
                ExternalReadEntry externalReadEntry2 = entry;
                synchronized (externalReadEntry2) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            provider.performForEach(graph, query, entry, parent, listener, procedure, false);
        }
    }

    public int requestHash(Object object) {
        try {
            return object.hashCode();
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
            return 0;
        }
    }

    @Override
    public <T> T queryRead(ReadGraphImpl graph, Read<T> query, CacheEntry parent, AsyncProcedure<T> procedure, ListenerBase listener) throws Throwable {
        assert (query != null);
        ReadEntry<T> entry = this.readMap.get(query);
        if (entry != null) {
            if (parent == null && (listener == null || listener.isDisposed()) && entry.isReady()) {
                return (T)entry.get(graph, this, procedure);
            }
            if (entry.isPending()) {
                throw new IllegalStateException();
            }
        }
        if (entry == null) {
            entry = new ReadEntry<T>(query);
            entry.setPending();
            entry.clearResult(this.querySupport);
            this.readMap.put(query, entry);
            return this.performForEach(graph, query, entry, parent, listener, procedure, false);
        }
        if (entry.isPending()) {
            throw new IllegalStateException();
        }
        return this.performForEach(graph, query, entry, parent, listener, procedure, false);
    }

    public <T> void queryMultiRead(ReadGraphImpl graph, MultiRead<T> query, CacheEntry parent, ListenerBase listener, AsyncMultiProcedure<T> procedure) {
        assert (query != null);
        assert (procedure != null);
        MultiReadEntry entry = this.multiReadMap.get(query);
        if (parent == null && listener == null && entry != null && entry.isReady()) {
            entry.performFromCache(graph, (Object)this, procedure);
            return;
        }
        QueryProcessor.runMultiRead(graph, entry, query, parent, this, listener, procedure);
    }

    public <T> void queryPrimitiveRead(ReadGraphImpl graph, ExternalRead<T> query, CacheEntry parent, ListenerBase listener, Procedure<T> procedure) {
        assert (query != null);
        assert (procedure != null);
        ExternalReadEntry entry = this.externalReadMap.get(query);
        if (parent == null && listener == null && entry != null && entry.isReady()) {
            entry.performFromCache(procedure);
            return;
        }
        QueryProcessor.runPrimitiveRead(graph, entry, query, parent, this, listener, procedure);
    }

    public <T> void performForEach(ReadGraphImpl parentGraph, AsyncRead<T> query, final AsyncReadEntry<T> entry, CacheEntry parent, ListenerBase base, final AsyncProcedure<T> procedure, boolean inferredDependency) {
        assert (!this.dirty);
        assert (!collecting);
        assert (!entry.isDiscarded());
        final ListenerEntry listenerEntry = this.registerDependencies(parentGraph, entry, parent, base, procedure, inferredDependency);
        if (!entry.isReady()) {
            entry.setPending();
            ++this.size;
            try {
                final ReadGraphImpl finalParentGraph = parentGraph;
                query.perform((AsyncReadGraph)parentGraph.withParent(entry), new AsyncProcedure<T>(){

                    public void execute(AsyncReadGraph returnGraph, T result) {
                        ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)returnGraph;
                        entry.addOrSet((AsyncReadGraph)finalParentGraph, result);
                        if (listenerEntry != null) {
                            QueryProcessor.this.primeListenerEntry(listenerEntry, result);
                        }
                        try {
                            procedure.execute((AsyncReadGraph)finalParentGraph, result);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }

                    public void exception(AsyncReadGraph returnGraph, Throwable t) {
                        ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)returnGraph;
                        entry.except((AsyncReadGraph)finalParentGraph, t);
                        try {
                            procedure.exception((AsyncReadGraph)finalParentGraph, t);
                        }
                        catch (Throwable t2) {
                            t2.printStackTrace();
                        }
                    }

                    public String toString() {
                        return procedure.toString();
                    }
                });
            }
            catch (Throwable t) {
                entry.except(t);
                try {
                    procedure.exception((AsyncReadGraph)parentGraph, t);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
            ++this.misses;
        } else {
            entry.performFromCache(parentGraph, this, new AsyncProcedure<T>(){

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    procedure.exception(graph, throwable);
                }

                public void execute(AsyncReadGraph graph, T result) {
                    procedure.execute(graph, result);
                    if (listenerEntry != null) {
                        QueryProcessor.this.primeListenerEntry(listenerEntry, result);
                    }
                }
            });
            ++this.hits;
        }
        assert (!entry.isDiscarded());
    }

    public <T> T performForEach(ReadGraphImpl graph, Read<T> query, ReadEntry<T> entry, CacheEntry parent, ListenerBase listener, AsyncProcedure<T> procedure, boolean inferredDependency) throws Throwable {
        assert (!this.dirty);
        assert (!collecting);
        entry.assertNotDiscarded();
        if (entry.isReady()) {
            ++this.hits;
            ListenerEntry listenerEntry = this.registerDependencies(graph, entry, parent, listener, procedure, inferredDependency);
            Object result = entry.get(graph, this, procedure);
            if (listenerEntry != null) {
                this.primeListenerEntry(listenerEntry, result);
            }
            return (T)result;
        }
        entry.setPending();
        ++this.size;
        ++this.misses;
        ListenerEntry listenerEntry = this.registerDependencies(graph, entry, parent, listener, procedure, inferredDependency);
        ReadGraphImpl performGraph = graph.newSync(entry);
        try {
            Object result = query.perform((ReadGraph)performGraph);
            entry.addOrSet((AsyncReadGraph)performGraph, result);
            if (listenerEntry != null) {
                this.primeListenerEntry(listenerEntry, result);
            }
            return (T)entry.get(graph, this, procedure);
        }
        catch (Throwable t) {
            entry.except(t);
            return (T)entry.get(graph, this, procedure);
        }
    }

    public <T> void performForEach(ReadGraphImpl graph, MultiRead<T> query, final MultiReadEntry<T> entry, CacheEntry parent, ListenerBase listener, final AsyncMultiProcedure<T> procedure, boolean inferredDependency) {
        assert (!this.dirty);
        assert (!collecting);
        assert (!entry.isPending());
        assert (!entry.isDiscarded());
        if (!entry.isReady()) {
            entry.setPending();
            entry.clearResult(this.querySupport);
            this.multiReadMap.put(query, entry);
            ++this.size;
            ReadGraphImpl newGraph = graph.newSync(entry);
            try {
                query.perform((ReadGraph)newGraph, new AsyncMultiProcedure<T>(){

                    public void execute(AsyncReadGraph graph, T result) {
                        entry.addOrSet(result);
                        try {
                            procedure.execute(graph, result);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }

                    public void finished(AsyncReadGraph graph) {
                        entry.finish(graph);
                        try {
                            procedure.finished(graph);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        entry.except(t);
                        try {
                            procedure.exception(graph, t);
                        }
                        catch (Throwable t2) {
                            t2.printStackTrace();
                        }
                    }
                });
            }
            catch (DatabaseException e) {
                entry.except(e);
                try {
                    procedure.exception((AsyncReadGraph)graph, (Throwable)e);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
            catch (Throwable t) {
                DatabaseException e = new DatabaseException(t);
                entry.except(e);
                try {
                    procedure.exception((AsyncReadGraph)graph, (Throwable)e);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
            ++this.misses;
        } else {
            entry.performFromCache(graph, (Object)this, procedure);
            ++this.hits;
        }
        assert (!entry.isDiscarded());
        this.registerDependencies(graph, entry, parent, listener, procedure, inferredDependency);
    }

    public <T> void performForEach(final ReadGraphImpl callerGraph, AsyncMultiRead<T> query, final AsyncMultiReadEntry<T> entry, CacheEntry parent, ListenerBase listener, final AsyncMultiProcedure<T> procedure, boolean inferredDependency) {
        assert (!this.dirty);
        assert (!collecting);
        try {
            assert (!entry.isDiscarded());
            if (!entry.isReady()) {
                ++this.size;
                try {
                    ReadGraphImpl performGraph = callerGraph.withAsyncParent(entry);
                    query.perform((AsyncReadGraph)performGraph, new AsyncMultiProcedure<T>(){

                        public void execute(AsyncReadGraph graph, T result) {
                            ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                            entry.addOrSet(result);
                            try {
                                procedure.execute((AsyncReadGraph)callerGraph, result);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }

                        public void finished(AsyncReadGraph graph) {
                            ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                            entry.finish((AsyncReadGraph)callerGraph);
                            try {
                                procedure.finished((AsyncReadGraph)callerGraph);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                            entry.except((AsyncReadGraph)callerGraph, t);
                            try {
                                procedure.exception((AsyncReadGraph)callerGraph, t);
                            }
                            catch (Throwable t2) {
                                t2.printStackTrace();
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    entry.except(t);
                    try {
                        procedure.exception((AsyncReadGraph)callerGraph, t);
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                    }
                }
                ++this.misses;
            } else {
                entry.performFromCache(callerGraph, this, procedure);
                ++this.hits;
            }
            assert (!entry.isDiscarded());
            this.registerDependencies(callerGraph, entry, parent, listener, procedure, inferredDependency);
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
        }
    }

    public <T> void performForEach(ReadGraphImpl graph, final ExternalRead<T> query, final ExternalReadEntry<T> entry, CacheEntry parent, ListenerBase base, final Procedure<T> procedure, boolean inferredDependency) {
        assert (!this.dirty);
        assert (!collecting);
        assert (!entry.isPending());
        assert (!entry.isDiscarded());
        this.registerDependencies(graph, entry, parent, base, procedure, inferredDependency);
        if (!entry.isReady()) {
            entry.setPending();
            entry.clearResult(this.querySupport);
            this.externalReadMap.put(query, entry);
            ++this.size;
            try {
                query.register((ReadGraph)graph, new Listener<T>(){
                    AtomicBoolean used = new AtomicBoolean(false);

                    public void execute(T result) {
                        if (entry.isDiscarded()) {
                            return;
                        }
                        if (entry.isExcepted()) {
                            entry.setPending();
                        }
                        if (this.used.compareAndSet(false, true)) {
                            entry.addOrSet(QueryProcessor.this, result);
                            procedure.execute(result);
                        } else {
                            entry.queue(result);
                            QueryProcessor.this.updatePrimitive(query);
                        }
                    }

                    public void exception(Throwable t) {
                        entry.except(t);
                        if (this.used.compareAndSet(false, true)) {
                            procedure.exception(t);
                        } else {
                            QueryProcessor.this.updatePrimitive(query);
                        }
                    }

                    public String toString() {
                        return procedure.toString();
                    }

                    public boolean isDisposed() {
                        return entry.isDiscarded() || !QueryProcessor.this.isBound(entry);
                    }
                });
            }
            catch (Throwable t) {
                entry.except(t);
                procedure.exception(t);
            }
            ++this.misses;
        } else {
            entry.performFromCache(procedure);
            ++this.hits;
        }
        assert (!entry.isDiscarded());
    }

    private boolean isBound(ExternalReadEntry<?> entry) {
        if (entry.hasParents()) {
            return true;
        }
        return this.hasListener(entry);
    }

    public synchronized ListenerEntry registerDependencies(ReadGraphImpl graph, CacheEntry child, CacheEntry parent, ListenerBase listener, Object procedure, boolean inferred) {
        if (parent != null && !inferred) {
            try {
                if (!child.isImmutable(graph)) {
                    child.addParent(parent);
                }
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }
        if (listener != null) {
            return this.registerListener(child, listener, procedure);
        }
        return null;
    }

    public <Procedure> void performForEach(ReadGraphImpl graph, BinaryQuery<Procedure> query, CacheEntry parent, ListenerBase listener, Procedure procedure) {
        assert (!this.dirty);
        assert (!collecting);
        try {
            this.registerDependencies(graph, query, parent, listener, procedure, false);
            if (!query.isReady()) {
                boolean fresh = query.isFresh();
                if (fresh) {
                    ++this.size;
                }
                query.computeForEach(graph, this, procedure, true);
                ++this.misses;
            } else {
                query.performFromCache(graph, this, procedure);
                ++this.hits;
            }
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
        }
    }

    public <Procedure> Object performForEach(ReadGraphImpl graph, UnaryQuery<Procedure> query, CacheEntry parent, ListenerBase listener, Procedure procedure) {
        assert (!this.dirty);
        assert (!collecting);
        try {
            assert (query.assertNotDiscarded());
            this.registerDependencies(graph, query, parent, listener, procedure, false);
            if (!query.isReady()) {
                ++this.size;
                ++this.misses;
                return query.computeForEach(graph, this, procedure, true);
            }
            ++this.hits;
            return query.performFromCache(graph, this, procedure);
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
            return null;
        }
    }

    public <Procedure> Object performForEach2(ReadGraphImpl graph, UnaryQuery<Procedure> query, CacheEntry parent, ListenerBase listener, Procedure procedure) throws Throwable {
        assert (!this.dirty);
        assert (!collecting);
        assert (query.assertNotDiscarded());
        this.registerDependencies(graph, query, parent, listener, procedure, false);
        if (!query.isReady()) {
            ++this.size;
            ++this.misses;
            query.computeForEach(graph, this, dummy, true);
            return query.get(graph, this, null);
        }
        ++this.hits;
        return query.get(graph, this, procedure);
    }

    public <Procedure> void performForEach(ReadGraphImpl graph, StringQuery<Procedure> query, CacheEntry parent, ListenerBase listener, Procedure procedure) {
        assert (!this.dirty);
        assert (!collecting);
        try {
            if (query.isDiscarded()) {
                System.err.println("aff");
            }
            assert (!query.isDiscarded());
            if (!query.isReady()) {
                query.computeForEach(graph.withAsyncParent(query), this, procedure);
                ++this.size;
                ++this.misses;
            } else {
                query.performFromCache(graph, this, procedure);
                ++this.hits;
            }
            assert (!query.isDiscarded());
            this.registerDependencies(graph, query, parent, listener, procedure, false);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Logger.defaultLogError((Throwable)t);
        }
    }

    public int querySize() {
        return this.size;
    }

    public void gc(int youngTarget, int allowedTimeInMs) {
        this.collector.collect(youngTarget, allowedTimeInMs);
    }

    public ListenerEntry registerListener(CacheEntry entry, ListenerBase base, Object procedure) {
        assert (entry != null);
        if (base.isDisposed()) {
            return null;
        }
        return this.addListener(entry, base, procedure);
    }

    private void primeListenerEntry(ListenerEntry entry, Object result) {
        entry.setLastKnown(result);
    }

    private ListenerEntry addListener(CacheEntry entry, ListenerBase base, Object procedure) {
        ListenerEntry result;
        int currentIndex;
        assert (entry != null);
        assert (procedure != null);
        ArrayList<ListenerEntry> list = (ArrayList<ListenerEntry>)this.listeners.get((Object)entry);
        if (list == null) {
            list = new ArrayList<ListenerEntry>(1);
            this.listeners.put((Object)entry, list);
        }
        if ((currentIndex = list.indexOf(result = new ListenerEntry(entry, base, procedure))) > -1) {
            ListenerEntry current = (ListenerEntry)list.get(currentIndex);
            if (!current.base.isDisposed()) {
                return null;
            }
            list.set(currentIndex, result);
        } else {
            list.add(result);
        }
        return result;
    }

    private void scheduleListener(ListenerEntry entry) {
        assert (entry != null);
        this.scheduledListeners.add((Object)entry);
    }

    private void removeListener(ListenerEntry entry) {
        assert (entry != null);
        ArrayList list = (ArrayList)this.listeners.get((Object)entry.entry);
        if (list == null) {
            return;
        }
        boolean success = list.remove(entry);
        assert (success);
        if (list.isEmpty()) {
            this.listeners.remove((Object)entry.entry);
        }
    }

    private boolean hasListener(CacheEntry entry) {
        return this.listeners.get((Object)entry) != null;
    }

    boolean hasListenerAfterDisposing(CacheEntry entry) {
        if (this.listeners.get((Object)entry) != null) {
            ArrayList entries = (ArrayList)this.listeners.get((Object)entry);
            ArrayList<ListenerEntry> list = null;
            for (ListenerEntry e : entries) {
                if (!e.base.isDisposed()) continue;
                if (list == null) {
                    list = new ArrayList<ListenerEntry>();
                }
                list.add(e);
            }
            if (list != null) {
                for (ListenerEntry e : list) {
                    entries.remove(e);
                }
            }
            if (entries.isEmpty()) {
                this.listeners.remove((Object)entry);
                return false;
            }
            return true;
        }
        return false;
    }

    List<ListenerEntry> getListenerEntries(CacheEntry entry) {
        this.hasListenerAfterDisposing(entry);
        if (this.listeners.get((Object)entry) != null) {
            return (List)this.listeners.get((Object)entry);
        }
        return Collections.emptyList();
    }

    void processListenerReport(CacheEntry entry, Map<CacheEntry, Set<ListenerBase>> workarea) {
        if (!workarea.containsKey(entry)) {
            HashSet<ListenerBase> ls = new HashSet<ListenerBase>();
            for (ListenerEntry e : this.getListenerEntries(entry)) {
                ls.add(e.base);
            }
            workarea.put(entry, ls);
            for (CacheEntry parent : entry.getParents(this)) {
                this.processListenerReport(parent, workarea);
                ls.addAll((Collection)workarea.get(parent));
            }
        }
    }

    public synchronized ListenerReport getListenerReport() throws IOException {
        class ListenerReportImpl
        implements ListenerReport {
            Map<CacheEntry, Set<ListenerBase>> workarea = new HashMap<CacheEntry, Set<ListenerBase>>();

            ListenerReportImpl() {
            }

            public void print(PrintStream b) {
                HashMap<ListenerBase, Integer> hist = new HashMap<ListenerBase, Integer>();
                for (Map.Entry<CacheEntry, Set<ListenerBase>> e : this.workarea.entrySet()) {
                    Iterator<ListenerBase> iterator = e.getValue().iterator();
                    while (iterator.hasNext()) {
                        ListenerBase l;
                        Integer i = (Integer)hist.get(l = iterator.next());
                        hist.put(l, i != null ? i - 1 : -1);
                    }
                }
                for (Pair p : CollectionUtils.valueSortedEntries(hist)) {
                    b.print(-((Integer)p.second).intValue() + " " + p.first + "\n");
                }
                b.flush();
            }
        }
        ListenerReportImpl result = new ListenerReportImpl();
        Collection<CacheEntryBase> all = this.allCaches(new CacheCollectionResult()).toCollection();
        for (CacheEntryBase entry : all) {
            this.hasListenerAfterDisposing(entry);
        }
        for (CacheEntryBase entry : all) {
            this.processListenerReport(entry, result.workarea);
        }
        return result;
    }

    public synchronized String reportListeners(File file) throws IOException {
        if (!this.isAlive()) {
            return "Disposed!";
        }
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        ListenerReport report = this.getListenerReport();
        report.print(b);
        return "Done reporting listeners.";
    }

    void processParentReport(CacheEntry entry, Map<CacheEntry, Set<CacheEntry>> workarea) {
        if (entry.isDiscarded()) {
            return;
        }
        if (workarea.containsKey(entry)) {
            return;
        }
        Iterable<CacheEntry> parents = entry.getParents(this);
        HashSet<CacheEntry> ps = new HashSet<CacheEntry>();
        for (CacheEntry e : parents) {
            if (e.isDiscarded()) continue;
            ps.add(e);
            this.processParentReport(e, workarea);
        }
        workarea.put(entry, ps);
    }

    public synchronized String reportQueryActivity(File file) throws IOException {
        System.err.println("reportQueries " + file.getAbsolutePath());
        if (!this.isAlive()) {
            return "Disposed!";
        }
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        List entries = CollectionUtils.valueSortedEntries((Map)Development.histogram);
        Collections.reverse(entries);
        for (Pair entry : entries) {
            b.println(String.valueOf((String)entry.first) + ": " + entry.second);
        }
        b.close();
        Development.histogram.clear();
        return "OK";
    }

    public synchronized String reportQueries(File file) throws IOException {
        System.err.println("reportQueries " + file.getAbsolutePath());
        if (!this.isAlive()) {
            return "Disposed!";
        }
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        long start = System.nanoTime();
        HashMap<CacheEntry, Set<CacheEntry>> workarea = new HashMap<CacheEntry, Set<CacheEntry>>();
        Collection<CacheEntryBase> caches = this.allCaches(new CacheCollectionResult()).toCollection();
        for (CacheEntryBase entry : caches) {
            this.processParentReport(entry, workarea);
        }
        long duration = System.nanoTime() - start;
        System.err.println("Query root set in " + 1.0E-9 * (double)duration + "s.");
        start = System.nanoTime();
        HashMap<CacheEntry, Integer> flagMap = new HashMap<CacheEntry, Integer>();
        int listeners = 0;
        for (CacheEntry entry : workarea.keySet()) {
            boolean listener = this.hasListenerAfterDisposing(entry);
            boolean hasParents = entry.getParents(this).iterator().hasNext();
            if (listener) {
                flagMap.put(entry, 0);
                continue;
            }
            if (!hasParents) {
                flagMap.put(entry, 1);
                continue;
            }
            flagMap.put(entry, 2);
        }
        boolean done = true;
        int loops = 0;
        do {
            done = true;
            long start2 = System.nanoTime();
            int boundCounter = 0;
            int unboundCounter = 0;
            int unknownCounter = 0;
            for (CacheEntry cacheEntry : workarea.keySet()) {
                int flags = (Integer)flagMap.get(cacheEntry);
                int bindStatus = flags & 3;
                if (bindStatus == 0) {
                    ++boundCounter;
                } else if (bindStatus == 1) {
                    ++unboundCounter;
                } else if (bindStatus == 2) {
                    ++unknownCounter;
                }
                if (bindStatus < 2) continue;
                int newStatus = 1;
                for (CacheEntry parent : cacheEntry.getParents(this)) {
                    int flags2;
                    int bindStatus2;
                    if (parent.isDiscarded()) {
                        flagMap.put(parent, 1);
                    }
                    if ((bindStatus2 = (flags2 = ((Integer)flagMap.get(parent)).intValue()) & 3) == 0) {
                        newStatus = 0;
                        break;
                    }
                    if (bindStatus2 != 2) continue;
                    newStatus = 2;
                    done = false;
                    break;
                }
                flagMap.put(cacheEntry, newStatus);
            }
            duration = System.nanoTime() - start2;
            System.err.println("Query analysis pass (" + boundCounter + "/" + unboundCounter + "/" + unknownCounter + ") in " + 1.0E-9 * (double)duration + "s.");
            b.println("Query analysis pass (" + boundCounter + "/" + unboundCounter + "/" + unknownCounter + ") in " + 1.0E-9 * (double)duration + "s.");
        } while (!done && loops++ < 20);
        if (loops >= 20) {
            for (CacheEntry entry : workarea.keySet()) {
                int bindStatus = (Integer)flagMap.get(entry);
                if (bindStatus != 2) continue;
                System.err.println("Undefined bind status for " + entry);
            }
        }
        duration = System.nanoTime() - start;
        System.err.println("Query analysis in " + 1.0E-9 * (double)duration + "s.");
        HashMap counts = new HashMap();
        for (CacheEntry entry : workarea.keySet()) {
            Class<?> clazz = entry.getClass();
            if (entry instanceof ReadEntry) {
                clazz = ((ReadEntry)entry).request.getClass();
            } else if (entry instanceof MultiReadEntry) {
                clazz = ((MultiReadEntry)entry).request.getClass();
            } else if (entry instanceof AsyncReadEntry) {
                clazz = ((AsyncReadEntry)entry).request.getClass();
            } else if (entry instanceof AsyncMultiReadEntry) {
                clazz = ((AsyncMultiReadEntry)entry).request.getClass();
            } else if (entry instanceof ExternalReadEntry) {
                clazz = ((ExternalReadEntry)entry).request.getClass();
            }
            Integer c = (Integer)counts.get(clazz);
            if (c == null) {
                counts.put(clazz, -1);
                continue;
            }
            counts.put(clazz, c - 1);
        }
        b.print("// Simantics DB client query report file\n");
        b.print("// This file contains the following information\n");
        b.print("// -The amount of cached query instances per query class\n");
        b.print("// -The sizes of retained child sets\n");
        b.print("// -List of parents for each query (search for 'P <query name>')\n");
        b.print("//  -Followed by status, where\n");
        b.print("//   -0=bound\n");
        b.print("//   -1=free\n");
        b.print("//   -2=unknown\n");
        b.print("//   -L=has listener\n");
        b.print("// -List of children for each query (search for 'C <query name>')\n");
        b.print("----------------------------------------\n");
        b.print("// Queries by class\n");
        for (Pair p : CollectionUtils.valueSortedEntries(counts)) {
            b.print(String.valueOf(-((Integer)p.second).intValue()) + " " + ((Class)p.first).getName() + "\n");
        }
        HashMap<CacheEntry, Integer> hist = new HashMap<CacheEntry, Integer>();
        for (CacheEntry e : workarea.keySet()) {
            hist.put(e, -1);
        }
        boolean changed = true;
        int iter = 0;
        while (changed && iter++ < 50) {
            changed = false;
            HashMap<CacheEntry, Integer> newHist = new HashMap<CacheEntry, Integer>();
            for (CacheEntry cacheEntry : workarea.keySet()) {
                newHist.put(cacheEntry, -1);
            }
            for (Map.Entry entry : workarea.entrySet()) {
                Integer c = (Integer)hist.get(entry.getKey());
                for (CacheEntry p : (Set)entry.getValue()) {
                    Integer i = (Integer)newHist.get(p);
                    newHist.put(p, i + c);
                }
            }
            for (CacheEntry cacheEntry : workarea.keySet()) {
                Integer old;
                Integer value = (Integer)newHist.get(cacheEntry);
                if (value.equals(old = (Integer)hist.get(cacheEntry))) continue;
                hist.put(cacheEntry, value);
                changed = true;
            }
            System.err.println("Retained set iteration " + iter);
        }
        b.print("// Queries by retained set\n");
        for (Pair p : CollectionUtils.valueSortedEntries(hist)) {
            b.print(-((Integer)p.second).intValue() + " " + p.first + "\n");
        }
        HashMap<CacheEntry, ArrayList<CacheEntry>> inverse = new HashMap<CacheEntry, ArrayList<CacheEntry>>();
        b.print("// Entry parent listing\n");
        for (CacheEntry cacheEntry : workarea.keySet()) {
            int status = (Integer)flagMap.get(cacheEntry);
            boolean hasListener = this.hasListenerAfterDisposing(cacheEntry);
            b.print("Q " + cacheEntry.toString());
            if (hasListener) {
                b.print(" (L" + status + ")");
                ++listeners;
            } else {
                b.print(" (" + status + ")");
            }
            b.print("\n");
            for (CacheEntry parent : (Set)workarea.get(cacheEntry)) {
                ArrayList<CacheEntry> inv = (ArrayList<CacheEntry>)inverse.get(parent);
                if (inv == null) {
                    inv = new ArrayList<CacheEntry>();
                    inverse.put(parent, inv);
                }
                inv.add(cacheEntry);
                b.print("  " + parent.toString());
                b.print("\n");
            }
        }
        b.print("// Entry child listing\n");
        for (Map.Entry entry : inverse.entrySet()) {
            b.print("C " + ((CacheEntry)entry.getKey()).toString());
            b.print("\n");
            for (CacheEntry child : (Collection)entry.getValue()) {
                Integer h = (Integer)hist.get(child);
                if (h != null) {
                    b.print("  " + h);
                } else {
                    b.print("  <no children>");
                }
                b.print("  " + child.toString());
                b.print("\n");
            }
        }
        b.print("#queries: " + workarea.keySet().size() + "\n");
        b.print("#listeners: " + listeners + "\n");
        b.close();
        return "Dumped " + workarea.keySet().size() + " queries.";
    }

    boolean removeQuery(CacheEntry entry) {
        if (entry.isDiscarded()) {
            return false;
        }
        assert (!entry.isDiscarded());
        Query query = entry.getQuery();
        query.removeEntry(this);
        ++this.updates;
        --this.size;
        if ((entry.getGCStatus() & 1) != 0) {
            --this.boundQueries;
        }
        entry.discard();
        return true;
    }

    private boolean updateQuery(UpdateEntry e, LinkedList<UpdateEntry> todo, IdentityHashMap<CacheEntry, CacheEntry> immediates) throws DatabaseException {
        ArrayList entries;
        assert (e != null);
        CacheEntry entry = e.entry;
        if (entry.isDiscarded()) {
            return false;
        }
        if (entry.isRefuted()) {
            return false;
        }
        if (entry.isExcepted()) {
            // empty if block
        }
        if (entry.isPending()) {
            // empty if block
        }
        ++this.updates;
        Query query = entry.getQuery();
        int type = query.type();
        boolean hasListener = this.hasListener(entry);
        if (entry.isPending() || entry.isExcepted()) {
            if ((type & 1) == 1) {
                immediates.put(entry, entry);
            } else if (hasListener) {
                entry.refute();
            } else {
                this.removeQuery(entry);
            }
        } else if ((type & 1) == 1) {
            immediates.put(entry, entry);
        } else if (hasListener) {
            entry.refute();
        } else {
            this.removeQuery(entry);
        }
        if (hasListener && (entries = (ArrayList)this.listeners.get((Object)entry)) != null) {
            for (ListenerEntry le : entries) {
                this.scheduleListener(le);
            }
        }
        if (type == 0) {
            this.updateParents(e.indent, entry, todo);
        }
        return hasListener;
    }

    private void updateParents(int indent, CacheEntry entry, LinkedList<UpdateEntry> todo) {
        Iterable<CacheEntry> oldParents = entry.getParents(this);
        for (CacheEntry parent : oldParents) {
            if (parent.isDiscarded()) continue;
            todo.push(new UpdateEntry(entry, parent, indent + 2));
        }
    }

    private boolean pruneListener(ListenerEntry entry) {
        if (entry.base.isDisposed()) {
            this.removeListener(entry);
            return true;
        }
        return false;
    }

    private final boolean arrayEquals(Object av1, Object av2) {
        boolean p2;
        if (av2 == null) {
            return false;
        }
        Class<?> c1 = av1.getClass().getComponentType();
        Class<?> c2 = av2.getClass().getComponentType();
        if (c2 == null || !c1.equals(c2)) {
            return false;
        }
        boolean p1 = c1.isPrimitive();
        if (p1 != (p2 = c2.isPrimitive())) {
            return false;
        }
        if (!p1) {
            return Arrays.equals((Object[])av1, (Object[])av2);
        }
        if (Boolean.TYPE.equals(c1)) {
            return Arrays.equals((boolean[])av1, (boolean[])av2);
        }
        if (Byte.TYPE.equals(c1)) {
            return Arrays.equals((byte[])av1, (byte[])av2);
        }
        if (Integer.TYPE.equals(c1)) {
            return Arrays.equals((int[])av1, (int[])av2);
        }
        if (Long.TYPE.equals(c1)) {
            return Arrays.equals((long[])av1, (long[])av2);
        }
        if (Float.TYPE.equals(c1)) {
            return Arrays.equals((float[])av1, (float[])av2);
        }
        if (Double.TYPE.equals(c1)) {
            return Arrays.equals((double[])av1, (double[])av2);
        }
        throw new RuntimeException("??? Contact application querySupport.");
    }

    private final Object compareTo(ReadGraphImpl graph, CacheEntry entry, Object oldValue) {
        try {
            Query query = entry.getQuery();
            entry.prepareRecompute(this.querySupport);
            ReadGraphImpl parentGraph = graph.withParent(entry);
            query.recompute(parentGraph, this, entry);
            if (entry.isExcepted()) {
                return ListenerEntry.NO_VALUE;
            }
            Object newValue = entry.getResult();
            if (ListenerEntry.NO_VALUE == oldValue) {
                return newValue;
            }
            boolean changed = false;
            changed = newValue != null ? (newValue.getClass().isArray() ? !this.arrayEquals(newValue, oldValue) : !newValue.equals(oldValue)) : oldValue != null;
            return changed ? newValue : ListenerEntry.NOT_CHANGED;
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
            entry.except(t);
            return ListenerEntry.NO_VALUE;
        }
    }

    public boolean hasScheduledUpdates() {
        return !this.scheduledListeners.isEmpty();
    }

    public void performScheduledUpdates(WriteGraphImpl graph) {
        assert (!this.updating);
        assert (!collecting);
        assert (!this.firingListeners);
        this.firingListeners = true;
        try {
            while (!this.scheduledListeners.isEmpty()) {
                CacheEntry entry;
                THashSet<ListenerEntry> entries = this.scheduledListeners;
                this.scheduledListeners = new THashSet();
                ArrayList<ListenerEntry> schedule = new ArrayList<ListenerEntry>();
                for (ListenerEntry listenerEntry : entries) {
                    if (this.pruneListener(listenerEntry)) continue;
                    entry = listenerEntry.entry;
                    assert (entry != null);
                    Object newValue = this.compareTo(graph, entry, listenerEntry.getLastKnown());
                    if (newValue == ListenerEntry.NOT_CHANGED) continue;
                    schedule.add(listenerEntry);
                    listenerEntry.setLastKnown(entry.getResult());
                }
                for (ListenerEntry listenerEntry : schedule) {
                    entry = listenerEntry.entry;
                    try {
                        entry.performFromCache(graph, this, listenerEntry.procedure);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        finally {
            this.firingListeners = false;
        }
    }

    public boolean update(ReadGraphImpl graph, CacheEntry entry) {
        assert (!collecting);
        assert (!this.updating);
        this.updating = true;
        boolean hadListeners = false;
        boolean listenersUnknown = false;
        try {
            assert (entry != null);
            LinkedList<UpdateEntry> todo = new LinkedList<UpdateEntry>();
            IdentityHashMap<CacheEntry, CacheEntry> immediates = new IdentityHashMap<CacheEntry, CacheEntry>();
            todo.add(new UpdateEntry(null, entry, 0));
            while (true) {
                if (!todo.isEmpty()) {
                    UpdateEntry e = (UpdateEntry)todo.pop();
                    hadListeners |= this.updateQuery(e, todo, immediates);
                    continue;
                }
                if (!immediates.isEmpty()) {
                    for (CacheEntry immediate : immediates.values()) {
                        if (immediate.isDiscarded()) continue;
                        if (immediate.isExcepted()) {
                            Object newValue = this.compareTo(graph, immediate, ListenerEntry.NO_VALUE);
                            if (newValue == ListenerEntry.NOT_CHANGED) continue;
                            this.updateParents(0, immediate, todo);
                            continue;
                        }
                        Object oldValue = immediate.getResult();
                        Object newValue = this.compareTo(graph, immediate, oldValue);
                        if (newValue != ListenerEntry.NOT_CHANGED) {
                            this.updateParents(0, immediate, todo);
                            continue;
                        }
                        immediate.setResult(oldValue);
                        listenersUnknown = true;
                    }
                    immediates.clear();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
        }
        assert (this.updating);
        this.updating = false;
        return hadListeners | listenersUnknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDirtyUpdates(final ReadGraphImpl graph) {
        THashSet primitiveUpdates;
        this.dirty = false;
        this.lastInvalidate = 0;
        if (this.scheduledObjectUpdates.size() == 1 && this.scheduledValueUpdates.size() == 0 && this.scheduledPrimitiveUpdates.size() == 0 && this.scheduledInvalidates.size() == 0) {
            OrderedSet os;
            DirectPredicates directPredicates;
            SuperRelations superRelations;
            long arg0 = this.scheduledObjectUpdates.getFirst();
            int subject = (int)(arg0 >>> 32);
            int predicate = (int)(arg0 & 0xFFFFFFFFFFFFFFFFL);
            for (Objects objects : Objects.entries(this, subject)) {
                this.update(graph, objects);
            }
            for (DirectObjects directObjects : DirectObjects.entries(this, subject)) {
                this.update(graph, directObjects);
            }
            for (Statements statements : Statements.entries(this, subject)) {
                this.update(graph, statements);
            }
            if (predicate == this.instanceOf || predicate == this.inherits || predicate == this.subrelationOf) {
                Types types;
                PrincipalTypes principalTypes = PrincipalTypes.entry(this, subject);
                if (principalTypes != null) {
                    this.update(graph, principalTypes);
                }
                if ((types = Types.entry(this, subject)) != null) {
                    this.update(graph, types);
                }
            }
            if (predicate == this.subrelationOf && (superRelations = SuperRelations.entry(this, subject)) != null) {
                this.update(graph, superRelations);
            }
            if ((directPredicates = DirectPredicates.entry(this, subject)) != null) {
                this.update(graph, directPredicates);
            }
            if ((os = OrderedSet.entry(this, predicate)) != null) {
                this.update(graph, os);
            }
            this.scheduledObjectUpdates.clear();
            return;
        }
        if (this.scheduledObjectUpdates.size() == 0 && this.scheduledValueUpdates.size() == 1 && this.scheduledPrimitiveUpdates.size() == 0 && this.scheduledInvalidates.size() == 0) {
            int arg0 = this.scheduledValueUpdates.getFirst();
            ValueQuery valueQuery = ValueQuery.entry(this, arg0);
            if (valueQuery != null) {
                this.update(graph, valueQuery);
            }
            this.scheduledValueUpdates.clear();
            return;
        }
        final TIntHashSet predicates = new TIntHashSet();
        final TIntHashSet orderedSets = new TIntHashSet();
        Object object = this.primitiveUpdateLock;
        synchronized (object) {
            primitiveUpdates = this.scheduledPrimitiveUpdates;
            this.scheduledPrimitiveUpdates = new THashSet();
        }
        primitiveUpdates.forEach(new TObjectProcedure(){

            public boolean execute(Object arg0) {
                boolean listening;
                ExternalReadEntry query = QueryProcessor.this.externalReadMap.get(arg0);
                if (query != null && !(listening = QueryProcessor.this.update(graph, query)) && !query.hasParents()) {
                    QueryProcessor.this.externalReadMap.remove(arg0);
                    query.discard();
                }
                return true;
            }
        });
        this.scheduledValueUpdates.forEach(new TIntProcedure(){

            public boolean execute(int arg0) {
                ValueQuery valueQuery = ValueQuery.entry(QueryProcessor.this, arg0);
                if (valueQuery != null) {
                    QueryProcessor.this.update(graph, valueQuery);
                }
                return true;
            }
        });
        this.scheduledInvalidates.forEach(new TIntProcedure(){

            public boolean execute(int resource) {
                SuperRelations superRelations;
                Types types;
                PrincipalTypes principalTypes;
                ValueQuery valueQuery = ValueQuery.entry(QueryProcessor.this, resource);
                if (valueQuery != null) {
                    QueryProcessor.this.update(graph, valueQuery);
                }
                if ((principalTypes = PrincipalTypes.entry(QueryProcessor.this, resource)) != null) {
                    QueryProcessor.this.update(graph, principalTypes);
                }
                if ((types = Types.entry(QueryProcessor.this, resource)) != null) {
                    QueryProcessor.this.update(graph, types);
                }
                if ((superRelations = SuperRelations.entry(QueryProcessor.this, resource)) != null) {
                    QueryProcessor.this.update(graph, superRelations);
                }
                predicates.add(resource);
                return true;
            }
        });
        this.scheduledObjectUpdates.forEach(new TLongProcedure(){

            public boolean execute(long arg0) {
                SuperRelations superRelations;
                int subject = (int)(arg0 >>> 32);
                int predicate = (int)(arg0 & 0xFFFFFFFFFFFFFFFFL);
                if (predicate == QueryProcessor.this.instanceOf || predicate == QueryProcessor.this.inherits || predicate == QueryProcessor.this.subrelationOf) {
                    Types types;
                    PrincipalTypes principalTypes = PrincipalTypes.entry(QueryProcessor.this, subject);
                    if (principalTypes != null) {
                        QueryProcessor.this.update(graph, principalTypes);
                    }
                    if ((types = Types.entry(QueryProcessor.this, subject)) != null) {
                        QueryProcessor.this.update(graph, types);
                    }
                }
                if (predicate == QueryProcessor.this.subrelationOf && (superRelations = SuperRelations.entry(QueryProcessor.this, subject)) != null) {
                    QueryProcessor.this.update(graph, superRelations);
                }
                predicates.add(subject);
                orderedSets.add(predicate);
                return true;
            }
        });
        predicates.forEach(new TIntProcedure(){

            public boolean execute(int subject) {
                for (Objects objects : Objects.entries(QueryProcessor.this, subject)) {
                    QueryProcessor.this.update(graph, objects);
                }
                for (DirectObjects directObjects : DirectObjects.entries(QueryProcessor.this, subject)) {
                    QueryProcessor.this.update(graph, directObjects);
                }
                for (Statements statements : Statements.entries(QueryProcessor.this, subject)) {
                    QueryProcessor.this.update(graph, statements);
                }
                DirectPredicates directPredicates = DirectPredicates.entry(QueryProcessor.this, subject);
                if (directPredicates != null) {
                    QueryProcessor.this.update(graph, directPredicates);
                }
                return true;
            }
        });
        orderedSets.forEach(new TIntProcedure(){

            public boolean execute(int orderedSet) {
                OrderedSet entry = OrderedSet.entry(QueryProcessor.this, orderedSet);
                if (entry != null) {
                    QueryProcessor.this.update(graph, entry);
                }
                return true;
            }
        });
        this.scheduledValueUpdates.clear();
        this.scheduledObjectUpdates.clear();
        this.scheduledInvalidates.clear();
    }

    public void updateValue(int resource) {
        this.scheduledValueUpdates.add(resource);
        this.dirty = true;
    }

    public void updateStatements(int resource, int predicate) {
        this.scheduledObjectUpdates.add(((long)resource << 32) + (long)predicate);
        this.dirty = true;
    }

    public void invalidateResource(int resource) {
        if (this.lastInvalidate == resource) {
            return;
        }
        this.scheduledValueUpdates.add(resource);
        this.lastInvalidate = resource;
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePrimitive(ExternalRead primitive) {
        Object object = this.primitiveUpdateLock;
        synchronized (object) {
            this.scheduledPrimitiveUpdates.add((Object)primitive);
        }
        this.querySupport.dirtyPrimitives();
    }

    public synchronized String toString() {
        return "QueryProvider [size = " + this.size + ", hits = " + this.hits + " misses = " + this.misses + ", updates = " + this.updates + "]";
    }

    protected void doDispose() {
        boolean alive;
        int index = 0;
        while (index < this.THREADS) {
            this.executors[index].dispose();
            ++index;
        }
        int i = 0;
        while (i < 100) {
            alive = false;
            int index2 = 0;
            while (index2 < this.THREADS) {
                alive |= this.executors[index2].isAlive();
                ++index2;
            }
            if (!alive) {
                return;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Logger.defaultLogError((Throwable)e);
            }
            ++i;
        }
        i = 0;
        while (i < 100) {
            alive = false;
            int index3 = 0;
            while (index3 < this.THREADS) {
                alive |= this.executors[index3].isAlive();
                ++index3;
            }
            if (!alive) {
                return;
            }
            index3 = 0;
            while (index3 < this.THREADS) {
                this.executors[index3].interrupt();
                ++index3;
            }
            ++i;
        }
        index = 0;
        while (index < this.THREADS) {
            try {
                this.executors[index].join(5000L);
            }
            catch (InterruptedException e) {
                Logger.defaultLogError((String)("QueryThread " + index + " will not die."), (Throwable)e);
            }
            this.executors[index] = null;
            ++index;
        }
    }

    public int getHits() {
        return this.hits;
    }

    public int getMisses() {
        return this.misses;
    }

    public int getSize() {
        return this.size;
    }

    public Set<Long> getReferencedClusters() {
        CacheEntryBase query;
        HashSet<Long> result = new HashSet<Long>();
        for (CacheEntry entry : this.objectsMap.values()) {
            query = (Objects)entry.getQuery();
            result.add(this.querySupport.getClusterId(query.r1()));
        }
        for (CacheEntry entry : this.directPredicatesMap.values()) {
            query = (DirectPredicates)entry.getQuery();
            result.add(this.querySupport.getClusterId(((DirectPredicates)query).id));
        }
        for (CacheEntry entry : this.valueMap.values()) {
            query = (ValueQuery)entry.getQuery();
            result.add(this.querySupport.getClusterId(((ValueQuery)query).id));
        }
        return result;
    }

    public void assertDone() {
    }

    CacheCollectionResult allCaches(CacheCollectionResult result) {
        short s = Integer.MAX_VALUE;
        this.directPredicatesMap.values(s, result);
        this.principalTypesMap.values(s, result);
        for (CacheEntryBase e : this.uriToResourceMap.values()) {
            if (e.getLevel() > s) continue;
            result.add(e);
        }
        for (CacheEntryBase e : this.namespaceIndexMap22.values()) {
            if (e.getLevel() > s) continue;
            result.add(e);
        }
        this.projectsMap.values(s, result);
        this.relationInfoMap.values(s, result);
        this.superTypesMap.values(s, result);
        this.typeHierarchyMap.values(s, result);
        this.superRelationsMap.values(s, result);
        this.typesMap.values(s, result);
        this.valueMap.values(s, result);
        this.directObjectsMap.values(s, result);
        this.objectsMap.values(s, result);
        this.orderedSetMap.values(s, result);
        this.predicatesMap.values(s, result);
        this.statementsMap.values(s, result);
        this.assertedPredicatesMap.values(s, result);
        this.assertedStatementsMap.values(s, result);
        this.externalReadMap.values(s, result);
        this.asyncReadMap.values(s, result);
        this.readMap.values(s, result);
        this.asyncMultiReadMap.values(s, result);
        this.multiReadMap.values(s, result);
        return result;
    }

    public void printDiagnostics() {
    }

    public void requestCluster(ReadGraphImpl graph, long clusterId, Runnable runnable) {
        this.querySupport.requestCluster(graph, clusterId, runnable);
    }

    public int clean() {
        this.collector.collect(0, Integer.MAX_VALUE);
        return this.size;
    }

    public void clean(final Collection<ExternalRead<?>> requests) {
        QueryCollectorSupport collectorSupport = new QueryCollectorSupport(){
            Iterator<ExternalRead<?>> iterator;
            {
                this.iterator = collection.iterator();
            }

            @Override
            public CacheCollectionResult allCaches() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CacheEntryBase iterate(int level) {
                if (this.iterator.hasNext()) {
                    ExternalRead<?> request = this.iterator.next();
                    ExternalReadEntry entry = QueryProcessor.this.externalReadMap.get(request);
                    if (entry != null) {
                        return entry;
                    }
                    return this.iterate(level);
                }
                this.iterator = requests.iterator();
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setLevel(CacheEntryBase entry, int level) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<CacheEntry> getRootList() {
                ArrayList<CacheEntry> result = new ArrayList<CacheEntry>(requests.size());
                for (ExternalRead request : requests) {
                    ExternalReadEntry entry = QueryProcessor.this.externalReadMap.get(request);
                    if (entry == null) continue;
                    result.add(entry);
                }
                return result;
            }

            @Override
            public int getCurrentSize() {
                return QueryProcessor.this.size;
            }

            @Override
            public int calculateCurrentSize() {
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean start(boolean flush) {
                return true;
            }
        };
        new QueryCollectorImpl2(this, collectorSupport).collect(0, Integer.MAX_VALUE);
    }

    public void scanPending() {
        ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>();
        entries.addAll(this.directPredicatesMap.values());
        entries.addAll(this.principalTypesMap.values());
        entries.addAll(this.uriToResourceMap.values());
        entries.addAll(this.namespaceIndexMap22.values());
        entries.addAll(this.projectsMap.values());
        entries.addAll(this.relationInfoMap.values());
        entries.addAll(this.superTypesMap.values());
        entries.addAll(this.superRelationsMap.values());
        entries.addAll(this.typesMap.values());
        entries.addAll(this.valueMap.values());
        entries.addAll(this.directObjectsMap.values());
        entries.addAll(this.objectsMap.values());
        entries.addAll(this.orderedSetMap.values());
        entries.addAll(this.predicatesMap.values());
        entries.addAll(this.orderedSetMap.values());
        entries.addAll(this.statementsMap.values());
        entries.addAll(this.assertedPredicatesMap.values());
        entries.addAll(this.assertedStatementsMap.values());
        entries.addAll(this.externalReadMap.values());
        entries.addAll(this.asyncReadMap.values());
        entries.addAll(this.externalReadMap.values());
        entries.addAll(this.readMap.values());
        entries.addAll(this.asyncMultiReadMap.values());
        entries.addAll(this.multiReadMap.values());
        entries.addAll(this.readMap.values());
        System.out.println(String.valueOf(entries.size()) + " entries.");
        for (Object e : entries) {
            if (!(e instanceof CacheEntry)) continue;
            CacheEntry en = (CacheEntry)e;
            if (en.isPending()) {
                System.out.println("pending " + e);
            }
            if (en.isExcepted()) {
                System.out.println("excepted " + e);
            }
            if (en.isDiscarded()) {
                System.out.println("discarded " + e);
            }
            if (en.isRefuted()) {
                System.out.println("refuted " + e);
            }
            if (!en.isFresh()) continue;
            System.out.println("fresh " + e);
        }
    }

    public ReadGraphImpl graphForVirtualRequest() {
        return ReadGraphImpl.createAsync(this);
    }

    public Class<?> getBuiltinValue(Resource r) {
        if (this.builtinValues == null) {
            this.initBuiltinValues();
        }
        return this.builtinValues.get(r);
    }

    private void initBuiltinValues() {
        Layer0 b = (Layer0)this.getSession().peekService(Layer0.class);
        if (b == null) {
            return;
        }
        this.builtinValues = new HashMap();
        this.builtinValues.put(b.String, String.class);
        this.builtinValues.put(b.Double, Double.class);
        this.builtinValues.put(b.Float, Float.class);
        this.builtinValues.put(b.Long, Long.class);
        this.builtinValues.put(b.Integer, Integer.class);
        this.builtinValues.put(b.Byte, Byte.class);
        this.builtinValues.put(b.Boolean, Boolean.class);
        this.builtinValues.put(b.StringArray, String[].class);
        this.builtinValues.put(b.DoubleArray, double[].class);
        this.builtinValues.put(b.FloatArray, float[].class);
        this.builtinValues.put(b.LongArray, long[].class);
        this.builtinValues.put(b.IntegerArray, int[].class);
        this.builtinValues.put(b.ByteArray, byte[].class);
        this.builtinValues.put(b.BooleanArray, boolean[].class);
    }

    @Override
    public final Session getSession() {
        return this.session;
    }

    public final ResourceSupport getResourceSupport() {
        return this.resourceSupport;
    }

    @Override
    public final void forEachPredicate(final ReadGraphImpl impl, Resource subject, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        IntProcedure ip = new IntProcedure(){
            AtomicBoolean first = new AtomicBoolean(true);

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                try {
                    if (this.first.get()) {
                        procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(i));
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)QueryProcessor.this.querySupport.getResource(i));
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.finished((AsyncReadGraph)graph);
                    } else {
                        procedure.finished((AsyncReadGraph)impl.newRestart(graph));
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        Predicates.queryEach(impl, sId, this, impl.parent, listener, ip);
    }

    @Override
    public final void forEachPredicate(ReadGraphImpl impl, Resource subject, final MultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        Predicates.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                try {
                    procedure.execute((Object)QueryProcessor.this.querySupport.getResource(i));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished();
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception(t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final IntSet getPredicates(ReadGraphImpl impl, Resource subject) throws Throwable {
        assert (subject != null);
        return Predicates.queryEach2(impl, this.querySupport.getId(subject), this, impl.parent);
    }

    @Override
    public final void forEachStatement(ReadGraphImpl impl, Resource subject, Resource predicate, final MultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        Statements.queryEach(impl, this.querySupport.getId(subject), this.querySupport.getId(predicate), this, impl.parent, listener, new TripleIntProcedureAdapter(){

            @Override
            public void execute(ReadGraphImpl graph, int s, int p, int o) {
                try {
                    procedure.execute((Object)QueryProcessor.this.querySupport.getStatement(s, p, o));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished();
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception(t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forEachStatement(final ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncMultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        TripleIntProcedureAdapter proc = new TripleIntProcedureAdapter(){
            boolean first = true;

            @Override
            public void execute(ReadGraphImpl graph, int s, int p, int o) {
                try {
                    if (this.first) {
                        procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getStatement(s, p, o));
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)QueryProcessor.this.querySupport.getStatement(s, p, o));
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    if (this.first) {
                        this.first = false;
                        procedure.finished((AsyncReadGraph)graph);
                    } else {
                        procedure.finished((AsyncReadGraph)impl.newRestart(graph));
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first) {
                        this.first = false;
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        int pId = this.querySupport.getId(predicate);
        Statements.queryEach(impl, sId, pId, this, impl.parent, listener, proc);
    }

    @Override
    public final void forEachStatement(final ReadGraphImpl impl, Resource subject, Resource predicate, final StatementProcedure procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        TripleIntProcedureAdapter proc = new TripleIntProcedureAdapter(){
            boolean first = true;

            @Override
            public void execute(ReadGraphImpl graph, int s, int p, int o) {
                try {
                    if (this.first) {
                        procedure.execute((AsyncReadGraph)graph, s, p, o);
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), s, p, o);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    if (this.first) {
                        this.first = false;
                        procedure.finished((AsyncReadGraph)graph);
                    } else {
                        procedure.finished((AsyncReadGraph)impl.newRestart(graph));
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first) {
                        this.first = false;
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        int pId = this.querySupport.getId(predicate);
        Statements.queryEach(impl, sId, pId, this, impl.parent, listener, proc);
    }

    @Override
    public final void forStatementSet(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncSetListener<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachStatement(impl, subject, predicate, (AsyncMultiProcedure<Statement>)new AsyncMultiListener<Statement>(){
            private Set<Statement> current = null;
            private Set<Statement> run = new HashSet<Statement>();

            public void execute(AsyncReadGraph graph, Statement result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Statement r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Statement>();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }
        });
    }

    @Override
    public final void forEachAssertedStatement(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncMultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        AssertedStatements.queryEach(impl, this.querySupport.getId(subject), this.querySupport.getId(predicate), this, impl.parent, listener, new TripleIntProcedureAdapter(){

            @Override
            public void execute(ReadGraphImpl graph, int s, int p, int o) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getStatement(s, p, o));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished((AsyncReadGraph)graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    private static ListenerBase getListenerBase(Object procedure) {
        if (procedure instanceof ListenerBase) {
            return (ListenerBase)procedure;
        }
        return null;
    }

    @Override
    public final void forEachObject(ReadGraphImpl impl, Resource subject, Resource predicate, final MultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        Objects.runner(impl, this.querySupport.getId(subject), this.querySupport.getId(predicate), impl.parent, listener, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                try {
                    procedure.execute((Object)QueryProcessor.this.querySupport.getResource(i));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished();
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                System.out.println("forEachObject exception " + t);
                try {
                    procedure.exception(t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forEachDirectPredicate(ReadGraphImpl impl, Resource subject, AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        MultiIntProcedure proc = new MultiIntProcedure(procedure, impl, this.querySupport);
        int sId = this.querySupport.getId(subject);
        DirectPredicates.queryEach(impl, sId, this, impl.parent, listener, proc);
    }

    @Override
    public final void forEachDirectStatement(ReadGraphImpl impl, Resource subject, Procedure<org.simantics.db.DirectStatements> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        DirectStatements.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, procedure);
    }

    @Override
    public final void forEachDirectStatement(ReadGraphImpl impl, Resource subject, AsyncProcedure<org.simantics.db.DirectStatements> procedure, boolean ignoreVirtual) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        DirectStatements.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, procedure, ignoreVirtual);
    }

    @Override
    public final void forPossibleObject(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncProcedure<Resource> procedure) {
        this.forEachObject(impl, subject, predicate, new AsyncMultiProcedure<Resource>(){
            private Resource single = null;

            public synchronized void execute(AsyncReadGraph graph, Resource result) {
                this.single = this.single == null ? result : INVALID_RESOURCE;
            }

            public synchronized void finished(AsyncReadGraph graph) {
                if (this.single == null || this.single == INVALID_RESOURCE) {
                    procedure.execute(graph, null);
                } else {
                    procedure.execute(graph, (Object)this.single);
                }
            }

            public synchronized void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    public final void forEachObject(ReadGraphImpl impl, Resource subject, Resource predicate, ListenerBase listener, IntProcedure procedure) {
        int sId = this.querySupport.getId(subject);
        int pId = this.querySupport.getId(predicate);
        Objects.runner(impl, sId, pId, impl.parent, listener, procedure);
    }

    public final int getSingleObject(ReadGraphImpl impl, Resource subject, Resource predicate) throws DatabaseException {
        int sId = this.querySupport.getId(subject);
        int pId = this.querySupport.getId(predicate);
        return Objects.runner2(impl, sId, pId, impl.parent);
    }

    @Override
    public final void forEachObject(final ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        if (impl.parent != null || listener != null) {
            IntProcedure ip = new IntProcedure(){
                AtomicBoolean first = new AtomicBoolean(true);

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    try {
                        if (this.first.get()) {
                            procedure.execute((AsyncReadGraph)impl, (Object)QueryProcessor.this.querySupport.getResource(i));
                        } else {
                            procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)QueryProcessor.this.querySupport.getResource(i));
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.finished((AsyncReadGraph)impl);
                        } else {
                            procedure.finished((AsyncReadGraph)impl.newRestart(graph));
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                public String toString() {
                    return "forEachObject with " + procedure;
                }
            };
            this.forEachObject(impl, subject, predicate, listener, ip);
        } else {
            IntProcedure ip = new IntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(i));
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    procedure.finished((AsyncReadGraph)graph);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    procedure.exception((AsyncReadGraph)graph, t);
                }

                public String toString() {
                    return "forEachObject with " + procedure;
                }
            };
            this.forEachObject(impl, subject, predicate, listener, ip);
        }
    }

    @Override
    public final void forObjectSet(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachObject(impl, subject, predicate, (AsyncMultiProcedure<Resource>)new AsyncMultiListener<Resource>(){
            private Set<Resource> current = null;
            private Set<Resource> run = new HashSet<Resource>();

            public void execute(AsyncReadGraph graph, Resource result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Resource r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Resource>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forObjectSet " + procedure;
            }
        });
    }

    @Override
    public final void forPredicateSet(ReadGraphImpl impl, Resource subject, final AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forEachPredicate(impl, subject, (AsyncMultiProcedure<Resource>)new AsyncMultiListener<Resource>(){
            private Set<Resource> current = null;
            private Set<Resource> run = new HashSet<Resource>();

            public void execute(AsyncReadGraph graph, Resource result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Resource r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Resource>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forPredicateSet " + procedure;
            }
        });
    }

    @Override
    public final void forPrincipalTypeSet(ReadGraphImpl impl, Resource subject, final AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forEachPrincipalType(impl, subject, (AsyncMultiProcedure<Resource>)new AsyncMultiListener<Resource>(){
            private Set<Resource> current = null;
            private Set<Resource> run = new HashSet<Resource>();

            public void execute(AsyncReadGraph graph, Resource result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Resource r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Resource>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forPrincipalTypeSet " + procedure;
            }
        });
    }

    @Override
    public final void forAssertedObjectSet(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachAssertedObject(impl, subject, predicate, (AsyncMultiProcedure<Resource>)new AsyncMultiListener<Resource>(){
            private Set<Resource> current = null;
            private Set<Resource> run = new HashSet<Resource>();

            public void execute(AsyncReadGraph graph, Resource result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Resource r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Resource>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forObjectSet " + procedure;
            }
        });
    }

    @Override
    public final void forAssertedStatementSet(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncSetListener<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachAssertedStatement(impl, subject, predicate, (AsyncMultiProcedure<Statement>)new AsyncMultiListener<Statement>(){
            private Set<Statement> current = null;
            private Set<Statement> run = new HashSet<Statement>();

            public void execute(AsyncReadGraph graph, Statement result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Statement s : this.current) {
                        procedure.remove(graph, (Object)s);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Statement>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forStatementSet " + procedure;
            }
        });
    }

    @Override
    public final void forEachAssertedObject(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        AssertedStatements.queryEach(impl, this.querySupport.getId(subject), this.querySupport.getId(predicate), this, impl.parent, listener, new TripleIntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int s, int p, int o) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(o));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished((AsyncReadGraph)graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forEachPrincipalType(ReadGraphImpl impl, Resource subject, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        IntProcedure ip = new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(i));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished((AsyncReadGraph)graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        PrincipalTypes.queryEach(impl, sId, this, impl.parent, listener, ip);
    }

    @Override
    public final void forEachPrincipalType(ReadGraphImpl impl, Resource subject, final MultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        PrincipalTypes.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                try {
                    procedure.execute((Object)QueryProcessor.this.querySupport.getResource(i));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished();
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception(t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forTypes(final ReadGraphImpl impl, Resource subject, final AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        InternalProcedure<IntSet> ip = new InternalProcedure<IntSet>(){
            AtomicBoolean first = new AtomicBoolean(true);

            @Override
            public void execute(ReadGraphImpl graph, IntSet set) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.execute((AsyncReadGraph)graph, (Object)set);
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)set);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        Types.queryEach(impl, sId, this, impl.parent, listener, ip);
    }

    @Override
    public final IntSet getTypes(ReadGraphImpl impl, Resource subject) throws Throwable {
        assert (subject != null);
        return Types.queryEach2(impl, this.querySupport.getId(subject), this, impl.parent);
    }

    @Override
    public final void forRelationInfo(final ReadGraphImpl impl, Resource subject, final AsyncProcedure<RelationInfo> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        RelationInfoQuery.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, new InternalProcedure<RelationInfo>(){
            AtomicBoolean first = new AtomicBoolean(true);

            @Override
            public void execute(ReadGraphImpl graph, RelationInfo set) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.execute((AsyncReadGraph)graph, (Object)set);
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)set);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forSupertypes(final ReadGraphImpl impl, Resource subject, final AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        SuperTypes.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, new InternalProcedure<IntSet>(){
            AtomicBoolean first = new AtomicBoolean(true);

            @Override
            public void execute(ReadGraphImpl graph, IntSet set) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.execute((AsyncReadGraph)graph, (Object)set);
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)set);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forDirectSuperrelations(ReadGraphImpl impl, Resource subject, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        IntProcedureAdapter ip = new IntProcedureAdapter(){

            @Override
            public void execute(ReadGraphImpl graph, int superRelation) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(superRelation));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished((AsyncReadGraph)graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        DirectSuperRelations.queryEach(impl, sId, this, impl.parent, listener, ip);
    }

    @Override
    public final void forPossibleSuperrelation(ReadGraphImpl impl, Resource subject, AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        PossibleSuperRelation.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, procedure);
    }

    @Override
    public final void forSuperrelations(ReadGraphImpl impl, Resource subject, final AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        InternalProcedure<IntSet> ip = new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet set) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)set);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        SuperRelations.queryEach(impl, sId, this, impl.parent, listener, ip);
    }

    @Override
    public final byte[] getValue(ReadGraphImpl impl, Resource subject) throws DatabaseException {
        int sId = this.querySupport.getId(subject);
        return ValueQuery.queryEach(impl, sId, impl.parent);
    }

    public final byte[] getValue(ReadGraphImpl impl, int subject) throws DatabaseException {
        return ValueQuery.queryEach(impl, subject, impl.parent);
    }

    @Override
    public final byte[] forValue(final ReadGraphImpl impl, Resource subject, final AsyncProcedure<byte[]> procedure) {
        assert (subject != null);
        int sId = this.querySupport.getId(subject);
        if (procedure != null) {
            ListenerBase listener = QueryProcessor.getListenerBase(procedure);
            InternalProcedure<byte[]> ip = new InternalProcedure<byte[]>(){
                AtomicBoolean first = new AtomicBoolean(true);

                @Override
                public void execute(ReadGraphImpl graph, byte[] result) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.execute((AsyncReadGraph)graph, (Object)result);
                        } else {
                            procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)result);
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.exception((AsyncReadGraph)graph, t);
                        } else {
                            procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            };
            return ValueQuery.queryEach(impl, sId, impl.parent, listener, ip);
        }
        return ValueQuery.queryEach(impl, sId, impl.parent, null, null);
    }

    @Override
    public final void forPossibleValue(final ReadGraphImpl impl, Resource subject, final AsyncProcedure<byte[]> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        if (impl.parent != null || listener != null) {
            InternalProcedure<byte[]> ip = new InternalProcedure<byte[]>(){
                AtomicBoolean first = new AtomicBoolean(true);

                @Override
                public void execute(ReadGraphImpl graph, byte[] result) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.execute((AsyncReadGraph)graph, (Object)result);
                        } else {
                            procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)result);
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.exception((AsyncReadGraph)graph, t);
                        } else {
                            procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            };
            int sId = this.querySupport.getId(subject);
            ValueQuery.queryEach(impl, sId, impl.parent, listener, ip);
        } else {
            InternalProcedure<byte[]> ip = new InternalProcedure<byte[]>(){

                @Override
                public void execute(ReadGraphImpl graph, byte[] result) {
                    procedure.execute((AsyncReadGraph)graph, (Object)result);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
            };
            int sId = this.querySupport.getId(subject);
            ValueQuery.queryEach(impl, sId, impl.parent, listener, ip);
        }
    }

    @Override
    public final void forInverse(ReadGraphImpl impl, Resource relation, final AsyncProcedure<Resource> procedure) {
        assert (relation != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        IntProcedure ip = new IntProcedure(){
            private int result = 0;
            final AtomicBoolean found = new AtomicBoolean(false);
            final AtomicBoolean done = new AtomicBoolean(false);

            @Override
            public void finished(ReadGraphImpl graph) {
                if (this.done.compareAndSet(false, true)) {
                    try {
                        if (this.result == 0) {
                            procedure.exception((AsyncReadGraph)graph, (Throwable)new NoInverseException(""));
                        } else {
                            procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(this.result));
                        }
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                if (this.found.compareAndSet(false, true)) {
                    this.result = i;
                } else if (this.done.compareAndSet(false, true)) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)new ManyObjectsForFunctionalRelationException("Multiple items e.g. " + this.result + " and " + this.result));
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                if (this.done.compareAndSet(false, true)) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            }
        };
        int sId = this.querySupport.getId(relation);
        Objects.runner(impl, sId, this.getInverseOf(), impl.parent, listener, ip);
    }

    @Override
    public final void forResource(ReadGraphImpl impl, String id, final AsyncProcedure<Resource> procedure) {
        assert (id != null);
        assert (procedure != null);
        InternalProcedure<Integer> ip = new InternalProcedure<Integer>(){

            @Override
            public void execute(ReadGraphImpl graph, Integer result) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(result));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        this.forResource(impl, id, impl.parent, ip);
    }

    @Override
    public final void forBuiltin(ReadGraphImpl impl, String id, final AsyncProcedure<Resource> procedure) {
        assert (id != null);
        assert (procedure != null);
        this.forBuiltin(impl, id, impl.parent, new InternalProcedure<Integer>(){

            @Override
            public void execute(ReadGraphImpl graph, Integer result) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(result));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forHasStatement(ReadGraphImpl impl, Resource subject, final AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        DirectPredicates.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, new IntProcedure(){
            boolean found = false;

            @Override
            public void execute(ReadGraphImpl graph, int object) {
                this.found = true;
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)this.found);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forHasStatement(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        AsyncMultiProcedureAdapter<Resource> ip = new AsyncMultiProcedureAdapter<Resource>(){
            boolean found = false;

            public synchronized void execute(AsyncReadGraph graph, Resource resource) {
                this.found = true;
            }

            public synchronized void finished(AsyncReadGraph graph) {
                try {
                    procedure.execute(graph, (Object)this.found);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        this.forEachObject(impl, subject, predicate, (AsyncMultiProcedure<Resource>)ip);
    }

    @Override
    public final void forHasStatement(ReadGraphImpl impl, Resource subject, Resource predicate, final Resource object, final AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachObject(impl, subject, predicate, (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){
            boolean found = false;

            public synchronized void execute(AsyncReadGraph graph, Resource resource) {
                if (resource.equals(object)) {
                    this.found = true;
                }
            }

            public synchronized void finished(AsyncReadGraph graph) {
                try {
                    procedure.execute(graph, (Object)this.found);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forHasValue(ReadGraphImpl impl, Resource subject, final AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        ValueQuery.queryEach(impl, this.querySupport.getId(subject), impl.parent, listener, new InternalProcedure<byte[]>(){

            @Override
            public void execute(ReadGraphImpl graph, byte[] object) {
                boolean result = object != null;
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)result);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forOrderedSet(ReadGraphImpl impl, Resource subject, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        OrderedSet.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, new IntProcedure(){

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(i));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished((AsyncReadGraph)graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final <T> void query(ReadGraphImpl impl, AsyncRead<T> request, CacheEntry parent, AsyncProcedure<T> procedure, ListenerBase listener) {
        assert (request != null);
        assert (procedure != null);
        this.runAsyncRead(impl, request, parent, listener, procedure);
    }

    @Override
    public final <T> T tryQuery(ReadGraphImpl graph, Read<T> request) throws DatabaseException {
        assert (graph != null);
        assert (request != null);
        ReadEntry entry = this.readMap.get(request);
        if (entry != null && entry.isReady()) {
            return (T)entry.get(graph, this, null);
        }
        return (T)request.perform((ReadGraph)graph);
    }

    public final <T> T tryQuery(ReadGraphImpl graph, ExternalRead<T> request) throws DatabaseException {
        assert (graph != null);
        assert (request != null);
        ExternalReadEntry entry = this.externalReadMap.get(request);
        if (entry != null && entry.isReady()) {
            if (entry.isExcepted()) {
                Throwable t = (Throwable)entry.getResult();
                if (t instanceof DatabaseException) {
                    throw (DatabaseException)t;
                }
                throw new DatabaseException(t);
            }
            return entry.getResult();
        }
        final DataContainer result = new DataContainer();
        final DataContainer exception = new DataContainer();
        request.register((ReadGraph)graph, new Listener<T>(){

            public void exception(Throwable t) {
                exception.set((Object)t);
            }

            public void execute(T t) {
                result.set(t);
            }

            public boolean isDisposed() {
                return true;
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(t);
        }
        return (T)result.get();
    }

    @Override
    public final <T> void tryQuery(ReadGraphImpl graph, AsyncRead<T> request, AsyncProcedure<T> procedure) {
        assert (graph != null);
        assert (request != null);
        AsyncReadEntry entry = this.asyncReadMap.get(request);
        if (entry != null && entry.isReady()) {
            if (entry.isExcepted()) {
                procedure.exception((AsyncReadGraph)graph, (Throwable)entry.getResult());
            } else {
                procedure.execute((AsyncReadGraph)graph, entry.getResult());
            }
        } else {
            request.perform((AsyncReadGraph)graph, procedure);
        }
    }

    @Override
    public final <T> void query(ReadGraphImpl impl, MultiRead<T> request, CacheEntry parent, AsyncMultiProcedure<T> procedure, ListenerBase listener) {
        assert (request != null);
        assert (procedure != null);
        this.queryMultiRead(impl, request, parent, listener, procedure);
    }

    @Override
    public final <T> void query(ReadGraphImpl impl, AsyncMultiRead<T> request, CacheEntry parent, final AsyncMultiProcedure<T> procedure, ListenerBase listener) {
        assert (request != null);
        assert (procedure != null);
        this.runAsyncMultiRead(impl, request, parent, listener, new AsyncMultiProcedure<T>(){

            public void execute(AsyncReadGraph graph, T result) {
                try {
                    procedure.execute(graph, result);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public void finished(AsyncReadGraph graph) {
                try {
                    procedure.finished(graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return procedure.toString();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final <T> void query(ReadGraphImpl impl, ExternalRead<T> request, CacheEntry parent, final Procedure<T> procedure, ListenerBase listener) {
        assert (request != null);
        assert (procedure != null);
        this.queryPrimitiveRead(impl, request, parent, listener, new Procedure<T>(){

            public void execute(T result) {
                try {
                    procedure.execute(result);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return procedure.toString();
            }

            public void exception(Throwable t) {
                try {
                    procedure.exception(t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public VirtualGraph getProvider(Resource subject, Resource predicate, Resource object) {
        return this.querySupport.getProvider(this.querySupport.getId(subject), this.querySupport.getId(predicate), this.querySupport.getId(object));
    }

    @Override
    public VirtualGraph getProvider(Resource subject, Resource predicate) {
        return this.querySupport.getProvider(this.querySupport.getId(subject), this.querySupport.getId(predicate));
    }

    @Override
    public VirtualGraph getValueProvider(Resource subject) {
        return this.querySupport.getValueProvider(this.querySupport.getId(subject));
    }

    public boolean resumeTasks(ReadGraphImpl graph) {
        return this.querySupport.resume(graph);
    }

    public boolean isImmutable(int resourceId) {
        return this.querySupport.isImmutable(resourceId);
    }

    public boolean isImmutable(Resource resource) {
        ResourceImpl impl = (ResourceImpl)resource;
        return this.isImmutable(impl.id);
    }

    public Layer0 getL0(ReadGraph graph) {
        if (this.L0 == null) {
            this.L0 = Layer0.getInstance((ReadGraph)graph);
        }
        return this.L0;
    }

    public static interface AsyncBarrier {
        public void inc();

        public void dec();
    }

    static class Dummy
    implements InternalProcedure<Object>,
    IntProcedure {
        Dummy() {
        }

        @Override
        public void execute(ReadGraphImpl graph, int i) {
        }

        @Override
        public void finished(ReadGraphImpl graph) {
        }

        @Override
        public void execute(ReadGraphImpl graph, Object result) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    }

    static interface QueryCollector {
        public void collect(int var1, int var2);
    }

    static interface QueryCollectorSupport {
        public CacheCollectionResult allCaches();

        public Collection<CacheEntry> getRootList();

        public int getCurrentSize();

        public int calculateCurrentSize();

        public CacheEntryBase iterate(int var1);

        public void remove();

        public void setLevel(CacheEntryBase var1, int var2);

        public boolean start(boolean var1);
    }

    class QueryCollectorSupportImpl
    implements QueryCollectorSupport {
        private static final boolean DEBUG = false;
        private static final double ITERATION_RATIO = 0.2;
        private CacheCollectionResult iteration = new CacheCollectionResult();
        private boolean fresh = true;
        private boolean needDataInStart = true;

        QueryCollectorSupportImpl() {
            this.iteration.restart();
        }

        @Override
        public CacheCollectionResult allCaches() {
            CacheCollectionResult result = new CacheCollectionResult();
            QueryProcessor.this.allCaches(result);
            result.restart();
            return result;
        }

        @Override
        public boolean start(boolean flush) {
            this.fresh = true;
            if (this.needDataInStart || flush) {
                this.restart(flush ? 0.0 : 0.2);
            }
            return this.iteration.isAtStart();
        }

        private void restart(double targetRatio) {
            this.needDataInStart = true;
            long start = System.nanoTime();
            if (this.fresh) {
                boolean dirty;
                int iterationSize = this.iteration.size() + 1;
                int diff = this.calculateCurrentSize() - iterationSize;
                double ratio = (double)diff / (double)iterationSize;
                boolean bl = dirty = Math.abs(ratio) >= targetRatio;
                if (dirty) {
                    this.iteration = this.allCaches();
                } else {
                    this.iteration.restart();
                }
                this.fresh = false;
                this.needDataInStart = false;
            } else {
                this.iteration.restart();
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public CacheEntryBase iterate(int level) {
            entry = this.iteration.next(level);
            if (entry != null) ** GOTO lbl6
            this.restart(0.2);
            return null;
lbl-1000:
            // 1 sources

            {
                entry = this.iteration.next(level);
lbl6:
                // 2 sources

                ** while (entry != null && entry.isDiscarded())
            }
lbl7:
            // 1 sources

            return entry;
        }

        @Override
        public void remove() {
            this.iteration.remove();
        }

        @Override
        public void setLevel(CacheEntryBase entry, int level) {
            this.iteration.setLevel(entry, level);
        }

        @Override
        public Collection<CacheEntry> getRootList() {
            ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
            for (CacheEntry cacheEntry : QueryProcessor.this.valueMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.directPredicatesMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.objectsMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.directObjectsMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.principalTypesMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.superRelationsMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.superTypesMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.typesMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.objectsMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.assertedStatementsMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.readMap.values()) {
                if (cacheEntry instanceof CacheEntry) {
                    result.add(cacheEntry);
                    continue;
                }
                System.err.println("e=" + cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.asyncReadMap.values()) {
                if (cacheEntry instanceof CacheEntry) {
                    result.add(cacheEntry);
                    continue;
                }
                System.err.println("e=" + cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.externalReadMap.values()) {
                result.add(cacheEntry);
            }
            for (CacheEntry cacheEntry : QueryProcessor.this.orderedSetMap.values()) {
                result.add(cacheEntry);
            }
            return result;
        }

        @Override
        public int calculateCurrentSize() {
            int realSize = 0;
            realSize += QueryProcessor.this.directPredicatesMap.size();
            realSize += QueryProcessor.this.principalTypesMap.size();
            realSize += QueryProcessor.this.uriToResourceMap.size();
            realSize += QueryProcessor.this.namespaceIndexMap22.size();
            realSize += QueryProcessor.this.projectsMap.size();
            realSize += QueryProcessor.this.relationInfoMap.size();
            realSize += QueryProcessor.this.superTypesMap.size();
            realSize += QueryProcessor.this.typeHierarchyMap.size();
            realSize += QueryProcessor.this.superRelationsMap.size();
            realSize += QueryProcessor.this.typesMap.size();
            realSize += QueryProcessor.this.valueMap.size();
            realSize += QueryProcessor.this.directObjectsMap.size();
            realSize += QueryProcessor.this.objectsMap.size();
            realSize += QueryProcessor.this.orderedSetMap.size();
            realSize += QueryProcessor.this.predicatesMap.size();
            realSize += QueryProcessor.this.statementsMap.size();
            realSize += QueryProcessor.this.assertedPredicatesMap.size();
            realSize += QueryProcessor.this.assertedStatementsMap.size();
            realSize += QueryProcessor.this.externalReadMap.size();
            realSize += QueryProcessor.this.asyncReadMap.size();
            realSize += QueryProcessor.this.readMap.size();
            realSize += QueryProcessor.this.asyncMultiReadMap.size();
            QueryProcessor.this.size = realSize += QueryProcessor.this.multiReadMap.size();
            return realSize;
        }

        @Override
        public int getCurrentSize() {
            return QueryProcessor.this.size;
        }
    }

    public static abstract class SessionRead
    extends SessionTask {
        public final Semaphore notify;
        public final DataContainer<Throwable> throwable;

        public SessionRead(Object object, DataContainer<Throwable> throwable, Semaphore notify, int thread) {
            super(object, thread, thread);
            this.throwable = throwable;
            this.notify = notify;
        }

        public SessionRead(Object object, DataContainer<Throwable> throwable, Semaphore notify, int thread, int syncThread) {
            super(object, thread, syncThread);
            this.throwable = throwable;
            this.notify = notify;
        }
    }

    public static abstract class SessionTask {
        public final int thread;
        public final int syncCaller;
        public final Object object;

        public SessionTask(WriteTraits object, int thread) {
            this.thread = thread;
            this.syncCaller = -1;
            this.object = object;
        }

        public SessionTask(Object object, int thread, int syncCaller) {
            this.thread = thread;
            this.syncCaller = syncCaller;
            this.object = object;
        }

        public abstract void run(int var1);

        public String toString() {
            return "SessionTask[" + this.object + "]";
        }
    }

    static enum ThreadState {
        INIT,
        RUN,
        SLEEP,
        DISPOSED;

    }

    class UpdateEntry {
        public CacheEntry caller;
        public CacheEntry entry;
        public int indent;

        public UpdateEntry(CacheEntry caller, CacheEntry entry, int indent) {
            this.caller = caller;
            this.entry = entry;
            this.indent = indent;
        }
    }
}

