/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.Collection;
import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.BinaryQuery;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionBinaryQuery;
import org.simantics.db.impl.query.DoubleKeyQueryHashMap;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procedure.ListenerBase;

public final class DirectObjects
extends CollectionBinaryQuery<IntProcedure> {
    private DirectObjects(int r1, int r2) {
        super(r1, r2);
    }

    @Override
    public int type() {
        return 0;
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(INVALID_RESULT);
    }

    static final DirectObjects entry(QueryProcessor provider, int r1, int r2) {
        return (DirectObjects)provider.directObjectsMap.get(DirectObjects.id(r1, r2));
    }

    static final Collection<DirectObjects> entries(QueryProcessor processor, int r1) {
        DoubleKeyQueryHashMap<IntProcedure> hash = processor.directObjectsMap;
        return hash.values(r1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, int r1, int r2, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        QueryProcessor processor = graph.processor;
        DirectObjects entry = (DirectObjects)processor.directObjectsMap.get(DirectObjects.id(r1, r2));
        if (entry == null) {
            entry = new DirectObjects(r1, r2);
            entry.setPending();
            entry.clearResult(processor.querySupport);
            entry.putEntry(processor);
            processor.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (entry.isPending()) {
                DirectObjects directObjects = entry;
                synchronized (directObjects) {
                    if (entry.isPending()) {
                        processor.registerDependencies(graph, entry, parent, listener, procedure, false);
                        entry.computeForEach(graph, processor, procedure, true);
                        return;
                    }
                }
            }
            processor.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, int r1, int r2, QueryProcessor provider, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        assert (r1 != 0);
        assert (r2 != 0);
        if (parent == null && listener == null) {
            DirectObjects.computeForEach(graph, r1, r2, null, procedure);
        } else {
            DirectObjects.runner(graph, r1, r2, parent, listener, procedure);
        }
    }

    @Override
    public BinaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.directObjectsMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.directObjectsMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.directObjectsMap.remove(this.id);
    }

    @Override
    public void computeForEach(ReadGraphImpl graph, QueryProcessor queryProvider, IntProcedure procedure, boolean store) {
        DirectObjects.computeForEach(graph, this.r1(), this.r2(), this, procedure);
    }

    public static void computeForEach(ReadGraphImpl graph, int r1, int r2, DirectObjects entry, final IntProcedure procedure) {
        QueryProcessor processor = graph.processor;
        processor.querySupport.ensureLoaded(graph, r1, r2);
        processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                procedure.execute(graph, i);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
            }
        });
        if (entry != null) {
            entry.finish(graph, processor);
        }
        procedure.finished(graph);
    }

    public String toString() {
        return "DirectObjects[" + this.r1() + " - " + this.r2() + "]";
    }

    @Override
    public void setReady() {
        this.statusOrException = READY;
    }

    private final void finish(ReadGraphImpl graph, QueryProcessor provider) {
        this.setReady();
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure) {
        assert (this.isReady());
        this.computeForEach(graph, provider, procedure, false);
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new IntProcedure(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute.", t);
            }

            @Override
            public void execute(ReadGraphImpl graphd, int i) {
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.r1());
    }
}

