/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class GraphPrinter {
    public static String LOG_FILE = "d:\\graph.dot";
    public static boolean LOG = true;
    static Object loggerCreationLock = new Object();
    static GraphPrinter logger = null;
    DataOutput log;

    public GraphPrinter() {
        if (LOG) {
            try {
                FileOutputStream stream = new FileOutputStream(LOG_FILE);
                this.log = new DataOutputStream(stream);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphPrinter getInstance() {
        if (logger == null) {
            Object object = loggerCreationLock;
            synchronized (object) {
                if (logger == null) {
                    logger = new GraphPrinter();
                }
            }
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(String filename) {
        if (LOG) {
            try {
                FileOutputStream stream = new FileOutputStream(LOG_FILE);
                this.log = new DataOutputStream(stream);
                try {
                    DataOutput dataOutput = this.log;
                    synchronized (dataOutput) {
                        this.log.writeBytes("digraph test {\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (LOG) {
            try {
                DataOutput dataOutput = this.log;
                synchronized (dataOutput) {
                    this.log.writeBytes("}\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.log = null;
        }
    }

    private String escape(String input) {
        return input.replace("[", "_").replace("]", "_").replace(":", "_").replace("/", "_").replace("@", "_").replace(".", "_").replace(" ", "_").replace("#", "_").replace("-", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String start, String end) {
        try {
            DataOutput dataOutput = this.log;
            synchronized (dataOutput) {
                this.log.writeBytes(this.escape(start.toString()));
                this.log.writeBytes(" -> ");
                this.log.writeBytes(this.escape(end.toString()));
                this.log.writeBytes("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

