/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.simantics.scl.compiler.ErrorMessage;
import org.simantics.scl.compiler.InvalidInputException;
import org.simantics.scl.compiler.SCLCompiler;
import org.simantics.scl.compiler.SCLCompilerConfiguration;
import org.simantics.scl.ui.editor.SCLAnnotationAccess;
import org.simantics.scl.ui.editor.SCLSourceViewerConfiguration;
import org.simantics.scl.ui.editor.SharedTextColors;

public class SCLTextEditor
extends Composite {
    private static final int DELAY_BEFORE_COMPILATION = 500;
    SCLCompilerConfiguration configuration;
    SourceViewer viewer;
    ImageRegistry imageRegistry;
    SCLAnnotationAccess annotationAccess;
    ISharedTextColors sharedTextColors;
    IAnnotationModel annotationModel;
    Object compilationLock = new Object();
    String codeToBeCompiled;
    private Point storedSelectedRange;

    public SCLTextEditor(Composite parent, int style, SCLCompilerConfiguration configuration) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.configuration = configuration;
        this.imageRegistry = new ImageRegistry(parent.getDisplay());
        this.annotationAccess = new SCLAnnotationAccess(this.imageRegistry);
        this.sharedTextColors = new SharedTextColors(this.getDisplay());
        this.annotationModel = new AnnotationModel();
        VerticalRuler leftRuler = new VerticalRuler(12, (IAnnotationAccess)this.annotationAccess);
        leftRuler.setModel(this.annotationModel);
        OverviewRuler rightRuler = new OverviewRuler((IAnnotationAccess)this.annotationAccess, 12, this.sharedTextColors);
        rightRuler.setModel(this.annotationModel);
        rightRuler.addAnnotationType((Object)"error");
        rightRuler.setAnnotationTypeLayer((Object)"error", 0);
        rightRuler.setAnnotationTypeColor((Object)"error", this.sharedTextColors.getColor(new RGB(255, 0, 128)));
        this.viewer = new SourceViewer((Composite)this, (IVerticalRuler)leftRuler, (IOverviewRuler)rightRuler, true, 768);
        Document document = new Document();
        this.viewer.setDocument((IDocument)document, this.annotationModel);
        this.viewer.setEditable(true);
        this.viewer.configure((SourceViewerConfiguration)new SCLSourceViewerConfiguration((Device)this.getDisplay(), this.sharedTextColors));
        AnnotationPainter annotationPainter = new AnnotationPainter((ISourceViewer)this.viewer, (IAnnotationAccess)this.annotationAccess);
        annotationPainter.addAnnotationType((Object)"error");
        annotationPainter.setAnnotationTypeColor((Object)"error", this.sharedTextColors.getColor(new RGB(255, 0, 128)));
        this.viewer.addPainter((IPainter)annotationPainter);
        this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)annotationPainter);
        this.viewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 122 && e.stateMask == 262144) {
                    SCLTextEditor.this.viewer.getUndoManager().undo();
                } else if (e.keyCode == 121 && e.stateMask == 262144) {
                    SCLTextEditor.this.viewer.getUndoManager().redo();
                }
            }
        });
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                SCLTextEditor.this.scheduleCompilation();
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.sharedTextColors.dispose();
    }

    private void removeAnnotations() {
        Iterator it = this.annotationModel.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation annotation = (Annotation)it.next();
            this.annotationModel.removeAnnotation(annotation);
        }
    }

    private void setAnnotations(Collection<ErrorMessage> messages) {
        this.removeAnnotations();
        for (ErrorMessage message : messages) {
            this.annotationModel.addAnnotation(new Annotation("error", true, message.getMessage()), new Position(message.getStart(), message.getStop() - message.getStart() + 1));
        }
    }

    private void compileSync(String code) {
        try {
            SCLCompiler.compileExpression((SCLCompilerConfiguration)this.configuration, (String)code);
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SCLTextEditor.this.removeAnnotations();
                }
            });
        }
        catch (InvalidInputException e) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SCLTextEditor.this.setAnnotations(e.getErrors());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scheduleCompilation() {
        Object object = this.compilationLock;
        synchronized (object) {
            if (this.codeToBeCompiled == null) {
                new Thread("SCLTextEditor compilation"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            String code;
                            Object object = SCLTextEditor.this.compilationLock;
                            synchronized (object) {
                                do {
                                    code = SCLTextEditor.this.codeToBeCompiled;
                                    try {
                                        SCLTextEditor.this.compilationLock.wait(500L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                } while (!code.equals(SCLTextEditor.this.codeToBeCompiled));
                            }
                            SCLTextEditor.this.compileSync(code);
                            object = SCLTextEditor.this.compilationLock;
                            synchronized (object) {
                                if (code.equals(SCLTextEditor.this.codeToBeCompiled)) {
                                    SCLTextEditor.this.codeToBeCompiled = null;
                                    return;
                                }
                            }
                        }
                    }
                }.start();
            }
            this.codeToBeCompiled = this.viewer.getDocument().get();
            this.compilationLock.notify();
        }
    }

    public String getContent() {
        final String[] result = new String[1];
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = SCLTextEditor.this.viewer.getDocument().get();
            }
        });
        return result[0];
    }

    public void setContent(final String content) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SCLTextEditor.this.viewer.getTextWidget().isDisposed()) {
                    return;
                }
                SCLTextEditor.this.viewer.getDocument().set(content);
            }
        });
    }

    public void storeSelectedRange() {
        this.storedSelectedRange = this.viewer.getSelectedRange();
    }

    public void restoreSelectedRange() {
        if (this.storedSelectedRange != null) {
            this.viewer.setSelectedRange(this.storedSelectedRange.x, this.storedSelectedRange.y);
            this.storedSelectedRange = null;
        }
    }
}

