/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor;

import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class SCLSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final char[] CONTENT_ASSIST_AUTO_CHARS = new char[]{'.'};
    Device device;
    ISharedTextColors sharedTextColors;

    public SCLSourceViewerConfiguration(Device device, ISharedTextColors sharedTextColors) {
        this.device = device;
        this.sharedTextColors = sharedTextColors;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getSclTokenScanner());
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    ITokenScanner getSclTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        Font font = new Font(this.device, "Courier New", 10, 0);
        Font boldFont = new Font(this.device, "Courier New", 10, 1);
        Token defaultToken = new Token((Object)new TextAttribute(this.sharedTextColors.getColor(new RGB(0, 0, 0)), null, 0, font));
        Token string = new Token((Object)new TextAttribute(this.sharedTextColors.getColor(new RGB(42, 0, 255)), null, 0, font));
        Token reserved = new Token((Object)new TextAttribute(this.sharedTextColors.getColor(new RGB(127, 0, 85)), null, 1, boldFont));
        Token comment = new Token((Object)new TextAttribute(this.sharedTextColors.getColor(new RGB(63, 127, 95)), null, 0, font));
        WordRule reservedWord = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c) || c == '.';
            }
        });
        reservedWord.addWord("if", (IToken)reserved);
        reservedWord.addWord("then", (IToken)reserved);
        reservedWord.addWord("else", (IToken)reserved);
        reservedWord.addWord("match", (IToken)reserved);
        reservedWord.addWord("with", (IToken)reserved);
        reservedWord.addWord("data", (IToken)reserved);
        reservedWord.addWord("type", (IToken)reserved);
        reservedWord.addWord("class", (IToken)reserved);
        IRule[] rules = new IRule[]{new PatternRule("\"", "\"", (IToken)string, '\\', true), new MultiLineRule("/*", "*/", (IToken)comment), new PatternRule("//", null, (IToken)comment, '\u0000', true), reservedWord};
        scanner.setRules(rules);
        scanner.setDefaultReturnToken((IToken)defaultToken);
        return scanner;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextHover(sourceViewer);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }
}

