/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.Color;

public class ColorUtil {
    public static Color blend(Color src, Color dst, double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("expected t in [0,1], got t " + ratio);
        }
        double r1 = src.getRed();
        double g1 = src.getGreen();
        double b1 = src.getBlue();
        double a1 = src.getAlpha();
        double r2 = dst.getRed();
        double g2 = dst.getGreen();
        double b2 = dst.getBlue();
        double a2 = dst.getAlpha();
        double r = r1 + (r2 - r1) * ratio;
        double g = g1 + (g2 - g1) * ratio;
        double b = b1 + (b2 - b1) * ratio;
        double a = a1 + (a2 - a1) * ratio;
        return new Color((int)r, (int)g, (int)b, (int)a);
    }

    public static Color withAlpha(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color withAlpha(Color c, float alpha) {
        return ColorUtil.withAlpha(c, (int)(255.0f * alpha));
    }

    public static Color gamma(Color c, double y) {
        double oneOverGamma = 1.0 / y;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        r = (int)(255.0 * (Math.pow((double)r / 255.0, oneOverGamma) + 0.5));
        g = (int)(255.0 * (Math.pow((double)g / 255.0, oneOverGamma) + 0.5));
        b = (int)(255.0 * (Math.pow((double)b / 255.0, oneOverGamma) + 0.5));
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b, c.getAlpha());
    }
}

