/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.Text;
import com.kitfox.svg.Tspan;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.LoaderNode;
import org.simantics.scenegraph.ScenegraphUtils;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.BufferedImage;
import org.simantics.scenegraph.utils.G2DUtils;
import org.simantics.scenegraph.utils.InitValueSupport;
import org.simantics.scenegraph.utils.MipMapBufferedImage;
import org.simantics.scenegraph.utils.MipMapVRamBufferedImage;
import org.simantics.scenegraph.utils.VRamBufferedImage;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.utils.threads.AWTThread;

@ExportableWidget.RasterOutputWidget
public class SVGNode
extends G2DNode
implements InitValueSupport,
LoaderNode {
    private static final long serialVersionUID = 8508750881358776559L;
    protected String data = null;
    protected String defaultData = null;
    protected Point targetSize = null;
    protected Boolean useMipMap = true;
    protected Rectangle2D bounds = null;
    protected List<SVGNodeAssignment> assignments = new ArrayList<SVGNodeAssignment>();
    transient BufferedImage buffer = null;
    transient String documentCache = null;
    transient SVGDiagram diagramCache = null;
    transient String dataHash = null;
    static transient Map<String, WeakReference<BufferedImage>> bufferCache = new HashMap<String, WeakReference<BufferedImage>>();
    static WeakHashMap<String, String> dataCache = new WeakHashMap();
    static WeakHashMap<String, String> digestCache = new WeakHashMap();
    static URL BROKEN_SVG_DATA = SVGNode.class.getResource("broken.svg");
    static URL EMPTY_SVG_DATA = SVGNode.class.getResource("empty.svg");

    @Override
    public void cleanup() {
        this.cleanDiagramCache();
    }

    public void setAssignments(List<SVGNodeAssignment> ass) {
        this.assignments.clear();
        this.assignments.addAll(ass);
    }

    public void cleanDiagramCache() {
        SVGDiagram d = this.diagramCache;
        if (d != null) {
            this.diagramCache = null;
            SVGUniverse univ = SVGCache.getSVGUniverse();
            univ.decRefCountAndClear(d.getXMLBase());
        }
    }

    @INode.PropertySetter(value="SVG")
    @INode.SyncField(value={"data"})
    public void setData(String data) {
        String cached = dataCache.get(data);
        if (cached == null) {
            cached = data;
            dataCache.put(data, data);
        }
        this.data = cached;
        this.defaultData = cached;
    }

    @INode.SyncField(value={"targetSize"})
    public void setTargetSize(Point p) {
        this.targetSize = p;
    }

    @INode.SyncField(value={"targetSize"})
    public void setTargetSize(int x, int y) {
        this.targetSize = new Point(x, y);
    }

    @INode.SyncField(value={"useMipMap"})
    public void useMipMap(Boolean use) {
        this.useMipMap = use;
    }

    @INode.PropertySetter(value="Bounds")
    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.bounds == null) {
            this.parseSVG();
        }
        return this.bounds;
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.data == null) {
            return;
        }
        if (!this.data.equals(this.documentCache) || this.diagramCache == null || this.buffer == null) {
            this.initBuffer(g2d);
        }
        AffineTransform ot = null;
        if (!this.transform.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.transform);
        }
        if (this.buffer != null) {
            this.buffer.paint(g2d);
        }
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String parseSVG() {
        if (this.data == null) {
            return null;
        }
        SVGUniverse univ = SVGCache.getSVGUniverse();
        try {
            Rectangle2D bbox = null;
            SVGUniverse sVGUniverse = univ;
            synchronized (sVGUniverse) {
                if (this.diagramCache != null) {
                    univ.decRefCount(this.diagramCache.getXMLBase());
                    this.diagramCache = null;
                }
                byte[] dataBytes = this.data.getBytes("UTF-8");
                this.dataHash = SVGNode.digest(dataBytes, this.assignments);
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), this.dataHash);
                this.diagramCache = univ.getDiagram(uri, false);
                if (this.diagramCache != null) {
                    univ.incRefCount(this.diagramCache.getXMLBase());
                    if (this.diagramCache.getRoot() == null) {
                        univ.decRefCount(this.diagramCache.getXMLBase());
                        this.diagramCache = univ.getDiagram(univ.loadSVG(BROKEN_SVG_DATA), false);
                        this.dataHash = "broken";
                        univ.incRefCount(this.diagramCache.getXMLBase());
                        bbox = (Rectangle2D)this.diagramCache.getRoot().getBoundingBox().clone();
                    } else {
                        bbox = this.diagramCache.getRoot().getBoundingBox();
                        if (bbox.isEmpty()) {
                            univ.decRefCount(this.diagramCache.getXMLBase());
                            this.diagramCache = univ.getDiagram(univ.loadSVG(EMPTY_SVG_DATA), false);
                            this.dataHash = "empty";
                            univ.incRefCount(this.diagramCache.getXMLBase());
                            bbox = (Rectangle2D)this.diagramCache.getRoot().getBoundingBox().clone();
                        } else {
                            bbox = SVGNode.applyAssignments(this.diagramCache, this.assignments) ? (Rectangle2D)this.diagramCache.getRoot().getBoundingBox().clone() : (Rectangle2D)bbox.clone();
                        }
                    }
                } else {
                    bbox = new Rectangle2D.Double();
                }
            }
            this.documentCache = this.data;
            this.setBounds(bbox);
        }
        catch (SVGException sVGException) {
            this.setBounds(this.diagramCache.getViewRect((Rectangle2D)new Rectangle2D.Double()));
            univ.decRefCount(this.diagramCache.getXMLBase());
            this.diagramCache = null;
        }
        catch (IOException iOException) {
            this.diagramCache = null;
        }
        return this.dataHash;
    }

    private static boolean applyAssignments(SVGDiagram diagram, List<SVGNodeAssignment> assignments) throws SVGException {
        if (assignments.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (SVGNodeAssignment ass : assignments) {
            SVGElement e = diagram.getElement(ass.elementId);
            if (e == null) continue;
            if ("$text".equals(ass.attributeNameOrId)) {
                if (!(e instanceof Tspan)) continue;
                Tspan t = (Tspan)e;
                t.setText(ass.value);
                SVGElement parent = t.getParent();
                if (parent instanceof Text) {
                    ((Text)parent).rebuild();
                }
                changed = true;
                continue;
            }
            e.setAttribute(ass.attributeNameOrId, 2, ass.value);
            changed = true;
        }
        diagram.updateTime(0.0);
        return changed;
    }

    public static Rectangle2D getBounds(String data) {
        return SVGNode.getBounds(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle2D getBounds(String data, List<SVGNodeAssignment> assignments) {
        if (data == null) {
            new Exception("null SVG data").printStackTrace();
            return null;
        }
        SVGDiagram diagramCache = null;
        try {
            SVGUniverse univ;
            byte[] dataBytes = data.getBytes("UTF-8");
            String digest = SVGNode.digest(dataBytes, assignments);
            SVGUniverse sVGUniverse = univ = SVGCache.getSVGUniverse();
            synchronized (sVGUniverse) {
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), digest);
                diagramCache = univ.getDiagram(uri, false);
                if (diagramCache != null) {
                    if (diagramCache.getRoot() == null) {
                        diagramCache = univ.getDiagram(univ.loadSVG(BROKEN_SVG_DATA));
                    } else if (diagramCache.getRoot().getBoundingBox().isEmpty()) {
                        diagramCache = univ.getDiagram(univ.loadSVG(EMPTY_SVG_DATA));
                    }
                }
            }
            Rectangle2D rect = null;
            if (diagramCache != null) {
                SVGRoot root = diagramCache.getRoot();
                Rectangle2D bbox = root.getBoundingBox();
                rect = (Rectangle2D)bbox.clone();
            } else {
                rect = new Rectangle2D.Double();
            }
            return rect;
        }
        catch (SVGException sVGException) {
            return diagramCache.getViewRect((Rectangle2D)new Rectangle2D.Double());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Rectangle2D getRealBounds(String data) {
        return SVGNode.getRealBounds(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle2D getRealBounds(String data, List<SVGNodeAssignment> assignments) {
        if (data == null) {
            new Exception("null SVG data").printStackTrace();
            return null;
        }
        SVGDiagram diagramCache = null;
        try {
            SVGUniverse univ;
            byte[] dataBytes = data.getBytes("UTF-8");
            String digest = SVGNode.digest(dataBytes, assignments);
            SVGUniverse sVGUniverse = univ = SVGCache.getSVGUniverse();
            synchronized (sVGUniverse) {
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), digest);
                diagramCache = univ.getDiagram(uri, false);
                if (diagramCache != null) {
                    SVGRoot root = diagramCache.getRoot();
                    if (root == null) {
                        return new Rectangle2D.Double();
                    }
                    return (Rectangle2D)root.getBoundingBox().clone();
                }
            }
        }
        catch (SVGException sVGException) {
            return diagramCache.getViewRect((Rectangle2D)new Rectangle2D.Double());
        }
        catch (IOException iOException) {}
        return null;
    }

    protected void initBuffer(Graphics2D g2d) {
        if (!this.data.equals(this.documentCache) || this.diagramCache == null) {
            this.dataHash = this.parseSVG();
            if (this.diagramCache == null) {
                System.err.println("UNABLE TO PARSE SVG:\n" + this.data);
                return;
            }
        }
        if (this.buffer != null) {
            this.buffer = null;
        }
        this.diagramCache.setIgnoringClipHeuristic(true);
        if (bufferCache.containsKey(this.dataHash) && bufferCache.get(this.dataHash).get() != null) {
            this.buffer = (BufferedImage)bufferCache.get(this.dataHash).get();
        } else if (this.diagramCache.getViewRect().getWidth() == 0.0 || this.diagramCache.getViewRect().getHeight() == 0.0) {
            this.buffer = null;
        } else if (this.useMipMap.booleanValue()) {
            this.buffer = G2DUtils.isAccelerated(g2d) ? new MipMapVRamBufferedImage(this.diagramCache, this.bounds, this.targetSize) : new MipMapBufferedImage(this.diagramCache, this.bounds, this.targetSize);
            bufferCache.put(this.dataHash, new WeakReference<BufferedImage>(this.buffer));
        } else {
            this.buffer = G2DUtils.isAccelerated(g2d) ? new VRamBufferedImage(this.diagramCache, this.bounds, this.targetSize) : new BufferedImage(this.diagramCache, this.bounds, this.targetSize);
            bufferCache.put(this.dataHash, new WeakReference<BufferedImage>(this.buffer));
        }
    }

    public void setProperty(String field, Object value) {
        if ("data".equals(field)) {
            this.data = (String)value;
        } else if ("z".equals(field)) {
            this.setZIndex((Integer)value);
        } else if ("position".equals(field)) {
            Point point = (Point)value;
            this.setTransform(AffineTransform.getTranslateInstance(point.x, point.y));
        }
    }

    @Override
    public void initValues() {
        this.data = this.defaultData;
        this.dataHash = null;
        this.buffer = null;
    }

    static String digest(byte[] dataBytes, List<SVGNodeAssignment> assignments) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(dataBytes);
            BigInteger number = new BigInteger(1, messageDigest);
            String dataHash = String.valueOf(number.toString(16)) + (assignments != null ? assignments.hashCode() : 0);
            String result = digestCache.get(dataHash);
            if (result == null) {
                result = dataHash;
                digestCache.put(dataHash, dataHash);
            }
            return result;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("MD5 digest must exist.");
        }
    }

    @Override
    public Function1<Object, Boolean> getPropertyFunction(String propertyName) {
        return ScenegraphUtils.getMethodPropertyFunction(AWTThread.getThreadAccess(), this, propertyName);
    }

    @Override
    public <T> T getProperty(String propertyName) {
        return null;
    }

    @Override
    public void setPropertyCallback(Function2<String, Object, Boolean> callback) {
    }

    public void synchronizeDocument(String document) {
        this.setData(document);
    }

    public void synchronizeTransform(double[] data) {
        this.setTransform(new AffineTransform(data));
    }

    public static class SVGNodeAssignment {
        public String elementId;
        public String attributeNameOrId;
        public String value;

        public SVGNodeAssignment(String elementId, String attributeNameOrId, String value) {
            this.elementId = elementId;
            this.attributeNameOrId = attributeNameOrId;
            this.value = value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.attributeNameOrId == null ? 0 : this.attributeNameOrId.hashCode());
            result = 31 * result + (this.elementId == null ? 0 : this.elementId.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SVGNodeAssignment other = (SVGNodeAssignment)obj;
            if (this.attributeNameOrId == null ? other.attributeNameOrId != null : !this.attributeNameOrId.equals(other.attributeNameOrId)) {
                return false;
            }
            if (this.elementId == null ? other.elementId != null : !this.elementId.equals(other.elementId)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

