/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events.adapter;

import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;

public abstract class AbstractEventAdapter {
    protected final IEventHandler delegator;
    protected final IEventQueue queue;
    protected final Object sender;

    public AbstractEventAdapter(Object sender, IEventHandler delegator) {
        if (delegator == null) {
            throw new IllegalArgumentException("null delegator");
        }
        this.delegator = delegator;
        this.queue = null;
        this.sender = sender;
    }

    public AbstractEventAdapter(Object sender, IEventQueue queue) {
        if (queue == null) {
            throw new IllegalArgumentException("null event queue");
        }
        this.delegator = null;
        this.queue = queue;
        this.sender = sender;
    }

    protected void handleEvent(Event e) {
        if (this.queue != null) {
            this.queue.queueEvent(e);
        } else if (EventTypes.passes(this.delegator, e)) {
            this.delegator.handleEvent(e);
        }
    }
}

