/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt.client.impl;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.views.swt.client.base.SingleSWTViewNode;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.language.MediaWikiLanguage;

public class SWTWikiBrowser
extends SingleSWTViewNode<Browser> {
    private static final long serialVersionUID = 5826022972081217837L;
    public String document;
    public Variable variable;
    public Function1<String, Boolean> navigate;
    public Variable edited;
    private Tuple lastAppliedParametrization;

    @Override
    public void reset() {
        super.reset();
        this.lastAppliedParametrization = null;
    }

    @Override
    public void createControls(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.control = new Browser(parent, this.style);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.control);
        this.setProperties();
    }

    public void synchronizeVariable(Variable variable) {
    }

    public void synchronizeEdited(Variable edited) {
        this.propertyCallback.apply((Object)"edited", (Object)edited);
    }

    public void synchronizeDocument(final String document) {
        if (document != null) {
            final Variable variable = this.variable;
            if (variable == null) {
                return;
            }
            Tuple checkParam = new Tuple(new Object[]{document, variable});
            if (checkParam.equals((Object)this.lastAppliedParametrization)) {
                return;
            }
            this.lastAppliedParametrization = checkParam;
            try {
                String markup = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        return SimanticsDialect.INSTANCE.apply(graph, variable, document);
                    }
                });
                MarkupParser markupParser = new MarkupParser();
                MediaWikiLanguage language = new MediaWikiLanguage();
                markupParser.setMarkupLanguage((MarkupLanguage)language);
                String htmlContent = markupParser.parseToHtml(markup);
                if (htmlContent == null) {
                    return;
                }
                Browser control = (Browser)this.control;
                if (control == null) {
                    return;
                }
                control.setText(htmlContent);
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
    }
}

