/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.container.DataFormatException;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.QueryMemoryWatcher;
import org.simantics.db.common.primitiverequest.IsInstanceOf;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.common.utils.VersionInfo;
import org.simantics.db.common.utils.VersionInfoRequest;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.adapter.impl.ImportAdvisorFactory;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.request.ActivateModel;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.db.layer0.request.IsLinkedTo;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.DraftStatusBean;
import org.simantics.db.layer0.util.ExternalDownloadBean;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.graph.db.StreamingTransferableGraphFileReader;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.issues.common.IssueSourceUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.CreateSharedOntologyDialog;
import org.simantics.modeling.CreateVersionDialog;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.VariableStructuralContext;
import org.simantics.modeling.adapters.ChangeInformation;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.operation.Layer0X;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.scenegraph.profile.ProfileUtils;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.scl.StructuralComponent;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.dialogs.ListDialog;

public class ModelingUtils {
    private ReadGraph g;
    private WriteGraph wg;
    public Layer0 b;
    private StructuralResource2 sr;
    private DiagramResource dr;
    public ModelingResources mr;
    public SimulationResource SIMU;
    public static final String DRAWING_TEMPLATE_FORMAT = "drawingTemplate";
    public static final String DRAWING_TEMPLATE_FORMAT_V1 = "drawingTemplate:1";
    public static final String DRAWING_TEMPLATE_FORMAT_V2 = "drawingTemplate:2";
    public static char COMPOSITE_SEPARATOR_CHAR = (char)35;
    public static String COMPOSITE_SEPARATOR = String.valueOf(COMPOSITE_SEPARATOR_CHAR);

    public ModelingUtils(WriteGraph g) {
        this.wg = g;
        this.g = g;
        this.b = Layer0.getInstance((ReadGraph)g);
        this.sr = StructuralResource2.getInstance((ReadGraph)g);
        this.dr = DiagramResource.getInstance((ReadGraph)g);
        this.mr = ModelingResources.getInstance((ReadGraph)g);
        this.SIMU = SimulationResource.getInstance((ReadGraph)g);
    }

    @Deprecated
    public Resource createSymbol2(String name) throws DatabaseException {
        return this.createSymbol2(name, this.dr.Composite);
    }

    @Deprecated
    public Resource createSymbol2(String name, Resource type) throws DatabaseException {
        Double d;
        G2DResource g2d = G2DResource.getInstance((ReadGraph)this.g);
        Double boxDimension = 6.0;
        Collection grid = this.g.getAssertedStatements(type, this.dr.HasGridSize);
        if (grid.size() == 1 && (d = (Double)this.g.getPossibleValue(((Statement)grid.iterator().next()).getObject(), (Binding)Bindings.DOUBLE)) != null) {
            boxDimension = 2.0 * d;
        }
        Resource element = GraphUtils.create((WriteGraph)this.wg, (Object[])new Object[]{this.b.InstanceOf, this.dr.SVGElement, g2d.HasSVGDocument, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><svg xmlns=\"http://www.w3.org/2000/svg\" overflow=\"visible\" version=\"1.1\"><rect x=\"-" + boxDimension + "\" y=\"-" + boxDimension + "\" width=\"" + 2.0 * boxDimension + "\" height=\"" + 2.0 * boxDimension + "\" fill=\"none\" stroke=\"rgb(0,0,0)\" stroke-width=\"0.1\"/>" + "</svg>"});
        Resource orderedSet = OrderedSetUtils.create((WriteOnlyGraph)this.wg, (Resource)type, (Resource[])new Resource[]{element});
        Resource result = GraphUtils.create((WriteGraph)this.wg, (Object[])new Object[]{this.b.HasName, name, this.b.HasLabel, "", this.sr.IsDefinedBy, orderedSet});
        this.wg.claim(result, this.b.ConsistsOf, orderedSet);
        this.wg.claimLiteral(orderedSet, this.b.HasName, (Object)"__DIAGRAM__", (Binding)Bindings.STRING);
        AddElement.claimFreshElementName((WriteGraph)this.wg, (Resource)orderedSet, (Resource)element);
        this.wg.claim(orderedSet, this.b.ConsistsOf, element);
        this.wg.claim(result, this.b.Inherits, null, this.dr.DefinedElement);
        return result;
    }

    public static Collection<Resource> getElementCorrespondendences(ReadGraph g, Resource element) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        if (g.isInstanceOf(element, dr.Connection)) {
            Resource mappedComponent = g.getPossibleObject(element, mr.ElementToComponent);
            if (mappedComponent != null) {
                return Collections.singletonList(mappedComponent);
            }
            Resource mappedConnection = g.getPossibleObject(element, mr.DiagramConnectionToConnection);
            if (mappedConnection == null) {
                return Collections.emptyList();
            }
            ArrayList<Resource> result = new ArrayList<Resource>();
            Set relatedMappedConnections = StructuralUtils.getRelatedConnections((RequestProcessor)g, (Resource)mappedConnection);
            for (Resource relatedMappedConnection : relatedMappedConnections) {
                for (Resource relatedConnection : g.getObjects(relatedMappedConnection, mr.ConnectionToDiagramConnection)) {
                    result.addAll(g.getObjects(relatedConnection, mr.ElementToComponent));
                }
            }
            return result;
        }
        return g.getObjects(element, mr.ElementToComponent);
    }

    public static Resource getPossibleElement(ReadGraph g, Resource component) throws DatabaseException {
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        return g.getPossibleObject(component, mr.ComponentToElement);
    }

    public static Resource getPossibleElementCorrespondendence(ReadGraph g, Resource element) throws DatabaseException {
        Collection<Resource> corrs = ModelingUtils.getElementCorrespondendences(g, element);
        if (corrs.size() != 1) {
            return null;
        }
        return corrs.iterator().next();
    }

    public static Resource getSingleElementCorrespondendence(ReadGraph g, Resource element) throws DatabaseException {
        Collection<Resource> corrs = ModelingUtils.getElementCorrespondendences(g, element);
        if (corrs.size() != 1) {
            throw new DatabaseException("Expected 1 element correspondence, got " + corrs.size());
        }
        return corrs.iterator().next();
    }

    public static Resource createExperiment(WriteGraph graph, Resource model) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource experiment = graph.newResource();
        graph.claim(experiment, L0.InstanceOf, SIMU.Experiment);
        graph.claimLiteral(experiment, L0.HasName, (Object)"Experiment");
        graph.claim(model, L0.ConsistsOf, experiment);
        return experiment;
    }

    public static Resource createModel(WriteGraph graph, Resource type) throws DatabaseException {
        return ModelingUtils.createModel(graph, type, Simantics.getProjectResource(), null);
    }

    public static Resource createModel(WriteGraph graph, Resource type, String name) throws DatabaseException {
        return ModelingUtils.createModel(graph, type, Simantics.getProjectResource(), name);
    }

    public static Resource createModel(WriteGraph graph, Resource type, final Resource target, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        if (name == null) {
            name = NameUtils.findFreshName((ReadGraph)graph, (String)"Model", (Resource)target, (Resource)L0.ConsistsOf, (String)"%s%d");
        }
        final Resource model = graph.newResource();
        graph.newClusterSet(model);
        graph.claim(model, L0.InstanceOf, null, type);
        graph.claimLiteral(model, L0.HasName, (Object)name);
        graph.claim(target, L0.ConsistsOf, model);
        Resource configurationType = graph.getPossibleObject(model, MOD.StructuralModel_HasConfigurationType);
        if (configurationType == null) {
            configurationType = STR.Composite;
        }
        Resource configuration = graph.newResource();
        graph.claimLiteral(configuration, L0.HasName, (Object)"Configuration", (Binding)Bindings.STRING);
        graph.claim(configuration, L0.InstanceOf, null, configurationType);
        graph.claim(model, L0.ConsistsOf, configuration);
        graph.claim(model, SIMU.HasConfiguration, configuration);
        Resource joinClusterSet = graph.newResource();
        graph.newClusterSet(joinClusterSet);
        graph.claim(joinClusterSet, L0.InstanceOf, L0.ClusterSet);
        graph.claim(model, STR.HasJoinClusterSet, joinClusterSet);
        ModelingUtils.linkOntologyDependenciesToModel(graph, model, target);
        Resource ontology = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(type));
        if (ontology != null) {
            graph.claim(model, L0.IsLinkedTo, ontology);
        }
        VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        graph.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("activations")){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                Collection actives = (Collection)graph.syncRequest((Read)new ActiveModels(target));
                if (actives.isEmpty()) {
                    graph.claim(model, L0X.IsActivatedBy, target);
                }
            }
        });
        return model;
    }

    public static void linkOntologyDependenciesToModel(WriteGraph graph, Resource model, Resource target) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        for (Resource dep : graph.getObjects(target, L0.IsLinkedTo)) {
            if (!graph.isInstanceOf(dep, PROJ.NamespaceRequirement)) continue;
            for (Resource req : graph.getObjects(dep, PROJ.RequiresNamespace)) {
                Resource ns;
                String uri = (String)graph.getPossibleValue(req, (Binding)Bindings.STRING);
                if (uri == null || (ns = graph.getResource(uri)) == null) continue;
                graph.claim(model, L0.IsLinkedTo, null, ns);
            }
        }
    }

    public static void addSCLMainToModel(WriteGraph graph, Resource model) throws DatabaseException {
        ModelingUtils.addSCLMainToModel(graph, model, "SCLMain", "include \"Simantics/All\"\n");
    }

    public static void addSCLMainToModel(WriteGraph graph, Resource model, String name, String contents) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource sclmain = GraphUtils.create2((WriteGraph)graph, (Resource)L0.SCLModule, (Object[])new Object[]{L0.PartOf, model, L0.HasName, name});
        graph.claimLiteral(sclmain, L0.SCLModule_definition, (Object)contents, (Binding)Bindings.STRING);
    }

    public static Resource createLocalLibrary(WriteGraph graph, Resource container, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource library = graph.newResource();
        graph.claim(library, L0.InstanceOf, null, L0.Library);
        graph.addLiteral(library, L0.HasName, L0.NameOf, (Object)"Library", (Binding)Bindings.STRING);
        if (container != null) {
            graph.claim(container, L0.ConsistsOf, L0.PartOf, library);
            graph.claim(container, MOD.HasLocalLibrary, MOD.IsLocalLibraryOf, library);
        }
        return library;
    }

    public static void importModel(String fileName) {
        Resource project = (Resource)SimanticsUI.getProject().get();
        try {
            StreamingTransferableGraphFileReader importer = new StreamingTransferableGraphFileReader(new File(fileName));
            TransferableGraphSource tg = importer.readTG();
            DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(project){

                public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {
                }

                public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
                    this.library = Simantics.getProjectResource();
                    String newName = this.newName(graph, this.library, root.name);
                    this.nameMappings.put(root.name, newName);
                    return null;
                }
            };
            TransferableGraphs.importGraph1((Session)Simantics.getSession(), (TransferableGraphSource)tg, (IImportAdvisor)advisor);
        }
        catch (MissingDependencyException e) {
            final Set missingURIs = e.getMissingURIs();
            Display display = Display.getCurrent();
            if (display != null) {
                class ErrorMessageDialog
                extends MessageDialog {
                    private final /* synthetic */ Set val$missingURIs;

                    public ErrorMessageDialog(Shell shell, Set set) {
                        this.val$missingURIs = set;
                        super(shell, "Unsatisfied dependencies", null, "The following dependencies were missing. Please import the dependencies and try again.", 1, new String[]{"Continue"}, 0);
                    }

                    protected Control createCustomArea(Composite composite) {
                        GridLayoutFactory.fillDefaults().applyTo(composite);
                        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite, 2056);
                        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)list);
                        for (String s : this.val$missingURIs) {
                            list.add(s);
                        }
                        return composite;
                    }
                }
                ErrorMessageDialog md = new ErrorMessageDialog(display.getActiveShell(), missingURIs);
                md.open();
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getCurrent().getActiveShell();
                        ErrorMessageDialog md = new ErrorMessageDialog(shell, missingURIs);
                        md.open();
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public static void primeVirtualGraphs() {
        VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
        support.getWorkspacePersistent("activations");
        support.getWorkspacePersistent("experiments");
        support.getWorkspacePersistent("issues");
        support.getWorkspacePersistent("preferences");
    }

    public static Resource createProfileEntry(WriteGraph graph, String name, Resource style, Resource group) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource entry = graph.newResource();
        graph.claim(entry, L0.InstanceOf, null, DIA.GroupStyleProfileEntry);
        graph.claimLiteral(entry, L0.HasName, (Object)name);
        graph.claimLiteral(entry, L0.HasLabel, (Object)name);
        graph.claim(entry, DIA.ProfileEntry_HasStyle, style);
        graph.claim(entry, DIA.ProfileEntry_HasGroup, group);
        return entry;
    }

    public static Resource createProfile(WriteGraph graph, String profileName, Resource ... entries) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource list = ListUtils.create((WriteGraph)graph, (Resource)DIA.Profile, (Resource[])entries);
        Resource profile = graph.newResource();
        graph.claim(profile, L0.InstanceOf, null, DIA.Profile);
        graph.claimLiteral(profile, L0.HasName, (Object)profileName);
        graph.claim(profile, DIA.HasEntries, null, list);
        return profile;
    }

    public static Resource createProfile(WriteGraph graph, String profileName, Collection<Resource> entries) throws DatabaseException {
        return ModelingUtils.createProfile(graph, profileName, entries.toArray(new Resource[entries.size()]));
    }

    public static Resource createToplevelProfile(WriteGraph graph, Resource model, String name, Resource ... profiles) throws DatabaseException {
        Resource work = ModelingUtils.createProfile(graph, name, profiles);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        graph.deny(model, DIA.HasActiveProfile);
        graph.claim(model, DIA.HasActiveProfile, work);
        graph.claim(model, L0.ConsistsOf, L0.PartOf, work);
        return work;
    }

    public static Resource createToplevelProfile(WriteGraph graph, Resource model, String name, Collection<Resource> profiles) throws DatabaseException {
        return ModelingUtils.createToplevelProfile(graph, model, name, profiles.toArray(new Resource[profiles.size()]));
    }

    public static void activateProfileEntries(WriteGraph graph, final Resource profile, final Resource ... entries) {
        VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        graph.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("profiles")){

            public void perform(WriteGraph graph) throws DatabaseException {
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                Resource[] resourceArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource entry = resourceArray[n2];
                    graph.claim(profile, SIMU.IsActive, entry);
                    ++n2;
                }
            }
        });
    }

    public static void activateProfileEntries(WriteGraph graph, Resource profile, Collection<Resource> entries) {
        ModelingUtils.activateProfileEntries(graph, profile, entries.toArray(new Resource[entries.size()]));
    }

    public static void toggleProfileGroup(WriteGraph graph, Resource runtimeProfile, String groupName, boolean enabled) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource group : ProfileUtils.getProfileChildren((ReadGraph)graph, (Resource)runtimeProfile)) {
            String name = (String)graph.getRelatedValue2(group, L0.HasName);
            if (!name.equals(groupName)) continue;
            ModelingUtils.toggleProfileGroup(graph, runtimeProfile, group, enabled);
            return;
        }
    }

    public static void toggleProfileGroup(WriteGraph graph, Resource runtimeProfile, Resource group, boolean enabled) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(group, DIA.Profile)) {
            for (Resource child : ProfileUtils.getProfileChildren((ReadGraph)graph, (Resource)group)) {
                ModelingUtils.toggleProfileGroup(graph, runtimeProfile, child, enabled);
            }
        } else if (graph.isInstanceOf(group, DIA.ProfileEntry)) {
            if (enabled) {
                graph.claim(runtimeProfile, SimulationResource.getInstance((ReadGraph)graph).IsActive, null, group);
            } else {
                graph.denyStatement(runtimeProfile, SimulationResource.getInstance((ReadGraph)graph).IsActive, group);
            }
        }
    }

    public static void untrackDependencies() {
        ModelingUtils.untrackDependencies((RequestProcessor)Simantics.getSession());
    }

    public static void untrackDependencies(RequestProcessor processor) {
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    GenericRelationIndex index = (GenericRelationIndex)graph.adapt(L0X.DependenciesRelation, GenericRelationIndex.class);
                    index.untrack((RequestProcessor)graph.getSession(), graph.getRootLibrary());
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public static void trackDependencies() {
        ModelingUtils.trackDependencies((RequestProcessor)Simantics.getSession());
    }

    public static void trackDependencies(RequestProcessor processor) {
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    GenericRelationIndex index = (GenericRelationIndex)graph.adapt(L0X.DependenciesRelation, GenericRelationIndex.class);
                    index.trackAndIndex((RequestProcessor)graph.getSession(), graph.getRootLibrary());
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public static void removeIndex(WriteGraph graph, Resource model) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        IndexedRelations ir = (IndexedRelations)graph.getService(IndexedRelations.class);
        ir.reset(null, (RequestProcessor)graph, L0X.DependenciesRelation, model);
    }

    public static void resetIssueSources(WriteGraph graph, Resource model) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        for (Resource source : (Collection)graph.sync((ReadInterface)new ObjectsWithType(model, L0.ConsistsOf, ISSUE.ContinuousIssueSource))) {
            IssueSourceUtils.update((WriteGraph)graph, (Resource)source);
        }
    }

    public static void copyAnnotationTypes(WriteGraph graph, Resource sourceModel, Resource targetModel) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(ANNO.AnnotationType, Instances.class);
        Resource library = graph.getPossibleObject(targetModel, ANNO.HasAnnotationTypeRoot);
        if (library == null) {
            library = graph.newResource();
            graph.claim(library, L0.InstanceOf, null, ANNO.AnnotationTypeLibrary);
            graph.claimLiteral(library, L0.HasName, L0.NameOf, L0.String, (Object)"Annotation types", (Binding)Bindings.STRING);
            graph.claim(library, L0.PartOf, L0.ConsistsOf, targetModel);
            graph.claim(targetModel, ANNO.HasAnnotationTypeRoot, library);
        }
        for (Resource type : query.find((ReadGraph)graph, sourceModel)) {
            String name = (String)graph.getRelatedValue(type, L0.HasName);
            Resource existing = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)library, (String)name);
            if (existing != null) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)existing);
            }
            Layer0Utils.copyTo((WriteGraph)graph, (Resource)library, (Resource)type);
        }
    }

    public static void deleteIndex(WriteGraph graph, Resource model) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        IndexedRelations ir = (IndexedRelations)graph.getService(IndexedRelations.class);
        ir.reset(null, (RequestProcessor)graph, L0X.DependenciesRelation, model);
    }

    public static void disableDependencies(WriteGraph graph, Resource dummy) {
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
    }

    public static void releaseMemory(WriteGraph graph) {
        QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
        ClusterControl cc = (ClusterControl)graph.getService(ClusterControl.class);
        cc.flushClusters();
        qc.flush((ReadGraph)graph);
    }

    public static List<Resource> filterByIndexRoot(ReadGraph graph, Resource indexRoot, List<Resource> resources) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        for (Resource r : resources) {
            Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r));
            if (!indexRoot.equals(root)) continue;
            result.add(r);
        }
        return result;
    }

    public static List<Resource> searchByTypeShallow(ReadGraph graph, Resource model, Resource type) throws DatabaseException {
        return ModelingUtils.filterByIndexRoot(graph, model, ModelingUtils.searchByType(graph, model, type));
    }

    public static List<Resource> searchByType(ReadGraph graph, Resource model, Resource type) throws DatabaseException {
        Instances query = (Instances)graph.adapt(type, Instances.class);
        return Layer0Utils.sortByCluster((ReadGraph)graph, (Collection)query.find(graph, model));
    }

    public static List<Resource> searchByGUID(ReadGraph graph, Resource indexRoot, GUID guid) throws DatabaseException {
        return ModelingUtils.searchByGUID(graph, indexRoot, guid.indexString());
    }

    public static List<Resource> searchByGUID(ReadGraph graph, Resource indexRoot, String indexString) throws DatabaseException {
        return ModelingUtils.searchByQueryShallow(graph, indexRoot, "GUID:" + indexString);
    }

    public static List<Resource> searchByQueryShallow(ReadGraph graph, Resource model, String query) throws DatabaseException {
        return ModelingUtils.filterByIndexRoot(graph, model, ModelingUtils.searchByQuery(graph, model, query));
    }

    public static List<Resource> searchByQuery(ReadGraph graph, Resource model, String query) throws DatabaseException {
        Instances instances = (Instances)graph.adapt(Layer0.getInstance((ReadGraph)graph).Entity, Instances.class);
        Collection queryResult = instances.find(graph, model, query);
        return Layer0Utils.sortByCluster((ReadGraph)graph, (Collection)queryResult);
    }

    public static List<Resource> searchByTypeAndFilter(ReadGraph graph, Resource model, Resource type, Function1<Resource, Boolean> filter) throws DatabaseException {
        Instances query = (Instances)graph.adapt(type, Instances.class);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : query.find(graph, model)) {
            if (!((Boolean)filter.apply((Object)r)).booleanValue()) continue;
            result.add(r);
        }
        return result;
    }

    public static List<Triple<Resource, Resource, String>> getIndexEntries(ReadGraph graph, Resource model, String filter) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List<Resource> entries = ModelingUtils.searchByQuery(graph, model, filter);
        ArrayList<Triple<Resource, Resource, String>> listOfTriples = new ArrayList<Triple<Resource, Resource, String>>();
        for (Resource entry : entries) {
            Resource type = graph.getPossibleObject(entry, L0.InstanceOf);
            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)entry);
            listOfTriples.add((Triple<Resource, Resource, String>)new Triple((Object)entry, (Object)type, (Object)name));
        }
        return listOfTriples;
    }

    public static String listIndexEntries(ReadGraph graph, Resource model, String filter) throws DatabaseException {
        List<Triple<Resource, Resource, String>> listOfTriples = ModelingUtils.getIndexEntries(graph, model, filter);
        StringBuilder sb = new StringBuilder();
        sb.append("== LISTING INDEX ENTRIES OF INDEX: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)model) + ". AMOUNT OF ENTRIES: " + listOfTriples.size() + " ==\n");
        for (Triple<Resource, Resource, String> entry : listOfTriples) {
            String instanceOf = NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)entry.second));
            sb.append("Name: " + (String)entry.third + " instanceOf: " + instanceOf + " Resource: " + ((Resource)entry.first).toString() + "\n");
        }
        return sb.toString();
    }

    public static List<Resource> searchByTypeAndName(ReadGraph graph, Resource model, Resource type, String name) throws DatabaseException {
        Instances query = (Instances)graph.adapt(type, Instances.class);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : query.findByName(graph, model, name)) {
            if (!graph.isInstanceOf(r, type)) continue;
            result.add(r);
        }
        return result;
    }

    public static List<Resource> searchByTypeAndNameShallow(ReadGraph graph, Resource model, Resource type, String name) throws DatabaseException {
        return ModelingUtils.filterByIndexRoot(graph, model, ModelingUtils.searchByTypeAndName(graph, model, type, name));
    }

    public static Resource copyPossibleAnnotation(WriteGraph graph, Resource sourceContainer, Resource targetContainer, Resource annotationProperty) throws DatabaseException {
        return ModelingUtils.copyPossibleAnnotation2(graph, sourceContainer, targetContainer, annotationProperty, null);
    }

    public static List<String> getPossibleNamePath(ReadGraph graph, Resource resource) throws DatabaseException {
        return ModelingUtils.getPossibleNamePath(graph, resource, null);
    }

    private static List<String> getPossibleNamePath(ReadGraph graph, Resource resource, List<String> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING);
        if (name == null) {
            return null;
        }
        if (result == null) {
            result = new ArrayList<String>();
        }
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(resource, SIMU.Model)) {
            return result;
        }
        Resource parent = graph.getPossibleObject(resource, L0.PartOf);
        if (parent == null) {
            return null;
        }
        ModelingUtils.getPossibleNamePath(graph, parent, result);
        result.add(name);
        return result;
    }

    public static Resource claimLibraryPath(WriteGraph graph, Resource resource, List<String> path) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        int i = 0;
        while (i < path.size() - 1) {
            String p = path.get(i);
            Resource child = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)resource, (String)p);
            if (child == null) {
                child = graph.newResource();
                graph.claim(child, L0.InstanceOf, L0.Library);
                graph.addLiteral(child, L0.HasName, L0.NameOf, L0.String, (Object)p, (Binding)Bindings.STRING);
                graph.claim(resource, L0.ConsistsOf, L0.PartOf, child);
            }
            resource = child;
            ++i;
        }
        return resource;
    }

    public static Resource copyPossibleAnnotation2(WriteGraph graph, Resource sourceContainer, Resource targetContainer, Resource annotationProperty, Resource entryType) throws DatabaseException {
        Resource sourceValue;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource targetValue = graph.getPossibleObject(targetContainer, annotationProperty);
        if (targetValue != null) {
            if (!graph.hasStatement(targetValue, L0.PartOf)) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)targetValue);
            }
            graph.deny(targetContainer, annotationProperty);
        }
        if ((sourceValue = graph.getPossibleObject(sourceContainer, annotationProperty)) == null) {
            return null;
        }
        List<String> sourceValuePath = ModelingUtils.getPossibleNamePath((ReadGraph)graph, sourceValue);
        if (sourceValuePath != null) {
            Resource targetModel = (Resource)graph.sync((ReadInterface)new PossibleModel(targetContainer));
            if (targetModel == null) {
                throw new DatabaseException("No target model found for " + targetContainer);
            }
            Resource library = ModelingUtils.claimLibraryPath(graph, targetModel, sourceValuePath);
            Resource existing = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)library, (String)sourceValuePath.get(sourceValuePath.size() - 1));
            if (existing == null) {
                existing = ModelingUtils.doCopyPossibleAnnotation2(graph, sourceContainer, targetContainer, annotationProperty, entryType);
                graph.claim(library, L0.ConsistsOf, L0.PartOf, existing);
            }
            graph.claim(targetContainer, annotationProperty, existing);
            return existing;
        }
        return ModelingUtils.doCopyPossibleAnnotation2(graph, sourceContainer, targetContainer, annotationProperty, entryType);
    }

    private static Resource doCopyPossibleAnnotation2(WriteGraph graph, Resource sourceContainer, Resource targetContainer, Resource annotationProperty, Resource entryType) throws DatabaseException {
        Resource sourceValue = graph.getPossibleObject(sourceContainer, annotationProperty);
        if (sourceValue == null) {
            return null;
        }
        Resource targetValue = ModelingUtils.createAnnotation(graph, targetContainer, annotationProperty, sourceValue);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (entryType != null) {
            AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
            for (Resource entry : graph.getObjects(sourceValue, ANNO.Annotation_HasEntry)) {
                String name = (String)graph.getRelatedValue(entry, L0.HasName, (Binding)Bindings.STRING);
                List<String> entryPath = ModelingUtils.getPossibleNamePath((ReadGraph)graph, entry);
                if (entryPath != null) {
                    Resource targetModel = (Resource)graph.sync((ReadInterface)new PossibleModel(targetContainer));
                    if (targetModel == null) {
                        throw new DatabaseException("No target model found for " + targetContainer);
                    }
                    Resource library = ModelingUtils.claimLibraryPath(graph, targetModel, entryPath);
                    Resource existing = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)library, (String)entryPath.get(entryPath.size() - 1));
                    if (existing == null) {
                        existing = ModelingUtils.createTypedAnnotation(graph, null, null, entry, entryType, name);
                        graph.claim(library, L0.ConsistsOf, L0.PartOf, existing);
                    }
                    graph.claim(targetValue, ANNO.Annotation_HasEntry, existing);
                    continue;
                }
                Resource result = ModelingUtils.createTypedAnnotation(graph, null, null, entry, entryType, name);
                graph.claim(targetValue, ANNO.Annotation_HasEntry, result);
            }
        }
        return targetValue;
    }

    public static Resource createAnnotation(WriteGraph graph, Resource container, Resource property, Resource sourceAnnotation) throws DatabaseException {
        return ModelingUtils.createAnnotation(graph, container, property, sourceAnnotation, null);
    }

    public static Resource createAnnotation(WriteGraph graph, Resource container, Resource property, Resource sourceAnnotation, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource annotationType = graph.getSingleObject(property, L0.HasRange);
        if (annotationType == null) {
            return null;
        }
        return ModelingUtils.createTypedAnnotation(graph, container, property, sourceAnnotation, annotationType, name);
    }

    public static Resource createTypedAnnotation(WriteGraph graph, Resource container, Resource property, Resource sourceAnnotation, Resource annotationType) throws DatabaseException {
        return ModelingUtils.createTypedAnnotation(graph, container, property, sourceAnnotation, annotationType, null);
    }

    public static Resource createTypedAnnotation(WriteGraph graph, Resource container, Resource property, Resource sourceAnnotation, Resource annotationType, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource anno = graph.newResource();
        graph.claim(anno, L0.InstanceOf, null, annotationType);
        if (name != null) {
            graph.addLiteral(anno, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        }
        if (sourceAnnotation != null) {
            String sourceName;
            if (name == null && (sourceName = (String)graph.getPossibleRelatedValue(sourceAnnotation, L0.HasName, (Binding)Bindings.STRING)) != null) {
                graph.addLiteral(anno, L0.HasName, L0.NameOf, L0.String, (Object)sourceName, (Binding)Bindings.STRING);
            }
            Resource sourceType = graph.getSingleType(sourceAnnotation);
            List<AnnotationMap> am = ModelingUtils.getAnnotationMap((ReadGraph)graph, annotationType, sourceType);
            for (AnnotationMap a : am) {
                Object value;
                Resource object = graph.getSingleObject(sourceAnnotation, a.sourcePredicate);
                Set objectTypes = graph.getTypes(object);
                if (!objectTypes.contains(L0.Literal) || ObjectUtils.objectEquals((Object)(value = graph.getValue(object, a.defaultValueBinding)), (Object)a.defaultValue)) continue;
                graph.addLiteral(anno, a.annotationPredicate, a.annotationPredicateInverse, a.defaultValueType, value, a.defaultValueBinding);
            }
        }
        if (container != null && property != null) {
            graph.claim(container, property, anno);
        }
        return anno;
    }

    public static List<AnnotationMap> getAnnotationMap(ReadGraph graph, Resource annotationType, Resource sourceType) throws DatabaseException {
        return (List)graph.syncRequest((Read)new AnnotationMapRequest(annotationType, sourceType), (Listener)TransientCacheListener.instance());
    }

    public static Resource importDrawingTemplate(final Resource model, final File file) throws IOException, SerializationException, DatabaseException, TransferableGraphException {
        try {
            Resource library = (Resource)Simantics.sync((WriteInterface)new WriteResultRequest<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    Resource existing;
                    String name;
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Template2dResource TEMPLATE = Template2dResource.getInstance((ReadGraph)graph);
                    Resource root = graph.getPossibleObject(model, TEMPLATE.HasDrawingTemplateRoot);
                    if (root == null) {
                        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
                        root = graph.newResource();
                        graph.claim(root, L0.InstanceOf, null, TEMPLATE2D.DrawingTemplateLibrary);
                        graph.claim(root, L0.InstanceOf, null, TEMPLATE2D.DrawingTemplateLibraryUI);
                        graph.claimLiteral(root, L0.HasName, L0.NameOf, L0.String, (Object)"Diagram Templates", (Binding)Bindings.STRING);
                        graph.claim(root, L0.PartOf, L0.ConsistsOf, model);
                        graph.claim(model, TEMPLATE2D.HasDrawingTemplateRoot, root);
                    }
                    if ((name = new Path(file.getAbsolutePath()).removeFileExtension().lastSegment()) != null && (existing = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)root, (String)name)) != null) {
                        graph.deny(root, L0.ConsistsOf, existing);
                    }
                    return root;
                }
            });
            final DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(library);
            try {
                HashMap<String, 8> handlers = new HashMap<String, 8>();
                FormatHandler<Object> handler = new FormatHandler<Object>(){

                    public Binding getBinding() {
                        return TransferableGraph1.BINDING;
                    }

                    public Object process(DataContainer container) throws Exception {
                        TransferableGraphs.importGraph1((Session)Simantics.getSession(), (TransferableGraph1)((TransferableGraph1)container.content.getValue()), (IImportAdvisor)advisor, null);
                        return null;
                    }
                };
                handlers.put(DRAWING_TEMPLATE_FORMAT_V1, handler);
                handlers.put(DRAWING_TEMPLATE_FORMAT_V2, handler);
                try {
                    DataContainers.readFile((File)file, handlers);
                }
                catch (DataFormatException e) {
                    throw new IOException(e);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            catch (IOException iOException) {}
            return advisor.getRoot();
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)"Unexpected exception while importing diagram template.", (Throwable)t);
            return null;
        }
    }

    public static Collection<Variable> getMappedVariables(ReadGraph graph, Variable source) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        Resource represents = source.getPossibleRepresents(graph);
        if (represents == null) {
            return Collections.emptyList();
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource r : ModelingUtils.getElementCorrespondendences(graph, represents)) {
            result.add(Variables.getVariable((ReadGraph)graph, (Resource)r));
        }
        for (Resource r : graph.getObjects(represents, MOD.ComponentToElement)) {
            result.add(Variables.getVariable((ReadGraph)graph, (Resource)r));
        }
        for (Resource r : graph.getObjects(represents, MOD.DiagramToComposite)) {
            result.add(Variables.getVariable((ReadGraph)graph, (Resource)r));
        }
        for (Resource r : graph.getObjects(represents, MOD.CompositeToDiagram)) {
            result.add(Variables.getVariable((ReadGraph)graph, (Resource)r));
        }
        return result;
    }

    public static Resource getPossibleModel(ReadGraph graph, Resource resource) throws DatabaseException {
        PossibleModel pm = new PossibleModel(resource);
        Resource model = pm.perform(graph);
        return model;
    }

    public static Resource possibleIndexRoot(ReadGraph graph, Resource resource) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
    }

    public static Object getMonitorValue(StructuralComponent _variable, ReadGraph graph, String path) throws DatabaseException {
        Variable variable = ((VariableStructuralContext)_variable).variable;
        Variable var = variable.browse(graph, path);
        return var.getValue(graph);
    }

    public static void createSharedOntologyWithUI(ReadGraph graph, Variable variable, Resource baseType) throws DatabaseException {
        ModelingUtils.createSharedOntologyWithUI(graph, baseType);
    }

    public static void createSharedOntologyWithUI(ReadGraph graph, Resource baseType) throws DatabaseException {
        final HashMap<Resource, Pair> map = new HashMap<Resource, Pair>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(L0.IndexRootType, Instances.class);
        for (Resource ontology : Layer0Utils.listOntologies((ReadGraph)graph)) {
            for (Resource type : query.find(graph, ontology)) {
                if (graph.isInheritedFrom(type, SIMU.Model) || graph.hasStatement(type, L0.Abstract) || !graph.isInheritedFrom(type, baseType)) continue;
                String name = (String)graph.getPossibleRelatedValue(type, L0.HasLabel, (Binding)Bindings.STRING);
                if (name == null) {
                    name = (String)graph.getRelatedValue(type, L0.HasName, (Binding)Bindings.STRING);
                }
                map.put(type, new Pair((Object)name, null));
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] result;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                CreateSharedOntologyDialog page = new CreateSharedOntologyDialog(shell, map, "Select type and name of new shared library");
                if (page.open() == 0 && (result = page.getResult()) != null && result.length == 1) {
                    final Resource res = (Resource)result[0];
                    final String name = "http://" + page.getName();
                    Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            Resource target = (Resource)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"createSharedOntology", (ReadGraph)graph, (Object[])new Object[]{String.valueOf(name) + "@A", res});
                            ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            for (Resource dep : graph.getObjects(Simantics.getProjectResource(), L0.IsLinkedTo)) {
                                if (!graph.isInstanceOf(dep, PROJ.NamespaceRequirement)) continue;
                                for (Resource req : graph.getObjects(dep, PROJ.RequiresNamespace)) {
                                    Resource ns;
                                    String uri = (String)graph.getPossibleValue(req, (Binding)Bindings.STRING);
                                    if (uri == null || (ns = graph.getResource(uri)) == null) continue;
                                    graph.claim(target, L0.IsLinkedTo, null, ns);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public static void unlinkSharedOntologyWithUI(ReadGraph graph, Variable variable, final List<Resource> libraries) throws DatabaseException {
        final Resource indexRoot = variable.getPossibleRepresents(graph);
        if (indexRoot == null) {
            return;
        }
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        final ArrayList<String> instances = new ArrayList<String>();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource library : libraries) {
            for (Resource type : ModelingUtils.searchByTypeShallow(graph, library, STR.ComponentType)) {
                for (Resource instance : ModelingUtils.searchByTypeShallow(graph, indexRoot, type)) {
                    if (graph.isInstanceOf(instance, DIA.Element)) continue;
                    String name = Versions.getStandardPathNameString((ReadGraph)graph, (Resource)instance);
                    instances.add(name);
                }
            }
        }
        if (instances.isEmpty()) {
            graph.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    for (Resource library : libraries) {
                        graph.deny(indexRoot, L0.IsLinkedTo, library);
                    }
                }
            });
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ListDialog<String> dialog = new ListDialog<String>(shell, (Collection)instances, "Cannot unlink selected libraries", "Libraries cannot be unlinked since the following instances are referring to them."){

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                    }
                };
                int result = dialog.open();
                if (result != 0) {
                    return;
                }
            }
        });
    }

    public static void importSharedOntology(String fileName) throws Exception {
        try {
            DataContainer dc = DataContainers.readFile((File)new File(fileName));
            TransferableGraph1 tg = (TransferableGraph1)dc.content.getValue(TransferableGraph1.BINDING);
            Variant draftStatus = (Variant)dc.metadata.get(DraftStatusBean.EXTENSION_KEY);
            MigrationUtils.importSharedOntology((Session)Simantics.getSession(), (TransferableGraph1)tg, (draftStatus == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
            throw e;
        }
    }

    public static void importSharedOntologyWithUI(ReadGraph graph, final Variable variable) throws DatabaseException {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StructuredSelection sel = new StructuredSelection((Object)variable);
                ModelingUtils.openWizard(Display.getCurrent(), (IStructuredSelection)sel, "org.simantics.modeling.ui.sharedOntologyImportWizard");
            }
        });
    }

    public static void exportSharedOntologyWithUI(final Resource sharedOntology) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                HintContext hc = new HintContext();
                hc.setHint(SelectionHints.KEY_MAIN, (Object)sharedOntology);
                StructuredSelection sel = new StructuredSelection((Object)hc);
                ModelingUtils.openWizard(Display.getCurrent(), (IStructuredSelection)sel, "org.simantics.modeling.ui.sharedOntologyExportWizard");
            }
        });
    }

    public static void exportSharedOntology(IProgressMonitor monitor, RequestProcessor processor, File location, String format, int version, final LibraryInfo info) throws DatabaseException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Exporting shared library...", 100);
        SimanticsClipboard clipboard = (SimanticsClipboard)processor.syncRequest((Read)new Read<SimanticsClipboard>(){

            public SimanticsClipboard perform(ReadGraph graph) throws DatabaseException {
                CopyHandler ch = (CopyHandler)graph.adapt(info.library.getResource(), CopyHandler.class);
                SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
                ch.copyToClipboard(graph, (SimanticsClipboardBuilder)clipboard);
                return clipboard;
            }
        });
        TreeMap<String, Variant> metadata = ModelingUtils.getExportMetadata();
        DraftStatusBean draft = info.draft;
        if (draft != null) {
            metadata.put(DraftStatusBean.EXTENSION_KEY, new Variant(DraftStatusBean.BINDING, (Object)draft));
        }
        for (Set object : clipboard.getContents()) {
            TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((RequestProcessor)processor, (Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
            monitor.worked(95);
            Variant edb = (Variant)tg.extensions.get(ExternalDownloadBean.EXTENSION_KEY);
            if (edb != null) {
                metadata.put(ExternalDownloadBean.EXTENSION_KEY, edb);
            }
            monitor.setTaskName("Writing transferable graph...");
            DataContainers.writeFile((File)location, (DataContainer)new DataContainer(format, version, metadata, new Variant(TransferableGraph1.BINDING, (Object)tg)));
            monitor.worked(5);
        }
    }

    public static TreeMap<String, Variant> getExportMetadata() {
        TreeMap<String, Variant> metadata = new TreeMap<String, Variant>();
        metadata.put("date", Variant.ofInstance((Object)DateFormat.getDateTimeInstance(0, 0).format(new Date())));
        metadata.put("author", Variant.ofInstance((Object)System.getProperty("user.name", "")));
        return metadata;
    }

    public static void createNewVersionWithoutUI(WriteGraph graph, Resource resource) throws DatabaseException {
        VersionInfo info = (VersionInfo)graph.syncRequest((Read)new VersionInfoRequest(resource));
        int currentVersion = Integer.parseInt(info.version);
        String result = Integer.toString(currentVersion + 1);
        ModelingUtils.createNewVersion(graph, resource, info, result);
    }

    public static void createNewVersionWithUI(ReadGraph graph, final Resource resource) throws DatabaseException {
        final VersionInfo info = (VersionInfo)graph.syncRequest((Read)new VersionInfoRequest(resource));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                CreateVersionDialog dialog = new CreateVersionDialog(shell, info);
                if (dialog.open() == 0) {
                    final String result = dialog.getResult();
                    Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            ModelingUtils.createNewVersion(graph, resource, info, result);
                        }
                    });
                }
            }
        });
    }

    public static void createNewVersion(WriteGraph graph, Resource resource, final VersionInfo info, final String result) throws DatabaseException {
        graph.markUndoPoint();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(resource, L0.PartOf);
        if (parent == null) {
            return;
        }
        final String parentURI = graph.getPossibleURI(parent);
        if (parentURI == null) {
            return;
        }
        Layer0Utils.copyTo((WriteGraph)graph, (Resource)parent, (Resource)resource, (PasteEventHandler)new PasteEventHandler(){

            public void postProcess(WriteGraph graph, Resource root) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                graph.deny(root, L0.Entity_published);
            }

            public IImportAdvisor2 createAdvisor(ReadGraph graph, ImportAdvisorFactory factory, Resource target) throws DatabaseException {
                HashMap context = new HashMap();
                String base = String.valueOf(parentURI) + "/" + URIStringUtils.escape((String)info.baseName) + "@";
                HashMap<String, String> renameMap = new HashMap<String, String>();
                renameMap.put(String.valueOf(base) + info.version, String.valueOf(base) + result);
                renameMap.put(String.valueOf(info.baseName) + "@" + info.version, String.valueOf(info.baseName) + "@" + result);
                context.put("renameMap", renameMap);
                return factory.create(graph, target, context);
            }
        });
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created new version of " + info.baseName));
    }

    public static boolean isUserComponent(ReadGraph graph, Resource type) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(type, STR.ProceduralComponentType)) {
            return true;
        }
        return graph.hasStatement(type, STR.IsDefinedBy);
    }

    public static void publishComponentTypeWithUI(WriteGraph graph, final Resource componentType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource composite = graph.getPossibleObject(componentType, STR.IsDefinedBy);
        final ArrayList<String> instances = new ArrayList<String>();
        if (composite != null) {
            for (Resource component : (Collection)graph.syncRequest((Read)new ObjectsWithType(composite, L0.ConsistsOf, STR.Component))) {
                Resource type = graph.getPossibleType(component, STR.Component);
                if (type == null || !ModelingUtils.isUserComponent((ReadGraph)graph, type) || Layer0Utils.isPublished((ReadGraph)graph, (Resource)type)) continue;
                instances.add(Versions.getStandardPathNameString((ReadGraph)graph, (Resource)component));
            }
        }
        if (instances.isEmpty()) {
            graph.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    ModelingUtils.publish(graph, componentType);
                }
            });
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ListDialog<String> dialog = new ListDialog<String>(shell, (Collection)instances, "Cannot publish user component", "The following instances are referring to unpublished user components."){

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                    }
                };
                int result = dialog.open();
                if (result != 0) {
                    return;
                }
            }
        });
    }

    public static void publishSharedOntologyWithUI(WriteGraph graph, final Resource sharedOntology) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        final ArrayList<String> instances = new ArrayList<String>();
        for (Resource type : ModelingUtils.searchByTypeShallow((ReadGraph)graph, sharedOntology, STR.ComponentType)) {
            if (graph.isInheritedFrom(type, DIA.Element) || Layer0Utils.isPublished((ReadGraph)graph, (Resource)type)) continue;
            instances.add(Versions.getStandardPathNameString((ReadGraph)graph, (Resource)type));
        }
        for (Resource dep : (Collection)graph.syncRequest((Read)new ObjectsWithType(sharedOntology, L0.IsLinkedTo, L0.SharedOntology))) {
            if (Layer0Utils.isPublished((ReadGraph)graph, (Resource)dep)) continue;
            instances.add(Versions.getStandardPathNameString((ReadGraph)graph, (Resource)dep));
        }
        if (instances.isEmpty()) {
            graph.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    ModelingUtils.publish(graph, sharedOntology);
                }
            });
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ListDialog<String> dialog = new ListDialog<String>(shell, (Collection)instances, "Cannot publish shared library", "The following dependencies are unpublished."){

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                    }
                };
                int result = dialog.open();
                if (result != 0) {
                    return;
                }
            }
        });
    }

    public static void createSCLModuleDefault(WriteGraph graph, Resource target) throws DatabaseException {
        String name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)"SCLModule", (Resource)target);
        ModelingUtils.createSCLModule(graph, target, name);
    }

    public static void createSCLModule(WriteGraph graph, Resource target, String name) throws DatabaseException {
        graph.markUndoPoint();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource sclModule = GraphUtils.create2((WriteGraph)graph, (Resource)L0.SCLModule, (Object[])new Object[]{L0.HasName, name, L0.PartOf, target, L0.SCLModule_definition, ""});
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created SCL Module " + name + " " + sclModule.toString()));
    }

    public static void createPGraphDefault(WriteGraph graph, Resource target) throws DatabaseException {
        String name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)"Ontology Definition File", (Resource)target);
        ModelingUtils.createPGraph(graph, target, name);
    }

    public static void createPGraph(WriteGraph graph, Resource target, String name) throws DatabaseException {
        graph.markUndoPoint();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource file = GraphUtils.create2((WriteGraph)graph, (Resource)L0.PGraph, (Object[])new Object[]{L0.HasName, name, L0.PartOf, target, L0.PGraph_definition, ""});
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created Ontology Definition File " + name + " " + file.toString()));
    }

    public static void publish(WriteGraph graph, Resource target) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        graph.claimLiteral(target, L0.Entity_published, (Object)true, (Binding)Bindings.BOOLEAN);
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Published " + graph.getPossibleRelatedValue2(target, L0.HasName, (Binding)Bindings.STRING) + " " + target.toString()));
    }

    public static boolean isLinkedToDeep(ReadGraph graph, Resource r1, Resource r2) throws DatabaseException {
        return (Boolean)graph.syncRequest((Read)new IsLinkedTo(r1, r2));
    }

    public static void openWizard(Display display, IStructuredSelection selection, String id) {
        IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(id);
        }
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(id);
        }
        try {
            if (descriptor != null) {
                IWorkbenchWizard wizard = descriptor.createWizard();
                wizard.init(PlatformUI.getWorkbench(), selection);
                WizardDialog wd = new WizardDialog(display.getActiveShell(), (IWizard)wizard);
                wd.setTitle(wizard.getWindowTitle());
                wd.open();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static String withinEpsilon(double value, double reference, double epsilon) {
        if (Math.abs(value - reference) < epsilon) {
            return "True";
        }
        return "Not within epsilon value=" + value + ", reference=" + reference + " , epsilon=" + epsilon;
    }

    public static boolean needsIdentifier(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection types = graph.getPrincipalTypes(r);
        for (Resource type : types) {
            if (!((Boolean)graph.syncRequest((AsyncRead)new IsInstanceOf(type, L0.TypeWithIdentifier), (AsyncListener)TransientCacheAsyncListener.instance())).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean needsModificationInfo(ReadGraph graph, Resource r) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Collection types = graph.getPrincipalTypes(r);
        for (Resource type : types) {
            if (!((Boolean)graph.syncRequest((AsyncRead)new IsInstanceOf(type, MOD.TypeWithChangeInformation), (AsyncListener)TransientCacheAsyncListener.instance())).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static void attachCreationInformation(IProgressMonitor monitor, WriteGraph graph, Resource model) throws DatabaseException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String author = System.getProperty("user.name", "");
        long time = System.currentTimeMillis();
        monitor.setTaskName("Attach creation information");
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        List<Resource> rs = ModelingUtils.searchByType((ReadGraph)graph, model, MOD.TypeWithChangeInformation);
        Set<Resource> supers = ModelingUtils.getMostUnspecificTypes((ReadGraph)graph, rs);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set set = cs.createSet();
        for (Resource type : supers) {
            set.addAll(ModelingUtils.searchByTypeShallow((ReadGraph)graph, model, type));
        }
        List instances = Layer0Utils.sortByCluster((ReadGraph)graph, (Collection)set);
        int pc = instances.size() / 100;
        int done = 0;
        int stint = pc;
        for (Resource instance : instances) {
            ChangeInformation info = (ChangeInformation)graph.getPossibleRelatedValue(instance, MOD.changeInformation, ChangeInformation.BINDING);
            if (info == null) {
                info = new ChangeInformation();
                info.createdAt = time;
                info.createdBy = author;
                info.modifiedAt = time;
                info.modifiedBy = author;
                graph.claimLiteral(instance, MOD.changeInformation, MOD.changeInformation_Inverse, MOD.ChangeInformation, (Object)info, ChangeInformation.BINDING);
            }
            ++done;
            if (--stint != 0) continue;
            Double d = 100.0 * (double)done / (double)instances.size();
            monitor.setTaskName("Attach creation information " + d.intValue() + "%");
            stint = pc;
        }
        monitor.setTaskName("Attach creation information - commit");
    }

    public static CompositeInfo parseCompositeNameFromRoot(Root root, boolean applyPaths, boolean useGuids) {
        return CompositeInfo.parse(root.name, applyPaths, useGuids);
    }

    public static CompositeInfo parseCompositeNameFromRoot(Identity root, boolean applyPaths, boolean useGuids) {
        String coded = TransferableGraphUtils.getName((Identity)root);
        return CompositeInfo.parse(coded, applyPaths, useGuids);
    }

    private static StringBuilder getDiagramCompositePathInternal(ReadGraph graph, Resource folder, StringBuilder builder) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource model = graph.getPossibleObject(folder, SIMU.IsConfigurationOf);
        if (model != null) {
            return builder;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(folder, L0.HasName, (Binding)Bindings.STRING);
        if (name == null) {
            return null;
        }
        Resource parent = graph.getPossibleObject(folder, L0.PartOf);
        if (parent == null) {
            return null;
        }
        StringBuilder sb = ModelingUtils.getDiagramCompositePathInternal(graph, parent, builder);
        if (sb == null) {
            return null;
        }
        if (sb.length() > 0) {
            sb.append('/');
        }
        sb.append(URIStringUtils.escape((String)name));
        return sb;
    }

    public static String getDiagramCompositePath(ReadGraph graph, Resource diagram) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(diagram, L0.PartOf);
        if (parent == null) {
            return null;
        }
        StringBuilder sb = ModelingUtils.getDiagramCompositePathInternal(graph, parent, new StringBuilder());
        return sb != null ? sb.toString() : null;
    }

    public static void exportModel(ReadGraph graph, Resource model, String fileName, String format, int version) throws DatabaseException {
        try {
            TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2(graph, model, true, false);
            TransferableGraphSource s = (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));
            TransferableGraphs.writeTransferableGraph((RequestProcessor)graph, (String)format, (int)version, (TransferableGraphSource)s, (File)new File(fileName));
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void exportSharedOntology(ReadGraph graph, Resource library, String fileName, String format, int version) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getRelatedValue(library, L0.HasName, (Binding)Bindings.STRING);
        DraftStatusBean draft = null;
        boolean published = Layer0Utils.isPublished((ReadGraph)graph, (Resource)library);
        if (!published) {
            draft = new DraftStatusBean(new String[0]);
        }
        LibraryInfo info = new LibraryInfo(name, library, draft);
        try {
            ModelingUtils.exportSharedOntology((IProgressMonitor)new NullProgressMonitor(), (RequestProcessor)graph, new File(fileName), format, version, info);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static DraftStatusBean getDependencyDraftStatus(ReadGraph graph, Resource library) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<String> drafts = new ArrayList<String>();
        for (Resource shared : (Collection)graph.syncRequest((Read)new ObjectsWithType(library, L0.IsLinkedTo, L0.SharedOntology))) {
            boolean published = Layer0Utils.isPublished((ReadGraph)graph, (Resource)shared);
            if (published) continue;
            drafts.add(graph.getURI(shared));
        }
        return drafts.isEmpty() ? null : new DraftStatusBean(drafts);
    }

    public static Set<Resource> getMostUnspecificTypes(ReadGraph graph, Collection<Resource> types) throws DatabaseException {
        HashSet<Resource> work = new HashSet<Resource>(types);
        for (Resource type : types) {
            Set supers = graph.getSupertypes(type);
            if (Collections.disjoint(supers, work)) continue;
            work.remove(type);
        }
        return work;
    }

    public static void rewriteGUIDS(WriteGraph graph, Resource root, boolean deep) throws DatabaseException {
        ArrayList<Resource> todo = new ArrayList<Resource>();
        todo.add(root);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        while (!todo.isEmpty()) {
            Resource resource = (Resource)todo.remove(todo.size() - 1);
            graph.claimLiteral(resource, L0.identifier, L0.GUID, (Object)GUID.random(), GUID.BINDING);
            if (!deep) continue;
            todo.addAll(graph.getObjects(resource, L0.ConsistsOf));
        }
    }

    public static void createMissingGUIDs(IProgressMonitor monitor, WriteGraph graph, Collection<Resource> roots) throws DatabaseException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        QueryMemoryWatcher memory = new QueryMemoryWatcher((ReadGraph)graph, 50000);
        for (Resource root : roots) {
            boolean madeChanges = false;
            monitor.setTaskName("Creating missing GUID identifiers " + NameUtils.getSafeName((ReadGraph)graph, (Resource)root));
            Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(root));
            for (Resource r : ModelingUtils.searchByType((ReadGraph)graph, indexRoot, L0.Entity)) {
                GUID existing;
                memory.maintain();
                if (graph.isImmutable(r) || !ModelingUtils.needsIdentifier((ReadGraph)graph, r) || (existing = (GUID)graph.getPossibleRelatedValue(r, L0.identifier, GUID.BINDING)) != null) continue;
                graph.addLiteral(r, L0.identifier, L0.identifier_Inverse, L0.GUID, (Object)GUID.random(), GUID.BINDING);
                madeChanges = true;
            }
            if (!madeChanges) continue;
            ModelingUtils.deleteIndex(graph, root);
        }
    }

    public static boolean activateModel(WriteGraph graph, Resource model) throws DatabaseException {
        return (Boolean)graph.syncRequest((WriteResult)new ActivateModel(Simantics.getProjectResource(), model));
    }

    public static File fileDialog(String title, List<Tuple> namesAndExtensions) {
        Display display = Display.getCurrent();
        Shell shell = display.getActiveShell();
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setText(title);
        String[] extensions = new String[namesAndExtensions.size()];
        String[] filterNames = new String[namesAndExtensions.size()];
        int index = 0;
        for (Tuple t : namesAndExtensions) {
            String filterName = (String)t.get(0);
            String extension = (String)t.get(1);
            filterNames[index] = filterName;
            extensions[index] = extension;
            ++index;
        }
        dialog.setFilterExtensions(extensions);
        dialog.setFilterNames(filterNames);
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        return new File(fileName);
    }

    public static Resource createLibrary(WriteGraph graph, Resource parent) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        return ModelingUtils.createLibrary(graph, parent, NameUtils.findFreshName((ReadGraph)graph, (String)"Library", (Resource)parent, (Resource)l0.ConsistsOf));
    }

    public static Resource createLibrary(WriteGraph graph, Resource parent, String name) throws DatabaseException {
        graph.markUndoPoint();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource library = graph.newResource();
        graph.claim(library, l0.InstanceOf, null, l0.Library);
        graph.addLiteral(library, l0.HasName, l0.NameOf, l0.String, (Object)name, (Binding)Bindings.STRING);
        graph.claim(library, l0.PartOf, parent);
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created new Library named " + name + ", resource " + library));
        return library;
    }

    private static class AnnotationMap {
        public final Resource sourcePredicate;
        public final Resource sourcePredicateInverse;
        public final Resource annotationPredicate;
        public final Resource annotationPredicateInverse;
        public final Resource defaultValueType;
        public final Object defaultValue;
        public final Binding defaultValueBinding;

        public AnnotationMap(Resource sp, Resource spi, Resource tp, Resource tpi, Resource defaultValueType, Object defaultValue, Binding defaultValueBinding) {
            this.sourcePredicate = sp;
            this.sourcePredicateInverse = spi;
            this.annotationPredicate = tp;
            this.annotationPredicateInverse = tpi;
            this.defaultValueType = defaultValueType;
            this.defaultValue = defaultValue;
            this.defaultValueBinding = defaultValueBinding;
        }
    }

    static class AnnotationMapRequest
    extends ResourceRead2<List<AnnotationMap>> {
        public AnnotationMapRequest(Resource annotationType, Resource sourceType) {
            super(annotationType, sourceType);
        }

        public List<AnnotationMap> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ArrayList<AnnotationMap> result = new ArrayList<AnnotationMap>();
            HashMap<String, Resource> annotationPredicates = new HashMap<String, Resource>();
            for (Resource predicate : graph.getObjects(this.resource, L0.DomainOf)) {
                String name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                annotationPredicates.put(name, predicate);
            }
            HashMap<String, Resource> sourcePredicates = new HashMap<String, Resource>();
            for (Resource predicate : graph.getObjects(this.resource2, L0.DomainOf)) {
                String name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                sourcePredicates.put(name, predicate);
            }
            for (String key : sourcePredicates.keySet()) {
                Resource object;
                Resource sourcePredicate = (Resource)sourcePredicates.get(key);
                Resource anno = (Resource)annotationPredicates.get(key);
                if (sourcePredicate == null || anno == null) continue;
                Resource defaultValueType = graph.getSingleObject(anno, L0.HasRange);
                Binding defaultValueBinding = null;
                Object defaultValue = null;
                Resource assertion = graph.getPossibleObject(anno, L0.HasPredicateInverse);
                if (assertion != null && (object = graph.getPossibleObject(assertion, L0.HasObject)) != null && graph.isInstanceOf(object, L0.Literal)) {
                    Datatype dt = graph.getDataType(object);
                    defaultValueBinding = Bindings.getBeanBinding((Datatype)dt);
                    defaultValue = graph.getPossibleValue(object);
                }
                result.add(new AnnotationMap(sourcePredicate, graph.getInverse(sourcePredicate), anno, graph.getInverse(anno), defaultValueType, defaultValue, defaultValueBinding));
            }
            return result;
        }
    }

    public static class CompositeInfo {
        public static String COMPOSITE_PREFIX = "composite:";
        private final boolean useGuids;
        private final boolean applyPaths;
        private final String path;
        private final String name;
        private final GUID guid;

        private CompositeInfo(boolean useGuids, boolean applyPaths, String path, String name, GUID guid) {
            this.useGuids = useGuids;
            this.applyPaths = applyPaths;
            this.path = path;
            this.name = name;
            this.guid = guid;
        }

        public String toString() {
            return "CompositeInfo[useGuids=" + this.useGuids + ", applyPaths=" + this.applyPaths + ", path=" + this.path + ", name=" + this.name + ", guid=" + this.guid.indexString() + "]";
        }

        public static boolean isComposite(String tgName) {
            return tgName.startsWith(COMPOSITE_PREFIX);
        }

        public String getTGName() {
            return String.valueOf(COMPOSITE_PREFIX) + this.getOriginalPath() + COMPOSITE_SEPARATOR_CHAR + this.getEscapedName() + COMPOSITE_SEPARATOR_CHAR + this.guid.indexString();
        }

        public boolean existsGUID(ReadGraph graph, Resource indexRoot) throws DatabaseException {
            List<Resource> res = ModelingUtils.searchByGUID(graph, indexRoot, this.guid);
            return !res.isEmpty();
        }

        public static CompositeInfo fromResource(ReadGraph graph, Resource resource) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            GUID rootId = (GUID)graph.getRelatedValue(resource, L0.identifier, GUID.BINDING);
            String rootName = (String)graph.getRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING);
            String escapedRootName = URIStringUtils.escape((String)rootName);
            String escapedPath = ModelingUtils.getDiagramCompositePath(graph, resource);
            return new CompositeInfo(true, true, escapedPath, escapedRootName, rootId);
        }

        public static CompositeInfo parse(String tgName) {
            return CompositeInfo.parse(tgName, true, true);
        }

        public static CompositeInfo parse(String tgName, boolean applyPaths, boolean useGuids) {
            if (!tgName.startsWith(COMPOSITE_PREFIX)) {
                return null;
            }
            if (!(tgName = tgName.substring(COMPOSITE_PREFIX.length())).contains(COMPOSITE_SEPARATOR)) {
                if (useGuids) {
                    throw new IllegalStateException("GUID identifiers were not found for diagrams.");
                }
                return new CompositeInfo(useGuids, applyPaths, null, tgName, null);
            }
            String[] parts = tgName.split(COMPOSITE_SEPARATOR);
            if (parts.length == 2) {
                String path;
                String name = parts[1];
                String string = path = applyPaths ? parts[0] : null;
                if (useGuids) {
                    throw new IllegalStateException("GUID identifiers were not found for diagrams.");
                }
                return new CompositeInfo(useGuids, applyPaths, path, name, null);
            }
            if (parts.length == 3) {
                String path = parts[0];
                String name = parts[1];
                GUID guid = GUID.parseIndexString((String)parts[2]);
                return new CompositeInfo(useGuids, applyPaths, path, name, guid);
            }
            return null;
        }

        public GUID getGUID() {
            return this.guid;
        }

        public String getEscapedName() {
            return this.name;
        }

        public String getUnescapedName() {
            return URIStringUtils.unescape((String)this.name);
        }

        public String getOriginalPath() {
            return this.path;
        }

        public String getFinalPath() {
            if (this.applyPaths) {
                return this.path;
            }
            return null;
        }

        public CompositeInfo renamed(String newName) {
            return new CompositeInfo(this.useGuids, this.applyPaths, this.path, newName, this.guid);
        }

        public String getStateKey() {
            return String.valueOf(this.path) + "#" + this.getEscapedName();
        }

        private Resource getFromFolder(ReadGraph graph, Resource target) throws DatabaseException {
            Resource diagram = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)target, (String)URIStringUtils.unescape((String)this.name));
            if (diagram == null) {
                return null;
            }
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            return graph.isInstanceOf(diagram, STR.Composite) ? diagram : null;
        }

        public Resource resolve(ReadGraph graph, Resource target) throws DatabaseException {
            Resource indexRoot;
            List<Resource> queryResult;
            if (this.useGuids && this.guid != null && (queryResult = ModelingUtils.searchByGUID(graph, indexRoot = (Resource)graph.syncRequest((Read)new IndexRoot(target)), this.guid)).size() == 1) {
                Resource composite = (Resource)queryResult.iterator().next();
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                if (!graph.isInstanceOf(composite, STR.Composite)) {
                    return null;
                }
                return composite;
            }
            if (this.applyPaths) {
                Resource folder = this.resolveFolder(graph, target);
                if (folder == null) {
                    return null;
                }
                return this.getFromFolder(graph, folder);
            }
            return this.getFromFolder(graph, target);
        }

        public Resource resolveFolder(ReadGraph graph, Resource target) throws DatabaseException {
            String path = this.getFinalPath();
            if (path == null) {
                return target;
            }
            Resource folder = (Resource)graph.syncRequest((Read)new Configuration(target));
            String[] segments = path.split("/");
            int i = 0;
            while (i < segments.length) {
                if (!segments[i].isEmpty() && (folder = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)folder, (String)URIStringUtils.unescape((String)segments[i]))) == null) {
                    return null;
                }
                ++i;
            }
            return folder;
        }

        public int hashCode() {
            if (this.useGuids) {
                return this.guid.hashCode();
            }
            int result = this.name.hashCode();
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompositeInfo other = (CompositeInfo)obj;
            if (this.useGuids) {
                return this.guid.equals((Object)other.guid);
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            return !this.applyPaths || this.path.equals(other.path);
        }
    }

    public static class DiagramComponentInfo {
        private static String CHILD_PREFIX = "child:";
        private final String compositePathAndName;
        private final String componentName;
        private final GUID guid;

        public DiagramComponentInfo(String compositePathAndName, String componentName, GUID guid) {
            this.compositePathAndName = compositePathAndName;
            this.componentName = componentName;
            this.guid = guid;
        }

        public static boolean isDiagramComponent(String tgName) {
            return tgName.startsWith(CHILD_PREFIX);
        }

        public String getTGName(CompositeInfo info) {
            return String.valueOf(CHILD_PREFIX) + info.getOriginalPath() + COMPOSITE_SEPARATOR_CHAR + info.getEscapedName() + COMPOSITE_SEPARATOR_CHAR + this.getEscapedComponentName() + COMPOSITE_SEPARATOR_CHAR + this.guid.indexString();
        }

        public boolean existsGUID(ReadGraph graph, Resource indexRoot) throws DatabaseException {
            List<Resource> res = ModelingUtils.searchByGUID(graph, indexRoot, this.guid);
            return !res.isEmpty();
        }

        public static DiagramComponentInfo fromResource(ReadGraph graph, CompositeInfo info, Resource resource) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            GUID childId = (GUID)graph.getRelatedValue(resource, L0.identifier, GUID.BINDING);
            String childName = (String)graph.getRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING);
            return new DiagramComponentInfo(info.getStateKey(), URIStringUtils.escape((String)childName), childId);
        }

        public GUID getGUID() {
            return this.guid;
        }

        public String getEscapedCompositePathAndName() {
            return this.compositePathAndName;
        }

        public String getEscapedComponentName() {
            return this.componentName;
        }

        public String getUnescapedComponentName() {
            return URIStringUtils.unescape((String)this.getEscapedComponentName());
        }

        public static DiagramComponentInfo parse(String tgName) {
            String name = tgName.substring(CHILD_PREFIX.length());
            String compositePathAndName = "";
            String moduleName = name;
            GUID guid = GUID.invalid();
            int lastHash = name.lastIndexOf(COMPOSITE_SEPARATOR_CHAR);
            if (lastHash >= 0) {
                String first = name.substring(0, lastHash);
                String second = name.substring(lastHash + 1);
                lastHash = first.lastIndexOf(COMPOSITE_SEPARATOR_CHAR);
                if (lastHash >= 0) {
                    compositePathAndName = first.substring(0, lastHash);
                    moduleName = first.substring(lastHash + 1);
                    guid = GUID.parseIndexString((String)second);
                } else {
                    compositePathAndName = first;
                    moduleName = second;
                }
            }
            return new DiagramComponentInfo(compositePathAndName, moduleName, guid);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.compositePathAndName == null ? 0 : this.compositePathAndName.hashCode());
            result = 31 * result + (this.componentName == null ? 0 : this.componentName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DiagramComponentInfo other = (DiagramComponentInfo)obj;
            if (this.compositePathAndName == null ? other.compositePathAndName != null : !this.compositePathAndName.equals(other.compositePathAndName)) {
                return false;
            }
            return !(this.componentName == null ? other.componentName != null : !this.componentName.equals(other.componentName));
        }
    }

    public static class LibraryInfo
    implements Comparable<LibraryInfo> {
        public NamedResource library;
        public DraftStatusBean draft;

        public LibraryInfo(String name, Resource r, DraftStatusBean draft) {
            this.library = new NamedResource(name, r);
            this.draft = draft;
        }

        @Override
        public int compareTo(LibraryInfo o) {
            return this.library.compareTo(o.library);
        }

        public int hashCode() {
            return this.library.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof LibraryInfo)) {
                return false;
            }
            LibraryInfo info = (LibraryInfo)object;
            return info.library.equals((Object)this.library);
        }
    }
}

