/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.nativemem;

public class ProcessMemoryCounters {
    public int PageFaultCount;
    public long PeakWorkingSetSize;
    public long WorkingSetSize;
    public long QuotaPeakPagedPoolUsage;
    public long QuotaPagedPoolUsage;
    public long QuotaPeakNonPagedPoolUsage;
    public long QuotaNonPagedPoolUsage;
    public long PagefileUsage;
    public long PeakPagefileUsage;
    public long PrivateUsage;

    public String toString() {
        return "ProcessMemoryCounters [PageFaultCount=" + this.PageFaultCount + ", PeakWorkingSetSize=" + this.PeakWorkingSetSize + ", WorkingSetSize=" + this.WorkingSetSize + ", QuotaPeakPagedPoolUsage=" + this.QuotaPeakPagedPoolUsage + ", QuotaPagedPoolUsage=" + this.QuotaPagedPoolUsage + ", QuotaPeakNonPagedPoolUsage=" + this.QuotaPeakNonPagedPoolUsage + ", QuotaNonPagedPoolUsage=" + this.QuotaNonPagedPoolUsage + ", PagefileUsage=" + this.PagefileUsage + ", PeakPagefileUsage=" + this.PeakPagefileUsage + ", PrivateUsage=" + this.PrivateUsage + "]";
    }

    public String toHumanReadableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProcessMemoryCounters [\n\tPageFaultCount             = ").append(this.PageFaultCount).append(",\n\tPeakWorkingSetSize         = ").append(this.toMb(this.PeakWorkingSetSize)).append(" MB,\n\tWorkingSetSize             = ").append(this.toMb(this.WorkingSetSize)).append(" MB,\n\tQuotaPeakPagedPoolUsage    = ").append(this.toMb(this.QuotaPeakPagedPoolUsage)).append(" MB,\n\tQuotaPagedPoolUsage        = ").append(this.toMb(this.QuotaPagedPoolUsage)).append(" MB,\n\tQuotaPeakNonPagedPoolUsage = ").append(this.toMb(this.QuotaPeakNonPagedPoolUsage)).append(" MB,\n\tQuotaNonPagedPoolUsage     = ").append(this.toMb(this.QuotaNonPagedPoolUsage)).append(" MB,\n\tPagefileUsage              = ").append(this.toMb(this.PagefileUsage)).append(" MB,\n\tPeakPagefileUsage          = ").append(this.toMb(this.PeakPagefileUsage)).append(" MB,\n\tPrivateUsage               = ").append(this.toMb(this.PrivateUsage)).append(" MB]");
        return sb.toString();
    }

    private double toMb(long bytes) {
        return (double)bytes / 1048576.0;
    }
}

